/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.debugger;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import org.netbeans.jellytools.actions.Action;
import org.netbeans.jellytools.actions.CopyAction;
import org.netbeans.jellytools.actions.FindAction;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class TermOperator
extends ComponentOperator {
    ComponentOperator[] _screen = new ComponentOperator[5];
    JComponent[] _term = new JComponent[5];
    private static final Action findNextAction = new Action(null, "Find Next");
    private static final Action selectAllAction = new Action(null, "Select All");
    private static final Action clearAction = new Action(null, "Clear Output");
    private static final Action startRedirectionAction = new Action(null, "Start Redirection of This View to File");
    private static final Action stopRedirectionAction = new Action(null, "Stop Redirection of This View to File");
    private static final CopyAction copyAction = new CopyAction();
    private static final FindAction findAction = new FindAction();

    public TermOperator(JComponent jComponent) {
        super((Component)jComponent);
    }

    public TermOperator(ContainerOperator containerOperator, String string) {
        this(containerOperator, string, 0);
    }

    public TermOperator(ContainerOperator containerOperator, int n) {
        this(containerOperator, null, n);
    }

    public TermOperator(ContainerOperator containerOperator, String string, int n) {
        super(containerOperator.waitSubComponent((ComponentChooser)new InnerTabSubchooser(string), n));
        this.makeComponentVisible();
        this.copyEnvironment((Operator)containerOperator);
    }

    public TermOperator(ContainerOperator containerOperator) {
        super(containerOperator);
    }

    public JComponent getTermSource() {
        return this.getTermSource(0);
    }

    public JComponent getTermSource(int n) {
        if (n >= this._term.length) {
            return (JComponent)ComponentOperator.waitComponent((Container)((Container)this.getSource()), (ComponentChooser)new TermFinder(), (int)n);
        }
        if (this._term[n] == null) {
            this._term[n] = (JComponent)ComponentOperator.waitComponent((Container)((Container)this.getSource()), (ComponentChooser)new TermFinder(), (int)n);
        }
        return this._term[n];
    }

    public int findRow(String string) {
        return this.findRow(string, 0);
    }

    public int findRow(String string, int n) {
        for (int i = 0; i < this.getLineCount(n); ++i) {
            if (!this.getComparator().equals(this.getRowText(i, n), string)) continue;
            return i;
        }
        return -1;
    }

    public String getText() {
        return this.getText(0);
    }

    public String getText(int n) {
        this.flush(n);
        return this.getText(0, this.getLineCount(n) - 1, n);
    }

    public String getText(int n, int n2) {
        return this.getText(n, n2);
    }

    public String getText(int n, int n2, int n3) {
        this.flush(n3);
        String string = "";
        for (int i = n; i < n2; ++i) {
            string = string + this.getRowText(i, n3) + "\n";
        }
        return string;
    }

    public void waitText(String string) {
        this.waitText(string, 0);
    }

    public void waitText(final String string, final int n) {
        this.getOutput().printLine("Wait \"" + string + "\" text in component \n    : " + this.getTermSource(n).toString());
        this.getOutput().printGolden("Wait \"" + string + "\" text");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                return TermOperator.this.findRow(string, n) > -1;
            }

            public String getDescription() {
                return "\"" + string + "\" text";
            }
        });
    }

    public int getLineCount() {
        return this.getLineCount(0);
    }

    public int getLineCount(int n) {
        this.flush(n);
        return this.getCursorRow(n) + 1;
    }

    public ComponentOperator screen() {
        return this.screen(0);
    }

    public ComponentOperator screen(int n) {
        if (n >= this._screen.length || this._screen[n] == null) {
            ComponentOperator componentOperator = ComponentOperator.createOperator((Component)ComponentOperator.waitComponent((Container)this.getTermSource(n), (ComponentChooser)new ScreenFinder()));
            componentOperator.copyEnvironment((Operator)this);
            if (n < this._screen.length) {
                this._screen[n] = componentOperator;
            }
            return componentOperator;
        }
        return this._screen[n];
    }

    public String getRowText(int n) {
        return this.getRowText(n, 0);
    }

    public String getRowText(int n, int n2) {
        return (String)this.runMapping(new Operator.MapAction("getRowText"){

            public Object map() {
                return null;
            }
        });
    }

    public String textWithin(int n, int n2, int n3, int n4) {
        return this.textWithin(n, n2, n3, n4, 0);
    }

    public String textWithin(int n, int n2, int n3, int n4, int n5) {
        Object var6_6 = null;
        Object var7_7 = null;
        return (String)this.runMapping(new Operator.MapAction("textWithin"){

            public Object map() {
                return null;
            }
        });
    }

    public int getCursorRow() {
        return this.getCursorRow(0);
    }

    public int getCursorRow(int n) {
        return this.runMapping(new Operator.MapIntegerAction("getCursorRow"){

            public int map() {
                return 0;
            }
        });
    }

    public void flush() {
        this.flush(0);
    }

    public void flush(int n) {
        this.runMapping(new Operator.MapVoidAction("flush"){

            public void map() {
            }
        });
    }

    public void verify() {
        this.screen();
    }

    public void copy() {
    }

    public void find() {
    }

    public void findNext() {
    }

    public void selectAll() {
    }

    public void clearOutput() {
    }

    public void startRedirection() {
    }

    public void stopRedirection() {
    }

    public void discard() {
    }

    public void discardAll() {
    }

    public void close() {
    }

    private static final class InnerTabSubchooser
    implements ComponentChooser {
        private String termName;

        public InnerTabSubchooser() {
        }

        public InnerTabSubchooser(String string) {
            this.termName = string;
        }

        public boolean checkComponent(Component component) {
            if (component.getClass().getName().endsWith("OutputTabInner")) {
                return Operator.getDefaultStringComparator().equals(component.getName(), this.termName);
            }
            return false;
        }

        public String getDescription() {
            return "org.netbeans.core.output.OutputTabInner";
        }
    }

    static class TermFinder
    implements ComponentChooser {
        TermFinder() {
        }

        public boolean checkComponent(Component component) {
            return false;
        }

        public String getDescription() {
            return "org.netbeans.lib.terminalemulator.Term";
        }
    }

    static class ScreenFinder
    implements ComponentChooser {
        ScreenFinder() {
        }

        public boolean checkComponent(Component component) {
            Class<?> clazz = component.getClass();
            do {
                if (!clazz.getName().equals("org.netbeans.lib.terminalemulator.Screen")) continue;
                return true;
            } while ((clazz = clazz.getSuperclass()) != null);
            return false;
        }

        public String getDescription() {
            return "Screen component";
        }
    }
}

