/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.model.project;

import java.io.File;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComboBoxOperator;
import org.netbeans.jemmy.operators.JDialogOperator;
import org.netbeans.jemmy.operators.JTextFieldOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.modules.visualweb.gravy.Bundle;
import org.netbeans.modules.visualweb.gravy.ProjectNavigatorOperator;
import org.netbeans.modules.visualweb.gravy.TestUtils;
import org.netbeans.modules.visualweb.gravy.model.project.JSFWebProject;
import org.netbeans.modules.visualweb.gravy.model.project.Project;
import org.netbeans.modules.visualweb.gravy.model.project.ProjectDescriptor;
import org.netbeans.modules.visualweb.gravy.model.project.ProjectFactory;

public class DefaultProjectFactory
extends ProjectFactory {
    private static final String bundle = "org.netbeans.modules.visualweb.gravy.model.project.Bundle";
    private static final String projectType = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "ProjectWizardBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "ProjectType"));
    private static final String projectCategory = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "ProjectWizardBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "ProjectCategory"));
    private static final String blueprintsStructure = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "J2EEProjectsBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "JavaBluePrints"));
    private static final String jakartaStructure = Bundle.getStringTrimmed(Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "J2EEProjectsBundle"), Bundle.getStringTrimmed("org.netbeans.modules.visualweb.gravy.model.project.Bundle", "Jakarta"));
    private static DefaultProjectFactory defaultPFactory;

    public static DefaultProjectFactory getFactory() {
        if (defaultPFactory != null) {
            return defaultPFactory;
        }
        defaultPFactory = new DefaultProjectFactory();
        return defaultPFactory;
    }

    protected Project createProject(ProjectDescriptor projectDescriptor) {
        String string = projectDescriptor.getProperty("projectLocation");
        String string2 = projectDescriptor.getProperty("projectName");
        String string3 = projectDescriptor.getProperty("J2EEVersion");
        String string4 = projectDescriptor.getProperty("targetServer");
        if (string.lastIndexOf(File.separator) != string.length() - 1) {
            string = string + File.separator;
        }
        try {
            TestUtils.createNewProject(string, string2, true, projectType, projectCategory, blueprintsStructure, string3, string4);
        }
        catch (Exception exception) {
            throw new JemmyException("Project can't be created!", (Throwable)exception);
        }
        return new JSFWebProject(projectDescriptor);
    }

    protected Project openProject(String string) {
        try {
            TestUtils.openProject(string);
        }
        catch (Exception exception) {
            throw new JemmyException("Project can't be opened!", (Throwable)exception);
        }
        String string2 = string.substring(string.lastIndexOf(File.separator) + 1, string.length());
        String string3 = string.substring(0, string.lastIndexOf(File.separator) + 1);
        ProjectNavigatorOperator.pressPopupItemOnNode(string2, "Properties");
        JDialogOperator jDialogOperator = new JDialogOperator("Project Properties - " + string2);
        TestUtils.wait(1000);
        JTreeOperator jTreeOperator = new JTreeOperator((ContainerOperator)jDialogOperator);
        jTreeOperator.selectPath(jTreeOperator.findPath("Run"));
        TestUtils.wait(1000);
        String string4 = new JComboBoxOperator((ContainerOperator)jDialogOperator).getSelectedItem().toString();
        String string5 = new JTextFieldOperator((ContainerOperator)jDialogOperator, 0).getText();
        new JButtonOperator((ContainerOperator)jDialogOperator, "OK").pushNoBlock();
        TestUtils.wait(1000);
        System.out.println("projectName=" + string2 + "; projectLocation=" + string3 + "; J2EEVersion=" + string5 + "; targetServer=" + string4);
        ProjectDescriptor projectDescriptor = new ProjectDescriptor(string2, string3, string5, string4);
        return new JSFWebProject(projectDescriptor);
    }
}

