/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.gravy.nodes;

import java.awt.Component;
import java.util.ArrayList;
import javax.swing.tree.TreePath;
import org.netbeans.jellytools.Bundle;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.netbeans.jemmy.operators.JTreeOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.modules.visualweb.gravy.actions.Action;
import org.netbeans.modules.visualweb.gravy.actions.ActionNoBlock;
import org.openide.explorer.view.Visualizer;

public class Node {
    static final String linkSuffix = Bundle.getString((String)"org.openide.loaders.Bundle", (String)"FMT_shadowName", (Object[])new String[]{""});
    protected JTreeOperator treeOperator;
    protected TreePath treePath;
    private Operator.StringComparator comparator;

    public Node(JTreeOperator jTreeOperator, String string) {
        this(jTreeOperator, jTreeOperator.findPath(string, "|"));
    }

    public Node(JTreeOperator jTreeOperator, String string, String string2) {
        this(jTreeOperator, jTreeOperator.findPath(string, string2, "|"));
    }

    public Node(Node node, String string) {
        this(node.tree(), node.findSubPath(string, "|"));
    }

    public Node(Node node, int n) {
        this(node.tree(), node.tree().getChildPath(node.getTreePath(), n));
    }

    public Node(JTreeOperator jTreeOperator, TreePath treePath) {
        this.treeOperator = jTreeOperator;
        this.treePath = treePath;
    }

    public void setComparator(Operator.StringComparator stringComparator) {
        this.comparator = stringComparator;
        this.tree().setComparator(stringComparator);
    }

    public Operator.StringComparator getComparator() {
        if (this.comparator == null) {
            this.comparator = this.tree().getComparator();
        }
        return this.comparator;
    }

    public JTreeOperator tree() {
        return this.treeOperator;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public String getText() {
        return this.treePath.getLastPathComponent().toString();
    }

    private static String convertPath(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        int n = treePath.getPathCount();
        if (n < 2) {
            return "";
        }
        String string = treePath.getPathComponent(1).toString();
        for (int i = 2; i < n; ++i) {
            string = string + "|" + treePath.getPathComponent(i).toString();
        }
        return string;
    }

    public String getPath() {
        return Node.convertPath(this.treePath);
    }

    public String getParentPath() {
        return Node.convertPath(this.treePath.getParentPath());
    }

    public Object getOpenideNode() {
        return Visualizer.findNode((Object)this.getTreePath().getLastPathComponent());
    }

    public JPopupMenuOperator callPopup() {
        return new JPopupMenuOperator(this.treeOperator.callPopupOnPath(this.treePath));
    }

    public void performMenuAction(String string) {
        new Action(string, null).performMenu(this);
    }

    public void performPopupAction(String string) {
        new Action(null, string).performPopup(this);
    }

    public void performAPIAction(String string) {
        new Action(null, null, string).performAPI(this);
    }

    public void performMenuActionNoBlock(String string) {
        new ActionNoBlock(string, null).performMenu(this);
    }

    public void performPopupActionNoBlock(String string) {
        new ActionNoBlock(null, string).performPopup(this);
    }

    public void performAPIActionNoBlock(String string) {
        new ActionNoBlock(null, null, string).performAPI(this);
    }

    public void select() {
        this.tree().selectPath(this.getTreePath());
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            throw new JemmyException("Sleeping interrupted", (Throwable)exception);
        }
    }

    public void addSelectionPath() {
        this.tree().addSelectionPath(this.getTreePath());
    }

    public boolean isLeaf() {
        return this.tree().getChildCount(this.treePath) < 1;
    }

    public String[] getChildren() {
        this.tree().expandPath(this.treePath);
        Object[] objectArray = this.tree().getChildren(this.treePath.getLastPathComponent());
        if (objectArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    public boolean isLink() {
        return this.getText().endsWith(linkSuffix);
    }

    public boolean isPresent() {
        this.tree().expandPath(this.treePath.getParentPath());
        return this.tree().getRowForPath(this.treePath) >= 0;
    }

    public void verifyPopup(String string) {
        this.verifyPopup(new String[]{string});
    }

    public void verifyPopup(String[] stringArray) {
        final JPopupMenuOperator jPopupMenuOperator = this.callPopup();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                jPopupMenuOperator.showMenuItem(stringArray[i], "|");
                continue;
            }
            catch (NullPointerException nullPointerException) {
                throw new JemmyException("Popup path [" + stringArray[i] + "] not found.");
            }
        }
        jPopupMenuOperator.waitState(new ComponentChooser(){

            public boolean checkComponent(Component component) {
                try {
                    jPopupMenuOperator.pushKey(27);
                    return false;
                }
                catch (JemmyException jemmyException) {
                    return true;
                }
            }

            public String getDescription() {
                return "Popup menu closer";
            }
        });
    }

    TreePath findSubPath(String string, String string2) {
        return this.findSubPath(string, "", string2);
    }

    TreePath findSubPath(String string, String string2, String string3) {
        JTreeOperator jTreeOperator = this.tree();
        String[] stringArray = jTreeOperator.parseString(string2, string3);
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return jTreeOperator.findPath((JTreeOperator.TreePathChooser)new StringArraySubPathChooser(this.treePath, jTreeOperator.parseString(string, string3), nArray, this.getComparator()));
    }

    public void expand() {
        this.treeOperator.expandPath(this.treePath);
        this.waitExpanded();
    }

    public void collapse() {
        this.treeOperator.collapsePath(this.treePath);
        this.waitCollapsed();
    }

    public void waitExpanded() {
        this.treeOperator.waitExpanded(this.treePath);
    }

    public void waitCollapsed() {
        this.treeOperator.waitCollapsed(this.treePath);
    }

    public boolean isExpanded() {
        return this.treeOperator.isExpanded(this.treePath);
    }

    public boolean isCollapsed() {
        return this.treeOperator.isCollapsed(this.treePath);
    }

    public void verifyPopup(Action[] actionArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < actionArray.length; ++i) {
            String string = actionArray[i].getPopupPath();
            if (string == null) continue;
            arrayList.add(string);
        }
        this.verifyPopup(arrayList.toArray(new String[0]));
    }

    public boolean isChildPresent(String string) {
        String[] stringArray = this.getChildren();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.getComparator().equals(stringArray[i], string)) continue;
            return true;
        }
        return false;
    }

    public void waitChildNotPresent(final String string) {
        try {
            new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return Node.this.isChildPresent(string) ? null : Boolean.TRUE;
                }

                public String getDescription() {
                    return "Child \"" + string + "\" not present under parent \"" + Node.this.getPath() + "\"";
                }
            }).waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    public void waitNotPresent() {
        try {
            new Waiter(new Waitable(){

                public Object actionProduced(Object object) {
                    return Node.this.isPresent() ? null : Boolean.TRUE;
                }

                public String getDescription() {
                    return "Wait node " + Node.this.getPath() + " not present.";
                }
            }).waitAction(null);
        }
        catch (InterruptedException interruptedException) {
            throw new JemmyException("Interrupted.", (Throwable)interruptedException);
        }
    }

    class StringArraySubPathChooser
    implements JTreeOperator.TreePathChooser {
        String[] arr;
        int[] indices;
        Operator.StringComparator comparator;
        TreePath parentPath;
        int parentPathCount;

        StringArraySubPathChooser(TreePath treePath, String[] stringArray, int[] nArray, Operator.StringComparator stringComparator) {
            this.arr = stringArray;
            this.comparator = stringComparator;
            this.indices = nArray;
            this.parentPath = treePath;
            this.parentPathCount = treePath.getPathCount();
        }

        public boolean checkPath(TreePath treePath, int n) {
            return treePath.getPathCount() == this.arr.length + this.parentPathCount && this.hasAsParent(treePath, n);
        }

        public boolean hasAsParent(TreePath treePath, int n) {
            if (treePath.getPathCount() <= this.parentPathCount) {
                return treePath.isDescendant(this.parentPath);
            }
            if (this.arr.length + this.parentPathCount < treePath.getPathCount()) {
                return false;
            }
            if (this.indices.length >= treePath.getPathCount() - this.parentPathCount && this.indices[treePath.getPathCount() - this.parentPathCount - 1] != n) {
                return false;
            }
            Object[] objectArray = treePath.getPath();
            for (int i = this.parentPathCount; i < objectArray.length; ++i) {
                if (this.comparator.equals(objectArray[i].toString(), this.arr[i - this.parentPathCount])) continue;
                return false;
            }
            return true;
        }

        public String getDescription() {
            int n;
            String string = "";
            Object[] objectArray = this.parentPath.getPath();
            for (n = 0; n < objectArray.length; ++n) {
                string = string + objectArray[n].toString() + ", ";
            }
            for (n = 0; n < this.arr.length; ++n) {
                string = string + this.arr[n] + ", ";
            }
            if (string.length() > 0) {
                string = string.substring(0, string.length() - 2);
            }
            return "[ " + string + " ]";
        }
    }
}

