/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.builder.dbmodel.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBColumn;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBTable;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.Index;
import org.openide.util.NbBundle;

public class IndexImpl
implements Index,
Cloneable {
    private String name = null;
    private int type;
    private DBTable parent;
    private List columnNames = new ArrayList();
    private boolean unique = false;
    private String sortSequence;
    private int cardinality;

    private IndexImpl() {
    }

    public IndexImpl(String string, int n, boolean bl, String string2, int n2) {
        this();
        if (string == null) {
            ResourceBundle resourceBundle = NbBundle.getBundle(IndexImpl.class);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_INDEX_NAME") + "(ERROR_INDEX_NAME)");
        }
        this.name = string;
        this.type = n;
        this.unique = bl;
        this.sortSequence = string2;
        this.cardinality = n2;
    }

    public IndexImpl(String string, int n, boolean bl, String string2, int n2, List list, boolean bl2) {
        this(string, n, bl, string2, n2);
        this.setColumnNames(list, bl2);
    }

    public IndexImpl(Index index) {
        this();
        this.copyFrom(index);
    }

    public String getName() {
        return this.name;
    }

    public DBTable getParent() {
        return this.parent;
    }

    public int getType() {
        return this.type;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getSortSequence() {
        return this.sortSequence;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public List getColumnNames() {
        return Collections.unmodifiableList(this.columnNames);
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public int getSequence(DBColumn dBColumn) {
        if (dBColumn == null || dBColumn.getName() == null) {
            return -1;
        }
        return this.getSequence(dBColumn.getName().trim());
    }

    public String getColumnName(int n) {
        return (String)this.columnNames.get(n);
    }

    public boolean contains(String string) {
        return this.columnNames.contains(string);
    }

    public boolean contains(DBColumn dBColumn) {
        return dBColumn != null ? this.contains(dBColumn.getName()) : false;
    }

    public void setParent(DBTable dBTable) {
        this.parent = dBTable;
    }

    public void setColumnNames(List list, boolean bl) {
        if (bl) {
            this.columnNames.addAll(list);
        } else {
            Collections.sort(list);
            for (Column column : list) {
                this.columnNames.add(column.getName());
            }
        }
    }

    public int getSequence(String string) {
        return this.columnNames.indexOf(string);
    }

    public Object clone() {
        try {
            IndexImpl indexImpl = (IndexImpl)super.clone();
            indexImpl.columnNames = new ArrayList(this.columnNames);
            return indexImpl;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IndexImpl)) {
            return false;
        }
        IndexImpl indexImpl = (IndexImpl)object;
        boolean bl = this.name != null ? this.name.equals(indexImpl.name) : indexImpl.name == null;
        bl &= this.type == indexImpl.type && this.cardinality == indexImpl.cardinality && this.unique == indexImpl.unique;
        bl &= this.sortSequence != null ? this.sortSequence.equals(indexImpl.sortSequence) : indexImpl.sortSequence == null;
        return bl &= this.columnNames != null ? ((Object)this.columnNames).equals(indexImpl.columnNames) : indexImpl.columnNames == null;
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n += this.columnNames != null ? ((Object)this.columnNames).hashCode() : 0;
        n += this.type + this.cardinality + (this.unique ? 1 : 0);
        return n += this.sortSequence != null ? this.sortSequence.hashCode() : 0;
    }

    public void setColumnNames(String[] stringArray) {
        if (stringArray == null) {
            ResourceBundle resourceBundle = NbBundle.getBundle(IndexImpl.class);
            throw new IllegalArgumentException(resourceBundle.getString("ERROR_COL_NAMES") + "(ERROR_COL_NAMES)");
        }
        this.columnNames.clear();
        for (int i = 0; i < stringArray.length; ++i) {
            this.columnNames.add(stringArray[i]);
        }
    }

    private void copyFrom(Index index) {
        this.name = index.getName();
        this.parent = index.getParent();
        this.columnNames.clear();
        this.columnNames.addAll(index.getColumnNames());
        this.type = index.getType();
        this.unique = index.isUnique();
        this.sortSequence = index.getSortSequence();
        this.cardinality = index.getCardinality();
    }

    public static class Column
    implements Comparable {
        private String name;
        private int sequence;

        public Column(String string, int n) {
            ResourceBundle resourceBundle = NbBundle.getBundle(IndexImpl.class);
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_COL_NAME") + "(ERROR_COL_NAME)");
            }
            if (n <= 0) {
                throw new IllegalArgumentException(resourceBundle.getString("ERROR_COL_SEQ") + "(ERROR_COL_SEQ)");
            }
            this.name = string;
            this.sequence = n;
        }

        public Column(DBColumn dBColumn, int n) {
            this(dBColumn.getName(), n);
        }

        public String getName() {
            return this.name;
        }

        public int getSequence() {
            return this.sequence;
        }

        public int compareTo(Object object) {
            return this.sequence - ((Column)object).sequence;
        }
    }
}

