/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jdbcwizard.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.jdbcwizard.builder.DBMetaData;
import org.netbeans.modules.jdbcwizard.builder.Table;
import org.netbeans.modules.jdbcwizard.builder.TableColumn;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBConnectionDefinition;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DBTable;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.DatabaseModel;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.DBColumnImpl;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.DBTableImpl;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.DatabaseModelImpl;
import org.netbeans.modules.jdbcwizard.builder.dbmodel.impl.DatabaseObjectFactory;
import org.netbeans.modules.jdbcwizard.builder.util.XMLCharUtil;
import org.netbeans.modules.jdbcwizard.wizards.JDBCWizardContext;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class JDBCWizardSelectionPanel
extends JPanel
implements WizardDescriptor.Panel,
ActionListener,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    protected final Set listeners = new HashSet(1);
    private DatabaseConnection selectedConnection;
    DBConnectionDefinition def;
    DBModelNameCellRenderer srcRenderer;
    DBModelNameCellRenderer destRenderer;
    DefaultComboBoxModel providers;
    private static final String NEW_DATA_SOURCE = NbBundle.getMessage(JDBCWizardSelectionPanel.class, (String)"LBL_NDS");
    int visibleCt;
    String dbtype;
    private int selTableLen = 0;
    private ListTransferModel listModel;
    private final List dsList = new ArrayList();
    private final List destColl = new ArrayList();
    public static final String LBL_DEST_MSG = NbBundle.getMessage(JDBCWizardSelectionPanel.class, (String)"LBL_SEL_TAB");
    public static final String LBL_SOURCE_MSG = NbBundle.getMessage(JDBCWizardSelectionPanel.class, (String)"LBL_AVLB_TAB");
    public static final int MAXIMUM_VISIBLE = 10;
    public static final int MINIMUM_VISIBLE = 5;
    public static final String LBL_ADD = ">";
    public static final String LBL_ALL = NbBundle.getMessage(JDBCWizardSelectionPanel.class, (String)"LBL_ALL");
    public static final String LBL_ADD_ALL = LBL_ALL + " " + ">";
    public static final String LBL_REMOVE = "<";
    public static final String LBL_REMOVE_ALL = "< " + LBL_ALL;
    private DatabaseModel dbmodel;
    private JButton addButton;
    private JButton removeButton;
    private JButton addAllButton;
    private JButton removeAllButton;
    private JComboBox datasourceComboBox;
    private JLabel jLabel1;
    private JLabel availableTablesLabel;
    private JLabel selectedTablesLabel;
    private JList availableTablesList;
    private JList selectedTablesList;
    private JPanel dataSourcePanel;
    private JPanel availableTablesPanel;
    private JPanel selectedTablesPanel;
    private JPanel buttonsPanel;
    private JScrollPane availableTablesScrollPane;
    private JScrollPane selectedTablesScrollPane;

    public JDBCWizardSelectionPanel(String string) {
        if (string != null && string.trim().length() != 0) {
            this.setName(string);
        }
    }

    public void initialize() {
        this.initComponents();
        this.initDataSourceCombo();
        this.datasourceComboBox.addActionListener(new AddJDBCDataSourceActionListener());
    }

    public void initDataSourceCombo() {
        this.providers = new DefaultComboBoxModel();
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        if (databaseConnectionArray.length == 1) {
            this.providers.addElement("");
        }
        if (databaseConnectionArray.length > 0) {
            for (int i = 0; i < databaseConnectionArray.length; ++i) {
                this.providers.addElement(new ConnectionWrapper(databaseConnectionArray[i]));
            }
        } else {
            this.providers.addElement("<None>");
        }
        this.datasourceComboBox.setModel(this.providers);
        this.datasourceComboBox.setSelectedIndex(0);
    }

    private void initComponents() {
        this.dataSourcePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.datasourceComboBox = new JComboBox();
        this.availableTablesPanel = new JPanel();
        this.selectedTablesPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.availableTablesList = new JList();
        this.availableTablesScrollPane = new JScrollPane(this.availableTablesList);
        this.selectedTablesList = new JList();
        this.selectedTablesScrollPane = new JScrollPane(this.selectedTablesList);
        this.addButton = new JButton(LBL_ADD);
        this.removeButton = new JButton(LBL_REMOVE);
        this.addAllButton = new JButton(LBL_ADD_ALL);
        this.removeAllButton = new JButton(LBL_REMOVE_ALL);
        this.availableTablesLabel = new JLabel();
        this.selectedTablesLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.dataSourcePanel.add(this.jLabel1);
        this.dataSourcePanel.add(this.datasourceComboBox);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 26;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 39;
        gridBagConstraints.insets = new Insets(12, 12, 10, 12);
        this.add((Component)this.dataSourcePanel, gridBagConstraints);
        this.availableTablesPanel.setLayout(new BorderLayout());
        this.availableTablesPanel.add((Component)this.availableTablesLabel, "North");
        this.availableTablesPanel.add((Component)this.availableTablesScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.gridheight = 15;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(21, 24, 21, 24);
        this.add((Component)this.availableTablesPanel, gridBagConstraints);
        this.selectedTablesPanel.setLayout(new BorderLayout());
        this.selectedTablesPanel.add((Component)this.selectedTablesLabel, "North");
        this.selectedTablesPanel.add((Component)this.selectedTablesScrollPane, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 15;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 11;
        gridBagConstraints.gridheight = 15;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(23, 23, 23, 23);
        this.add((Component)this.selectedTablesPanel, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.buttonsPanel.add((Component)this.addAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 12;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 12;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(9, 9, 9, 9);
        this.buttonsPanel.add((Component)this.removeAllButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 11;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 17;
        gridBagConstraints.ipady = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(13, 13, 13, 13);
        this.add((Component)this.buttonsPanel, gridBagConstraints);
        this.addButton.setActionCommand(LBL_ADD);
        this.removeButton.setActionCommand(LBL_REMOVE);
        this.addAllButton.setActionCommand(LBL_ADD_ALL);
        this.removeAllButton.setActionCommand(LBL_REMOVE_ALL);
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.addAllButton.addActionListener(this);
        this.removeAllButton.addActionListener(this);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.addAllButton.setEnabled(false);
        this.removeAllButton.setEnabled(false);
        this.jLabel1.setText(NbBundle.getMessage(JDBCWizardSelectionPanel.class, (String)"LBL_DS"));
        this.availableTablesLabel.setText(NbBundle.getMessage(JDBCWizardSelectionPanel.class, (String)"LBL_AVLB_TAB"));
        this.availableTablesLabel.setDisplayedMnemonic(NbBundle.getMessage(this.getClass(), (String)"LBL_AVLB_TAB").charAt(0));
        this.selectedTablesLabel.setText(NbBundle.getMessage(JDBCWizardSelectionPanel.class, (String)"LBL_SEL_TAB"));
    }

    private void dbschemaComboBoxActionPerformed(ActionEvent actionEvent) {
        this.updateSourceSchema();
    }

    private void updateSourceSchema() {
        DatabaseConnection[] databaseConnectionArray;
        HashSet<DatabaseConnection> hashSet = new HashSet<DatabaseConnection>(Arrays.asList(ConnectionManager.getDefault().getConnections()));
        Object object = this.datasourceComboBox.getSelectedItem();
        if (object instanceof ConnectionWrapper) {
            databaseConnectionArray = (DatabaseConnection[])object;
            this.selectedConnection = databaseConnectionArray.getDatabaseConnection();
            ConnectionManager.getDefault().showConnectionDialog(this.selectedConnection);
            this.providers.removeElement("");
            this.persistModel();
        }
        if ((databaseConnectionArray = ConnectionManager.getDefault().getConnections()).length == hashSet.size()) {
            return;
        }
        this.providers.removeElement(new String(NEW_DATA_SOURCE));
        for (int i = 0; i < databaseConnectionArray.length; ++i) {
            if (hashSet.contains(databaseConnectionArray[i])) continue;
            this.providers.addElement(new ConnectionWrapper(databaseConnectionArray[i]));
            break;
        }
    }

    public void persistModel() {
        Connection connection = this.selectedConnection.getJDBCConnection();
        List list = null;
        if (connection != null) {
            try {
                this.def = DatabaseObjectFactory.createDBConnectionDefinition(this.selectedConnection.getDisplayName(), this.selectedConnection.getDriverClass(), this.selectedConnection.getDatabaseURL(), this.selectedConnection.getUser(), this.selectedConnection.getPassword(), "Descriptive info here", DBMetaData.getDBType(connection));
                this.dbtype = DBMetaData.getDBType(this.selectedConnection.getJDBCConnection());
                this.dbmodel = new DatabaseModelImpl(this.selectedConnection.getDisplayName(), this.def);
                String[][] stringArray = DBMetaData.getTablesAndViews("", this.selectedConnection.getSchema(), "", true, connection);
                list = "ORACLE".equalsIgnoreCase(this.dbtype) && DBMetaData.getDatabaseMajorVersion(connection) >= 10 ? DBMetaData.getOracleRecycleBinTables(connection) : Collections.EMPTY_LIST;
                String[] stringArray2 = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                if (stringArray != null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray2 = stringArray[i];
                        if (list.contains(stringArray2[0])) continue;
                        arrayList.add(stringArray2[0]);
                    }
                }
                this.initListModel(arrayList);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ErrorManager.getDefault().log(65536, exception.getMessage());
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
            }
        }
    }

    public void initListModel(List list) {
        String string2;
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        for (String string2 : list) {
            if (string2 == null) continue;
            defaultListModel.addElement(string2);
        }
        this.listModel = new ListTransferModel();
        this.listModel.setSourceList(Arrays.asList(defaultListModel.toArray()));
        string2 = this.listModel.getPrototypeCell();
        if (string2.length() < LBL_SOURCE_MSG.length()) {
            string2 = LBL_SOURCE_MSG;
        } else if (string2.length() < LBL_DEST_MSG.length()) {
            string2 = LBL_DEST_MSG;
        }
        this.srcRenderer = new DBModelNameCellRenderer(string2);
        this.destRenderer = new DBModelNameCellRenderer(string2);
        this.visibleCt = Math.min(Math.max(5, this.listModel.getMaximumListSize()), 10);
        this.addButton.setModel(this.listModel.getAddButtonModel());
        this.removeButton.setModel(this.listModel.getRemoveButtonModel());
        this.addAllButton.setModel(this.listModel.getAddAllButtonModel());
        this.removeAllButton.setModel(this.listModel.getRemoveAllButtonModel());
        this.availableTablesList = new JList<Object>(this.listModel.getSourceList().toArray());
        this.availableTablesList.setSelectionMode(2);
        this.availableTablesList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() instanceof JList) {
                    JList jList = (JList)mouseEvent.getSource();
                    int[] nArray = jList.getSelectedIndices();
                    Object[] objectArray = jList.getSelectedValues();
                    JDBCWizardSelectionPanel.this.listModel.add(objectArray, nArray);
                }
            }
        });
        this.availableTablesList.addListSelectionListener(this);
        this.availableTablesList.setPrototypeCellValue(this.srcRenderer);
        this.availableTablesList.setCellRenderer(this.srcRenderer);
        this.availableTablesList.setVisibleRowCount(this.visibleCt);
        this.selectedTablesList = new JList();
        this.selectedTablesList.setSelectionMode(2);
        this.selectedTablesList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getSource() instanceof JList) {
                    JList jList = (JList)mouseEvent.getSource();
                    int[] nArray = jList.getSelectedIndices();
                    Object[] objectArray = jList.getSelectedValues();
                    JDBCWizardSelectionPanel.this.listModel.remove(objectArray, nArray);
                }
            }
        });
        this.selectedTablesList.setPrototypeCellValue(this.destRenderer);
        this.selectedTablesList.setCellRenderer(this.destRenderer);
        this.selectedTablesList.setVisibleRowCount(this.visibleCt);
        this.selectedTablesList.addListSelectionListener(this);
        this.availableTablesScrollPane.setViewportView(this.availableTablesList);
        this.selectedTablesScrollPane.setViewportView(this.selectedTablesList);
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(JDBCWizardSelectionPanel.class);
    }

    public void readSettings(Object object) {
        WizardDescriptor wizardDescriptor = null;
        if (object instanceof JDBCWizardContext) {
            JDBCWizardContext jDBCWizardContext = (JDBCWizardContext)object;
            wizardDescriptor = (WizardDescriptor)jDBCWizardContext.getProperty("wizDesc");
        } else if (object instanceof WizardDescriptor) {
            wizardDescriptor = (WizardDescriptor)object;
        }
    }

    public void storeSettings(Object object) {
        Object object2;
        WizardDescriptor wizardDescriptor = null;
        if (object instanceof JDBCWizardContext) {
            object2 = (JDBCWizardContext)object;
            wizardDescriptor = (WizardDescriptor)((JDBCWizardContext)object2).getProperty("wizDesc");
        } else if (object instanceof WizardDescriptor) {
            wizardDescriptor = (WizardDescriptor)object;
        }
        object2 = wizardDescriptor.getValue();
        if (NotifyDescriptor.CANCEL_OPTION == object2 || NotifyDescriptor.CLOSED_OPTION == object2) {
            return;
        }
        if (object2.toString().equals("PREVIOUS_OPTION")) {
            if (this.availableTablesList != null && this.listModel != null) {
                this.listModel.getSourceList().clear();
                this.availableTablesScrollPane.setViewportView(this.availableTablesList);
            }
            if (this.selectedTablesList != null && this.listModel != null) {
                this.listModel.getSourceList().clear();
                this.selectedTablesScrollPane.setViewportView(this.selectedTablesList);
            }
            return;
        }
        if (this.listModel != null) {
            List list = this.listModel.getDestinationList();
            ArrayList<DBTable> arrayList = new ArrayList<DBTable>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DBTable dBTable = this.populateDBTable((String)iterator.next());
                dBTable.setSelected(true);
                arrayList.add(dBTable);
            }
            if (wizardDescriptor != null) {
                wizardDescriptor.putProperty("selected_tables", (Object)arrayList.toArray());
                wizardDescriptor.putProperty("db_type", (Object)this.dbtype);
                wizardDescriptor.putProperty("connection_info", (Object)this.def);
            }
        }
    }

    public DBTable populateDBTable(String string) {
        block6: {
            Connection connection = this.selectedConnection.getJDBCConnection();
            try {
                String[][] stringArray = DBMetaData.getTablesAndViews("", "", "", true, connection);
                DBTableImpl dBTableImpl = null;
                String[] stringArray2 = null;
                if (stringArray == null) break block6;
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2 = stringArray[i];
                    if (string.equals(stringArray2[0])) {
                        dBTableImpl = new DBTableImpl(stringArray2[0], stringArray2[2], stringArray2[1]);
                        Table table = null;
                        String string2 = connection.getMetaData().getDriverName();
                        table = string2.startsWith("JDBC-ODBC") ? DBMetaData.getTableMetaDataForODBCDriver(stringArray2[1], stringArray2[2], stringArray2[0], stringArray2[3], connection) : DBMetaData.getTableMetaData(stringArray2[1], stringArray2[2], stringArray2[0], stringArray2[3], connection);
                        TableColumn[] tableColumnArray = table.getColumns();
                        TableColumn tableColumn = null;
                        DBColumnImpl dBColumnImpl = null;
                        for (int j = 0; j < tableColumnArray.length; ++j) {
                            tableColumn = tableColumnArray[j];
                            dBColumnImpl = new DBColumnImpl(tableColumn.getName(), tableColumn.getSqlTypeCode(), tableColumn.getNumericScale(), tableColumn.getNumericPrecision(), tableColumn.getIsPrimaryKey(), tableColumn.getIsForeignKey(), false, tableColumn.getIsNullable());
                            String string3 = XMLCharUtil.makeValidNCName(tableColumn.getName());
                            dBColumnImpl.setJavaName(string3);
                            dBTableImpl.addColumn(dBColumnImpl);
                        }
                        return dBTableImpl;
                    }
                    if (dBTableImpl == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                ErrorManager.getDefault().log(65536, exception.getMessage());
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    public boolean isValid() {
        boolean bl = false;
        if (this.selTableLen > 0) {
            bl = true;
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (LBL_ADD.equals(string)) {
            int[] nArray = this.availableTablesList.getSelectedIndices();
            if (nArray.length <= 1) {
                Object[] objectArray = this.availableTablesList.getSelectedValues();
                this.listModel.add(objectArray, nArray);
            } else {
                Object[] objectArray = new Object[]{"OK"};
                JOptionPane.showOptionDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(JDBCWizardSelectionPanel.class, (String)"WARNING_IN_SELECTING_TABLES"), "Warning", -1, 2, null, objectArray, objectArray[0]);
            }
        } else if (LBL_ADD_ALL.equals(string)) {
            this.listModel.addAll();
        } else if (LBL_REMOVE.equals(string)) {
            int[] nArray = this.selectedTablesList.getSelectedIndices();
            Object[] objectArray = this.selectedTablesList.getSelectedValues();
            this.listModel.remove(objectArray, nArray);
        } else if (LBL_REMOVE_ALL.equals(string)) {
            this.listModel.removeAll();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (this.availableTablesList.equals(object)) {
            if (!this.selectedTablesList.isSelectionEmpty()) {
                this.selectedTablesList.clearSelection();
            }
        } else if (this.selectedTablesList.equals(object) && !this.availableTablesList.isSelectionEmpty()) {
            this.availableTablesList.clearSelection();
        }
    }

    class DBModelNameCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public DBModelNameCellRenderer(String string) {
            this.setText(string.toString());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setOpaque(true);
            if (object instanceof DBTable) {
                DBTable dBTable = (DBTable)object;
                if (dBTable.getName() != null) {
                    this.setText(dBTable.getName());
                } else {
                    this.setText(dBTable.getName());
                }
            } else if (object instanceof String) {
                this.setText(object.toString());
            }
            return this;
        }
    }

    class ListTransferModel {
        private ButtonModel addAllButtonModel;
        private ButtonModel addButtonModel;
        private HashSet changeListeners;
        private DefaultListModel dest;
        private String listPrototype = "";
        private ButtonModel removeAllButtonModel;
        private ButtonModel removeButtonModel;
        private DefaultListModel source = new DefaultListModel();

        public ListTransferModel() {
            this.dest = new DefaultListModel();
            this.addButtonModel = new DefaultButtonModel();
            this.addAllButtonModel = new DefaultButtonModel();
            this.removeButtonModel = new DefaultButtonModel();
            this.removeAllButtonModel = new DefaultButtonModel();
            this.changeListeners = new HashSet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Object[] objectArray, int[] nArray) {
            DefaultListModel defaultListModel = this.dest;
            synchronized (defaultListModel) {
                DefaultListModel defaultListModel2 = this.source;
                synchronized (defaultListModel2) {
                    for (int i = 0; i < nArray.length; ++i) {
                        Object object = objectArray[i];
                        this.dest.addElement(object);
                        this.source.removeElement(object);
                        this.fireTransferEvent(this.dest, object, 0);
                    }
                    this.updateButtonState();
                }
            }
            JDBCWizardSelectionPanel.this.selTableLen = this.dest.getSize();
            this.updateButtonState();
            this.updateUI();
            JDBCWizardSelectionPanel.this.fireChangeEvent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addAll() {
            DefaultListModel defaultListModel = this.dest;
            synchronized (defaultListModel) {
                DefaultListModel defaultListModel2 = this.source;
                synchronized (defaultListModel2) {
                    int n = this.source.getSize();
                    for (int i = 0; i < n; ++i) {
                        Object e = this.source.elementAt(i);
                        this.dest.addElement(e);
                        this.fireTransferEvent(this.dest, e, 0);
                    }
                    this.source.removeAllElements();
                }
            }
            JDBCWizardSelectionPanel.this.selTableLen = this.dest.getSize();
            this.updateButtonState();
            JDBCWizardSelectionPanel.this.fireChangeEvent();
            this.updateUI();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener changeListener) {
            if (changeListener != null) {
                HashSet hashSet = this.changeListeners;
                synchronized (hashSet) {
                    this.changeListeners.add(changeListener);
                }
            }
        }

        public ButtonModel getAddAllButtonModel() {
            return this.addAllButtonModel;
        }

        public ButtonModel getAddButtonModel() {
            return this.addButtonModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getDestinationList() {
            ArrayList arrayList = new ArrayList();
            DefaultListModel defaultListModel = this.dest;
            synchronized (defaultListModel) {
                this.dest.trimToSize();
                for (int i = 0; i < this.dest.size(); ++i) {
                    arrayList.add(this.dest.get(i));
                }
            }
            return arrayList;
        }

        public ListModel getDestinationModel() {
            return this.dest;
        }

        public int getMaximumListSize() {
            return this.source.size() + this.dest.size();
        }

        public String getPrototypeCell() {
            return this.listPrototype;
        }

        public ButtonModel getRemoveAllButtonModel() {
            return this.removeAllButtonModel;
        }

        public ButtonModel getRemoveButtonModel() {
            return this.removeButtonModel;
        }

        public int getSourceIndexFor(String string, int n) {
            int n2 = 0;
            if (n < 0 || n > this.source.size()) {
                n2 = 0;
            }
            if (string != null && string.trim().length() != 0) {
                return this.source.indexOf(string, n2);
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List getSourceList() {
            ArrayList arrayList = new ArrayList();
            DefaultListModel defaultListModel = this.source;
            synchronized (defaultListModel) {
                this.source.trimToSize();
                for (int i = 0; i < this.source.size(); ++i) {
                    arrayList.add(this.source.get(i));
                }
            }
            return arrayList;
        }

        public ListModel getSourceModel() {
            return this.source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Object[] objectArray, int[] nArray) {
            DefaultListModel defaultListModel = this.dest;
            synchronized (defaultListModel) {
                DefaultListModel defaultListModel2 = this.source;
                synchronized (defaultListModel2) {
                    for (int i = 0; i < nArray.length; ++i) {
                        Object object = objectArray[i];
                        this.source.addElement(object);
                        this.dest.removeElement(object);
                        this.fireTransferEvent(this.dest, object, 1);
                    }
                }
            }
            JDBCWizardSelectionPanel.this.selTableLen = this.dest.getSize();
            this.updateButtonState();
            JDBCWizardSelectionPanel.this.fireChangeEvent();
            this.updateUI();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAll() {
            DefaultListModel defaultListModel = this.dest;
            synchronized (defaultListModel) {
                DefaultListModel defaultListModel2 = this.source;
                synchronized (defaultListModel2) {
                    int n = this.dest.getSize();
                    for (int i = 0; i < n; ++i) {
                        Object e = this.dest.elementAt(i);
                        this.source.addElement(e);
                    }
                    this.dest.removeAllElements();
                }
            }
            JDBCWizardSelectionPanel.this.selTableLen = this.dest.getSize();
            this.updateButtonState();
            JDBCWizardSelectionPanel.this.fireChangeEvent();
            this.updateUI();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener changeListener) {
            if (changeListener != null) {
                HashSet hashSet = this.changeListeners;
                synchronized (hashSet) {
                    this.changeListeners.remove(changeListener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDestinationList(Collection collection) {
            if (collection == null) {
                throw new IllegalArgumentException("Must supply non-null Collection for newList");
            }
            if (this.dest == null) {
                this.dest = new DefaultListModel();
            }
            DefaultListModel defaultListModel = this.dest;
            synchronized (defaultListModel) {
                this.dest.clear();
                for (Object e : collection) {
                    this.dest.addElement(e);
                    if (e.toString().trim().length() <= this.listPrototype.length()) continue;
                    this.listPrototype = e.toString().trim();
                }
            }
            this.updateButtonState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setSourceList(Collection collection) {
            if (collection == null) {
                throw new IllegalArgumentException("Must supply non-null Collection for newList");
            }
            if (this.source == null) {
                this.source = new DefaultListModel();
            }
            DefaultListModel defaultListModel = this.source;
            synchronized (defaultListModel) {
                this.source.clear();
                for (Object e : collection) {
                    this.source.addElement(e);
                    if (e.toString().trim().length() <= this.listPrototype.length()) continue;
                    this.listPrototype = e.toString().trim();
                }
            }
            this.updateButtonState();
        }

        public void updateButtonState() {
            boolean bl;
            boolean bl2 = !this.source.isEmpty();
            boolean bl3 = bl = !this.dest.isEmpty();
            if (bl) {
                this.addButtonModel.setEnabled(false);
                this.addAllButtonModel.setEnabled(false);
                this.removeButtonModel.setEnabled(bl);
                this.removeAllButtonModel.setEnabled(bl);
            } else {
                this.addButtonModel.setEnabled(bl2);
                this.addAllButtonModel.setEnabled(bl);
                this.removeButtonModel.setEnabled(bl);
                this.removeAllButtonModel.setEnabled(bl);
            }
        }

        public void updateUI() {
            JDBCWizardSelectionPanel.this.availableTablesList = new JList<Object>(JDBCWizardSelectionPanel.this.listModel.getSourceList().toArray());
            JDBCWizardSelectionPanel.this.selectedTablesList = new JList<Object>(JDBCWizardSelectionPanel.this.listModel.getDestinationList().toArray());
            JDBCWizardSelectionPanel.this.availableTablesList.setPrototypeCellValue(JDBCWizardSelectionPanel.this.srcRenderer);
            JDBCWizardSelectionPanel.this.availableTablesList.setCellRenderer(JDBCWizardSelectionPanel.this.srcRenderer);
            JDBCWizardSelectionPanel.this.availableTablesList.setVisibleRowCount(JDBCWizardSelectionPanel.this.visibleCt);
            JDBCWizardSelectionPanel.this.selectedTablesList.setPrototypeCellValue(JDBCWizardSelectionPanel.this.destRenderer);
            JDBCWizardSelectionPanel.this.selectedTablesList.setCellRenderer(JDBCWizardSelectionPanel.this.destRenderer);
            JDBCWizardSelectionPanel.this.selectedTablesList.setVisibleRowCount(JDBCWizardSelectionPanel.this.visibleCt);
            JDBCWizardSelectionPanel.this.availableTablesScrollPane.setViewportView(JDBCWizardSelectionPanel.this.availableTablesList);
            JDBCWizardSelectionPanel.this.selectedTablesScrollPane.setViewportView(JDBCWizardSelectionPanel.this.selectedTablesList);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireTransferEvent(Object object, Object object2, int n) {
            if (object != null && object2 != null) {
                TransferEvent transferEvent = new TransferEvent(object, object2, n);
                HashSet hashSet = this.changeListeners;
                synchronized (hashSet) {
                    for (ChangeListener changeListener : this.changeListeners) {
                        changeListener.stateChanged(transferEvent);
                    }
                }
            }
        }
    }

    public static class TransferEvent
    extends ChangeEvent {
        private static final long serialVersionUID = 1L;
        public static final int ADDED = 0;
        public static final int REMOVED = 1;
        private Object item;
        private int type;

        public TransferEvent(Object object, Object object2, int n) {
            super(object);
            this.item = object2;
            this.type = n;
        }

        public Object getItem() {
            return this.item;
        }

        public int getType() {
            return this.type;
        }
    }

    private class AddJDBCDataSourceActionListener
    implements ActionListener {
        private AddJDBCDataSourceActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JDBCWizardSelectionPanel.this.dbschemaComboBoxActionPerformed(actionEvent);
        }
    }

    private static class ConnectionWrapper {
        private DatabaseConnection conn;

        ConnectionWrapper(DatabaseConnection databaseConnection) {
            this.conn = databaseConnection;
        }

        public DatabaseConnection getDatabaseConnection() {
            return this.conn;
        }

        public String toString() {
            return this.conn.getDisplayName();
        }
    }
}

