/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.editor.completion;

import java.util.ArrayList;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.groovy.gsp.lexer.api.GspTokenId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GspModel {
    private final Document doc;
    private final ArrayList<CodeBlockData> codeBlocks = new ArrayList();
    private String groovyCode;
    private boolean documentDirty = true;
    private int prevAstOffset;
    private int prevLexOffset;

    public static GspModel get(Document document) {
        GspModel gspModel = (GspModel)document.getProperty(GspModel.class);
        if (gspModel == null) {
            gspModel = new GspModel(document);
            document.putProperty(GspModel.class, gspModel);
        }
        return gspModel;
    }

    GspModel(Document document) {
        this.doc = document;
        if (document != null) {
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
            tokenHierarchy.addTokenHierarchyListener(new TokenHierarchyListener(){

                public void tokenHierarchyChanged(TokenHierarchyEvent tokenHierarchyEvent) {
                    GspModel.this.documentDirty = true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGroovyCode() {
        if (this.documentDirty) {
            this.documentDirty = false;
            this.codeBlocks.clear();
            StringBuilder stringBuilder = new StringBuilder();
            BaseDocument baseDocument = (BaseDocument)this.doc;
            try {
                baseDocument.readLock();
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
                TokenSequence tokenSequence = tokenHierarchy.tokenSequence(GspTokenId.language());
                this.groovy(stringBuilder, (TokenHierarchy<Document>)tokenHierarchy, (TokenSequence<GspTokenId>)tokenSequence);
            }
            finally {
                baseDocument.readUnlock();
            }
            this.groovyCode = stringBuilder.toString();
        }
        return this.groovyCode;
    }

    void groovy(StringBuilder stringBuilder, TokenHierarchy<Document> tokenHierarchy, TokenSequence<GspTokenId> tokenSequence) {
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.append("def _buf ='';");
        this.codeBlocks.add(new CodeBlockData(0, 0, 0, stringBuilder2.length()));
        boolean bl = false;
        while (tokenSequence.moveNext()) {
            CharSequence charSequence;
            int n;
            int n2;
            int n3;
            Token token = tokenSequence.token();
            if (token.id() == GspTokenId.HTML) {
                int n4;
                int n5;
                n3 = token.offset(tokenHierarchy);
                n2 = n3 + token.length();
                n = stringBuilder2.length();
                charSequence = token.text();
                String string = charSequence == null ? "" : ((Object)charSequence).toString();
                boolean bl2 = false;
                for (n5 = 0; n5 < string.length(); ++n5) {
                    n4 = string.charAt(n5);
                    if (n4 == 10) {
                        ++n5;
                        bl2 = true;
                        break;
                    }
                    if (!Character.isWhitespace((char)n4)) break;
                }
                if (bl2) {
                    stringBuilder2.append(string.substring(0, n5));
                    string = string.substring(n5);
                }
                stringBuilder2.append("_buf += \"\"\"");
                if (bl && string.startsWith("\n")) {
                    string = string.substring(1);
                    --n2;
                }
                string = string.replace("\"", "\\\"");
                stringBuilder2.append(string);
                stringBuilder2.append("\"\"\";");
                n4 = stringBuilder2.length();
                CodeBlockData codeBlockData = new CodeBlockData(n3, n2, n, n4);
                this.codeBlocks.add(codeBlockData);
                bl = false;
                continue;
            }
            if (token.id() == GspTokenId.GROOVY) {
                n3 = token.offset(tokenHierarchy);
                n2 = n3 + token.length();
                n = stringBuilder2.length();
                charSequence = ((Object)token.text()).toString();
                String string = ((String)charSequence).trim();
                if (string.startsWith("--") && string.endsWith("--")) {
                    int n6 = ((String)charSequence).indexOf("--");
                    int n7 = ((String)charSequence).lastIndexOf("--");
                    stringBuilder2.append("/*");
                    stringBuilder2.append(((String)charSequence).substring(n6 + 2, n7));
                    stringBuilder2.append("*/");
                } else {
                    stringBuilder2.append((String)charSequence);
                    stringBuilder2.append(';');
                }
                bl = false;
                int n8 = stringBuilder2.length();
                CodeBlockData codeBlockData = new CodeBlockData(n3, n2, n, n8);
                this.codeBlocks.add(codeBlockData);
                bl = false;
                continue;
            }
            if (token.id() != GspTokenId.GROOVY_EXPR) continue;
            stringBuilder2.append("_buf += (");
            n3 = token.offset(tokenHierarchy);
            n2 = n3 + token.length();
            n = stringBuilder2.length();
            charSequence = ((Object)token.text()).toString();
            bl = false;
            stringBuilder2.append((String)charSequence);
            stringBuilder2.append(';');
            int n9 = stringBuilder2.length();
            CodeBlockData codeBlockData = new CodeBlockData(n3, n2, n, n9);
            this.codeBlocks.add(codeBlockData);
            stringBuilder2.append(")");
        }
    }

    public int sourceToGeneratedPos(int n) {
        if (this.prevLexOffset == n) {
            return this.prevAstOffset;
        }
        this.prevLexOffset = n;
        CodeBlockData codeBlockData = this.getCodeBlockAtSourceOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = n - codeBlockData.sourceStart;
        int n3 = codeBlockData.generatedStart + n2;
        this.prevAstOffset = n3 <= codeBlockData.generatedEnd ? n3 : codeBlockData.generatedEnd;
        return this.prevAstOffset;
    }

    public int generatedToSourcePos(int n) {
        if (this.prevAstOffset == n) {
            return this.prevLexOffset;
        }
        this.prevAstOffset = n;
        CodeBlockData codeBlockData = this.getCodeBlockAtGeneratedOffset(n);
        if (codeBlockData == null) {
            return -1;
        }
        int n2 = n - codeBlockData.generatedStart;
        int n3 = codeBlockData.sourceStart + n2;
        this.prevLexOffset = n3 <= codeBlockData.sourceEnd ? n3 : codeBlockData.sourceEnd;
        return this.prevLexOffset;
    }

    private CodeBlockData getCodeBlockAtSourceOffset(int n) {
        for (CodeBlockData codeBlockData : this.codeBlocks) {
            if (codeBlockData.sourceStart > n || codeBlockData.sourceEnd < n) continue;
            return codeBlockData;
        }
        return null;
    }

    private CodeBlockData getCodeBlockAtGeneratedOffset(int n) {
        for (CodeBlockData codeBlockData : this.codeBlocks) {
            if (codeBlockData.generatedStart > n || codeBlockData.generatedEnd < n) continue;
            return codeBlockData;
        }
        return null;
    }

    private class CodeBlockData {
        private int sourceStart;
        private int sourceEnd;
        private int generatedStart;
        private int generatedEnd;

        public CodeBlockData(int n, int n2, int n3, int n4) {
            this.sourceStart = n;
            this.generatedStart = n3;
            this.sourceEnd = n2;
            this.generatedEnd = n4;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CodeBlockData[");
            stringBuilder.append("\n  GSP(" + this.sourceStart + "," + this.sourceEnd + ")");
            stringBuilder.append(",\n  GROOVY(" + this.generatedStart + "," + this.generatedEnd + ")");
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

