/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsstack.jaxws.glassfish.v3;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishV3JaxWsStack
implements WSStackImplementation<JaxWs> {
    private static final String[] METRO_LIBRARIES = new String[]{"webservices", "javax.activation", "jaxb", "jsr109-impl"};
    private static final String GFV3_MODULES_DIR_NAME = "modules";
    private String gfRootStr;
    private JaxWs jaxWs;

    public GlassFishV3JaxWsStack(String string) {
        this.gfRootStr = string;
        this.jaxWs = new JaxWs(this.getUriDescriptor());
    }

    public JaxWs get() {
        return this.jaxWs;
    }

    public WSStackVersion getVersion() {
        if (this.isMetroInstalled()) {
            return WSStackVersion.valueOf((int)2, (int)1, (int)4, (int)1);
        }
        return WSStackVersion.valueOf((int)2, (int)1, (int)3, (int)0);
    }

    public WSTool getWSTool(WSStack.Tool tool) {
        if (tool == JaxWs.Tool.WSIMPORT) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSIMPORT));
        }
        if (tool == JaxWs.Tool.WSGEN) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSGEN));
        }
        return null;
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        if (feature == JaxWs.Feature.WSIT) {
            return true;
        }
        if (feature == JaxWs.Feature.JSR109 && this.isMetroInstalled()) {
            return true;
        }
        return feature == JaxWs.Feature.TESTER_PAGE;
    }

    private JaxWs.UriDescriptor getUriDescriptor() {
        return new JaxWs.UriDescriptor(){

            public String getServiceUri(String string, String string2, String string3, boolean bl) {
                if (bl) {
                    return string2 + "/" + string3;
                }
                return string + "/" + string2;
            }

            public String getDescriptorUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?wsdl";
            }

            public String getTesterPageUri(String string, String string2, String string3, boolean bl) {
                return this.getServiceUri(string, string2, string3, bl) + "?Tester";
            }
        };
    }

    private boolean isMetroInstalled() {
        File file = this.getJarName(this.gfRootStr, METRO_LIBRARIES[0]);
        return file != null && file.exists();
    }

    private File getJarName(String string, String string2) {
        File[] fileArray;
        File file = new File(string + File.separatorChar + GFV3_MODULES_DIR_NAME);
        int n = string2.lastIndexOf("/");
        if (n != -1) {
            fileArray = string2.substring(0, n);
            string2 = string2.substring(n + 1);
            file = new File(file, (String)fileArray);
        }
        if ((fileArray = file.listFiles(new VersionFilter(string2))) != null && fileArray.length > 0) {
            return fileArray[0];
        }
        return null;
    }

    private static class VersionFilter
    implements FileFilter {
        private String nameprefix;

        public VersionFilter(String string) {
            this.nameprefix = string;
        }

        public boolean accept(File file) {
            return file.getName().startsWith(this.nameprefix);
        }
    }

    private class JaxWsTool
    implements WSToolImplementation {
        JaxWs.Tool tool;

        JaxWsTool(JaxWs.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            ArrayList<URL> arrayList = new ArrayList<URL>();
            if (GlassFishV3JaxWsStack.this.isMetroInstalled()) {
                for (String string : METRO_LIBRARIES) {
                    File file = GlassFishV3JaxWsStack.this.getJarName(GlassFishV3JaxWsStack.this.gfRootStr, string);
                    if (file == null || !file.exists()) continue;
                    try {
                        arrayList.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            return arrayList.toArray(new URL[arrayList.size()]);
        }
    }
}

