/*
 * Decompiled with CFR 0.152.
 */
package org.rubyforge.debugcommons.reader;

import java.io.IOException;
import org.rubyforge.debugcommons.model.BreakpointSuspensionPoint;
import org.rubyforge.debugcommons.model.ExceptionSuspensionPoint;
import org.rubyforge.debugcommons.model.StepSuspensionPoint;
import org.rubyforge.debugcommons.model.SuspensionPoint;
import org.rubyforge.debugcommons.reader.XmlStreamReader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class SuspensionReader
extends XmlStreamReader {
    private SuspensionPoint suspensionPoint;

    public SuspensionReader(XmlPullParser xpp) {
        super(xpp);
    }

    private void parse() throws XmlPullParserException, IOException {
        String name = this.xpp.getName();
        assert (name.equals("breakpoint") || name.equals("suspended") || name.equals("exception"));
        if (name.equals("breakpoint")) {
            this.suspensionPoint = new BreakpointSuspensionPoint();
        } else if (name.equals("exception")) {
            ExceptionSuspensionPoint exceptionPoint = new ExceptionSuspensionPoint();
            exceptionPoint.setExceptionMessage(this.getAttributeValue("message"));
            exceptionPoint.setExceptionType(this.getAttributeValue("type"));
            this.suspensionPoint = exceptionPoint;
        } else if (name.equals("suspended")) {
            StepSuspensionPoint stepPoint = new StepSuspensionPoint();
            String frameNoAttribute = this.getAttributeValue("frames");
            try {
                stepPoint.setFramesNumber(Integer.parseInt(frameNoAttribute));
                this.suspensionPoint = stepPoint;
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException("Could not parse: " + frameNoAttribute + ", " + this.xpp.getText());
            }
        } else {
            throw new IllegalStateException("Unexpected element: " + name);
        }
        this.suspensionPoint.setLine(this.getAttributeIntValue("line"));
        this.suspensionPoint.setFile(this.getAttributeValue("file"));
        this.suspensionPoint.setThreadId(this.getAttributeIntValue("threadId"));
        this.ensureEndTag(name);
    }

    public static SuspensionPoint readSuspension(XmlPullParser xpp) throws IOException, XmlPullParserException {
        SuspensionReader reader = new SuspensionReader(xpp);
        reader.parse();
        return reader.suspensionPoint;
    }
}

