/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.file;

import java.io.File;
import java.io.FileFilter;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.jumpto.file.FileDescription;
import org.netbeans.modules.jumpto.file.FileSearchPanel;
import org.netbeans.modules.jumpto.file.RegexpFileFilter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchWorker
implements Runnable {
    private volatile boolean isCanceled;
    private FileSearchPanel panel;
    private String prefix;
    private FileFilter fileFilter;
    private long filesScanned;

    public SearchWorker(FileSearchPanel fileSearchPanel, String string) {
        this.panel = fileSearchPanel;
        this.prefix = string;
        this.fileFilter = new RegexpFileFilter(string, false);
    }

    public synchronized void cancel() {
        this.isCanceled = true;
    }

    @Override
    public void run() {
        Project project = this.panel.getPreferedProject();
        long l = System.currentTimeMillis();
        List<FileDescription> list = null;
        if (project != null) {
            list = this.doSearch(project, false);
            if (!this.isCanceled) {
                this.panel.getSearch().setPrefix(this.prefix);
                this.panel.getSearch().newSearchResults(list);
                this.panel.setModel(false, true);
            }
        }
        List<FileDescription> list2 = this.doSearch(project, true);
        if (!this.isCanceled) {
            if (list != null && !list.isEmpty()) {
                list.addAll(list2);
            } else {
                list = list2;
            }
            this.panel.getSearch().setPrefix(this.prefix);
            this.panel.getSearch().newSearchResults(list);
            this.panel.setModel(true, false);
        }
        this.panel.getSearch().workerFinished();
    }

    private List<FileDescription> doSearch(Project project, boolean bl) {
        Project[] projectArray;
        this.filesScanned = 0L;
        if (project == null || bl) {
            projectArray = this.panel.getProjects();
        } else {
            Project[] projectArray2 = new Project[1];
            projectArray = projectArray2;
            projectArray2[0] = project;
        }
        Project[] projectArray3 = projectArray;
        LinkedList<FileDescription> linkedList = new LinkedList<FileDescription>();
        for (Project project2 : projectArray3) {
            if (this.isCanceled) {
                return null;
            }
            if (project != null && bl && (project2 == project || project2.equals(project))) continue;
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project2).getSourceGroups("generic");
            if (this.isCanceled) {
                return null;
            }
            for (SourceGroup sourceGroup : sourceGroupArray) {
                FileObject fileObject = sourceGroup.getRootFolder();
                if (this.isCanceled) {
                    return null;
                }
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file == null || !file.isDirectory()) continue;
                this.findFiles(project2, sourceGroup, file, linkedList, !bl, 0);
            }
        }
        return linkedList;
    }

    private void findFiles(Project project, SourceGroup sourceGroup, File file, List<FileDescription> list, boolean bl, int n) {
        File[] fileArray;
        if (this.isCanceled) {
            return;
        }
        for (File file2 : fileArray = file.listFiles()) {
            FileObject fileObject;
            if (this.isCanceled) {
                return;
            }
            if (n <= 1 && (fileObject = FileUtil.toFileObject((File)file2)) != null && !sourceGroup.contains(fileObject)) continue;
            if (file2.isDirectory()) {
                this.findFiles(project, sourceGroup, file2, list, bl, n + 1);
                continue;
            }
            if (!this.fileFilter.accept(file2)) continue;
            list.add(new FileDescription(file2, project, sourceGroup, bl));
        }
        this.filesScanned += (long)fileArray.length;
    }
}

