/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.BooleanValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.expr.Expression;
import org.netbeans.modules.debugger.jpda.expr.ParseException;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.util.ConditionedExecutor;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

abstract class BreakpointImpl
implements ConditionedExecutor,
PropertyChangeListener {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");
    private JPDADebuggerImpl debugger;
    private JPDABreakpoint breakpoint;
    private BreakpointsReader reader;
    private Expression compiledCondition;
    private List<EventRequest> requests = new ArrayList<EventRequest>();
    private int hitCountFilter = 0;
    private Variable processedReturnVariable;
    private Throwable conditionException;

    protected BreakpointImpl(JPDABreakpoint jPDABreakpoint, BreakpointsReader breakpointsReader, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        this.debugger = jPDADebuggerImpl;
        this.reader = breakpointsReader;
        this.breakpoint = jPDABreakpoint;
    }

    final void set() {
        this.breakpoint.addPropertyChangeListener((PropertyChangeListener)this);
        this.update();
    }

    void fixed() {
        if (this.reader != null) {
            this.reader.storeCachedClassName(this.breakpoint, null);
        }
        this.update();
    }

    final void update() {
        if (this.getVirtualMachine() == null || this.getDebugger().getState() == 4) {
            return;
        }
        this.removeAllEventRequests();
        if (this.breakpoint.isEnabled() && this.isEnabled()) {
            this.setRequests();
        }
    }

    protected boolean isEnabled() {
        return true;
    }

    protected final void setValidity(Breakpoint.VALIDITY vALIDITY, String string) {
        if (this.breakpoint instanceof ChangeListener) {
            ((ChangeListener)this.breakpoint).stateChanged(new ValidityChangeEvent(vALIDITY, string));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("disposed".equals(string)) {
            this.remove();
        } else if (!"validity".equals(string) && !"groupName".equals(string)) {
            if (this.reader != null) {
                this.reader.storeCachedClassName(this.breakpoint, null);
            }
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    BreakpointImpl.this.update();
                }
            });
        }
    }

    protected abstract void setRequests();

    protected void remove() {
        if (SwingUtilities.isEventDispatchThread()) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    BreakpointImpl.this.removeAllEventRequests();
                }
            });
        } else {
            this.removeAllEventRequests();
        }
        this.breakpoint.removePropertyChangeListener((PropertyChangeListener)this);
        this.setValidity(Breakpoint.VALIDITY.UNKNOWN, null);
    }

    protected JPDABreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    protected VirtualMachine getVirtualMachine() {
        return this.getDebugger().getVirtualMachine();
    }

    protected EventRequestManager getEventRequestManager() {
        VirtualMachine virtualMachine = this.getVirtualMachine();
        if (virtualMachine == null) {
            throw new VMDisconnectedException();
        }
        return virtualMachine.eventRequestManager();
    }

    protected void addEventRequest(EventRequest eventRequest) {
        this.addEventRequest(eventRequest, false);
    }

    protected synchronized void addEventRequest(EventRequest eventRequest, boolean bl) {
        block8: {
            block7: {
                logger.fine("BreakpointImpl addEventRequest: " + eventRequest);
                this.requests.add(eventRequest);
                this.getDebugger().getOperator().register(eventRequest, this);
                if (this.getBreakpoint().getSuspend() == 2) {
                    eventRequest.setSuspendPolicy(2);
                } else {
                    eventRequest.setSuspendPolicy(1);
                }
                int n = this.getBreakpoint().getHitCountFilter();
                if (bl || n <= 0) break block7;
                eventRequest.addCountFilter(n);
                switch (this.getBreakpoint().getHitCountFilteringStyle()) {
                    case MULTIPLE: {
                        this.hitCountFilter = n;
                        break block8;
                    }
                    case EQUAL: {
                        this.hitCountFilter = 0;
                        break block8;
                    }
                    case GREATER: {
                        this.hitCountFilter = -1;
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException(this.getBreakpoint().getHitCountFilteringStyle().name());
                    }
                }
            }
            this.hitCountFilter = 0;
        }
        eventRequest.enable();
    }

    private synchronized void removeAllEventRequests() {
        if (this.requests.size() == 0) {
            return;
        }
        VirtualMachine virtualMachine = this.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        int n = this.requests.size();
        try {
            for (int i = 0; i < n; ++i) {
                EventRequest eventRequest = this.requests.get(i);
                logger.fine("BreakpointImpl removeEventRequest: " + eventRequest);
                virtualMachine.eventRequestManager().deleteEventRequest(eventRequest);
                this.getDebugger().getOperator().unregister(eventRequest);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (InternalException internalException) {
            // empty catch block
        }
        this.requests = new LinkedList<EventRequest>();
    }

    private synchronized void removeEventRequest(EventRequest eventRequest) {
        VirtualMachine virtualMachine = this.getDebugger().getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        try {
            logger.fine("BreakpointImpl removeEventRequest: " + eventRequest);
            virtualMachine.eventRequestManager().deleteEventRequest(eventRequest);
            this.getDebugger().getOperator().unregister(eventRequest);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (InternalException internalException) {
            // empty catch block
        }
        this.requests.remove(eventRequest);
    }

    protected abstract EventRequest createEventRequest(EventRequest var1);

    public boolean processCondition(Event event, String string, ThreadReference threadReference, Value value) {
        boolean bl;
        if (this.hitCountFilter > 0) {
            event.request().disable();
            event.request().enable();
        }
        if (this.hitCountFilter == -1) {
            event.request().disable();
            this.removeEventRequest(event.request());
            this.addEventRequest(this.createEventRequest(event.request()), true);
        }
        ReturnVariableImpl returnVariableImpl = null;
        if (this.getBreakpoint() instanceof MethodBreakpoint && (((MethodBreakpoint)this.getBreakpoint()).getBreakpointType() & 2) != 0 && value != null) {
            JPDAThreadImpl jPDAThreadImpl = (JPDAThreadImpl)this.getDebugger().getThread(threadReference);
            ReturnVariableImpl returnVariableImpl2 = new ReturnVariableImpl(this.getDebugger(), value, "", jPDAThreadImpl.getMethodName());
            jPDAThreadImpl.setReturnVariable(returnVariableImpl2);
            returnVariableImpl = returnVariableImpl2;
        }
        if (string != null && string.length() > 0) {
            try {
                this.getDebugger().setAltCSF(threadReference.frame(0));
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                String string2 = "Thread '" + threadReference.name() + "': status = " + threadReference.status() + ", is suspended = " + threadReference.isSuspended() + ", suspend count = " + threadReference.suspendCount() + ", is at breakpoint = " + threadReference.isAtBreakpoint();
                Logger.getLogger(BreakpointImpl.class.getName()).log(Level.INFO, string2, incompatibleThreadStateException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            bl = this.evaluateCondition(string, threadReference);
            this.getDebugger().setAltCSF(null);
        } else {
            bl = true;
        }
        if (bl) {
            this.processedReturnVariable = returnVariableImpl;
        }
        return bl;
    }

    protected boolean perform(Event event, ThreadReference threadReference, ReferenceType referenceType, Value value) {
        JPDABreakpointEvent jPDABreakpointEvent;
        Variable variable = this.processedReturnVariable;
        this.processedReturnVariable = null;
        if (variable == null) {
            variable = this.debugger.getVariable(value);
        }
        if (this.conditionException == null) {
            jPDABreakpointEvent = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, 1, this.debugger.getThread(threadReference), referenceType, variable);
        } else {
            jPDABreakpointEvent = new JPDABreakpointEvent(this.getBreakpoint(), (JPDADebugger)this.debugger, this.conditionException, this.debugger.getThread(threadReference), referenceType, variable);
            this.conditionException = null;
        }
        this.getDebugger().fireBreakpointEvent(this.getBreakpoint(), jPDABreakpointEvent);
        boolean bl = this.getBreakpoint().getSuspend() == 0 || jPDABreakpointEvent.getResume();
        logger.fine("BreakpointImpl: perform breakpoint: " + this + " resume: " + bl);
        if (!bl) {
            bl = this.checkWhetherResumeToFinishStep(threadReference);
        }
        if (!bl) {
            ((JPDAThreadImpl)this.getDebugger().getThread(threadReference)).setCurrentBreakpoint(this.breakpoint);
        }
        return bl;
    }

    private boolean checkWhetherResumeToFinishStep(ThreadReference threadReference) {
        int n;
        List<StepRequest> list = threadReference.virtualMachine().eventRequestManager().stepRequests();
        if (list.size() > 0 && ((n = this.breakpoint.getSuspend()) == 2 || n == 1)) {
            Object object;
            boolean bl = false;
            ArrayList<StepRequest> arrayList = new ArrayList<StepRequest>(list);
            for (int i = 0; i < arrayList.size(); ++i) {
                int n2;
                object = (StepRequest)arrayList.get(i);
                ThreadReference threadReference2 = object.thread();
                if (!object.isEnabled()) {
                    arrayList.remove(i);
                    continue;
                }
                try {
                    n2 = object.thread().status();
                }
                catch (ObjectCollectedException objectCollectedException) {
                    n2 = 0;
                }
                if (n2 == 0) {
                    threadReference.virtualMachine().eventRequestManager().deleteEventRequest((EventRequest)object);
                    this.debugger.getOperator().unregister((EventRequest)object);
                    arrayList.remove(i);
                    continue;
                }
                if (!threadReference.equals(threadReference2)) continue;
                bl = true;
            }
            if (bl) {
                return false;
            }
            if (arrayList.size() > 0 && (bl || n == 2)) {
                Boolean bl2 = this.debugger.getStepInterruptByBptResumeDecision();
                if (bl2 != null) {
                    return bl2;
                }
                object = (JPDAThreadImpl)this.debugger.getThread(threadReference);
                ((JPDAThreadImpl)object).setStepSuspendedBy(this.breakpoint);
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean evaluateCondition(String string, ThreadReference threadReference) {
        try {
            try {
                boolean bl;
                Object object = this.debugger.LOCK;
                synchronized (object) {
                    StackFrame stackFrame = threadReference.frame(0);
                    bl = this.evaluateConditionIn(string, stackFrame, 0);
                }
                logger.fine("BreakpointImpl: perform breakpoint (condition = " + bl + "): " + this + " resume: " + !bl);
                return bl;
            }
            catch (ParseException parseException) {
                this.conditionException = parseException;
                logger.fine("BreakpointImpl: perform breakpoint (bad condition): '" + string + "', got " + parseException.getMessage());
                return true;
            }
            catch (InvalidExpressionException invalidExpressionException) {
                this.conditionException = invalidExpressionException;
                logger.fine("BreakpointImpl: perform breakpoint (bad condition): '" + string + "', got " + invalidExpressionException.getMessage());
                return true;
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            Exceptions.printStackTrace((Throwable)incompatibleThreadStateException);
            return true;
        }
    }

    private boolean evaluateConditionIn(String string, StackFrame stackFrame, int n) throws ParseException, InvalidExpressionException {
        if (this.compiledCondition == null || !this.compiledCondition.getExpression().equals(string)) {
            this.compiledCondition = Expression.parse(string, "1.5.0");
        }
        Value value = this.getDebugger().evaluateIn(this.compiledCondition, stackFrame, n);
        try {
            return ((BooleanValue)value).booleanValue();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidExpressionException("Expecting boolean value instead of " + value.type());
        }
        catch (NullPointerException nullPointerException) {
            throw new InvalidExpressionException((Throwable)nullPointerException);
        }
    }

    static boolean match(String string, String string2) {
        if (string2.startsWith("*")) {
            return string.endsWith(string2.substring(1));
        }
        if (string2.endsWith("*")) {
            return string.startsWith(string2.substring(0, string2.length() - 1));
        }
        return string.equals(string2);
    }

    private static final class ValidityChangeEvent
    extends ChangeEvent {
        private String reason;

        public ValidityChangeEvent(Breakpoint.VALIDITY vALIDITY, String string) {
            super(vALIDITY);
            this.reason = string;
        }

        public String toString() {
            return this.reason;
        }
    }
}

