/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineBreakpointImpl
extends ClassBasedBreakpoint {
    private static Logger logger = Logger.getLogger("org.netbeans.modules.debugger.jpda.breakpoints");
    private int lineNumber;
    private BreakpointsReader reader;

    public LineBreakpointImpl(LineBreakpoint lineBreakpoint, BreakpointsReader breakpointsReader, JPDADebuggerImpl jPDADebuggerImpl, Session session, SourcePath sourcePath) {
        super((JPDABreakpoint)lineBreakpoint, breakpointsReader, jPDADebuggerImpl, session);
        this.reader = breakpointsReader;
        this.updateLineNumber();
        this.setSourceRoot(sourcePath.getSourceRoot(lineBreakpoint.getURL()));
        this.set();
    }

    private void updateLineNumber() {
        int n = this.getBreakpoint().getLineNumber();
        String string = this.getBreakpoint().getURL();
        this.lineNumber = n = EditorContextBridge.getContext().getLineNumber((Object)this.getBreakpoint(), (Object)this.getDebugger());
    }

    protected LineBreakpoint getBreakpoint() {
        return (LineBreakpoint)super.getBreakpoint();
    }

    @Override
    void fixed() {
        logger.fine("LineBreakpoint fixed: " + this);
        this.updateLineNumber();
        super.fixed();
    }

    @Override
    protected void setRequests() {
        LineBreakpoint lineBreakpoint = this.getBreakpoint();
        this.updateLineNumber();
        String[] stringArray = new String[]{null};
        String string = this.getDebugger().getEngineContext().getRelativePath(lineBreakpoint.getURL(), '/', true);
        String string2 = null;
        if (string == null) {
            string2 = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoSourceRoot", (Object)lineBreakpoint.getURL());
        } else if (!this.isEnabled(string, stringArray)) {
            string2 = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_DifferentPrefferedSourceRoot", (Object)stringArray[0]);
        }
        if (string2 != null) {
            ErrorManager.getDefault().log(16, "Unable to submit line breakpoint to " + lineBreakpoint.getURL() + " at line " + this.lineNumber + ", reason: " + string2);
            this.setValidity(Breakpoint.VALIDITY.INVALID, string2);
            return;
        }
        String string3 = lineBreakpoint.getPreferredClassName();
        if (string3 == null && (string3 = this.reader.findCachedClassName((JPDABreakpoint)lineBreakpoint)) == null && (string3 = EditorContextBridge.getContext().getClassName(lineBreakpoint.getURL(), this.lineNumber)) != null && string3.length() > 0) {
            this.reader.storeCachedClassName((JPDABreakpoint)lineBreakpoint, string3);
        }
        if (string3 == null || string3.length() == 0) {
            logger.warning("Class name not defined for breakpoint " + lineBreakpoint);
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoBPClass"));
            return;
        }
        logger.fine("LineBreakpoint " + lineBreakpoint + " - setting request for " + string3);
        this.setClassRequests(new String[]{string3}, new String[0], 1);
        this.checkLoadedClasses(string3, null);
    }

    @Override
    protected void classLoaded(ReferenceType referenceType) {
        LineBreakpoint lineBreakpoint = this.getBreakpoint();
        logger.fine("Class " + referenceType + " loaded for breakpoint " + lineBreakpoint);
        String[] stringArray = new String[]{null};
        List list = LineBreakpointImpl.getLocations(referenceType, lineBreakpoint.getStratum(), lineBreakpoint.getSourceName(), lineBreakpoint.getSourcePath(), this.lineNumber, stringArray);
        if (list.isEmpty()) {
            ErrorManager.getDefault().log(16, "Unable to submit line breakpoint to " + referenceType.name() + " at line " + this.lineNumber + ", reason: " + stringArray[0]);
            this.setValidity(Breakpoint.VALIDITY.INVALID, stringArray[0]);
            return;
        }
        for (Location location : list) {
            try {
                BreakpointRequest breakpointRequest = this.getEventRequestManager().createBreakpointRequest(location);
                this.setFilters(breakpointRequest);
                this.addEventRequest(breakpointRequest);
                this.setValidity(Breakpoint.VALIDITY.VALID, null);
            }
            catch (VMDisconnectedException vMDisconnectedException) {}
        }
    }

    @Override
    protected EventRequest createEventRequest(EventRequest eventRequest) {
        Location location = ((BreakpointRequest)eventRequest).location();
        BreakpointRequest breakpointRequest = this.getEventRequestManager().createBreakpointRequest(location);
        this.setFilters(breakpointRequest);
        return breakpointRequest;
    }

    private void setFilters(BreakpointRequest breakpointRequest) {
        JPDAThread[] jPDAThreadArray;
        JPDAThread[] jPDAThreadArray2 = this.getBreakpoint().getThreadFilters((JPDADebugger)this.getDebugger());
        if (jPDAThreadArray2 != null && jPDAThreadArray2.length > 0) {
            jPDAThreadArray = jPDAThreadArray2;
            int n = jPDAThreadArray.length;
            for (int i = 0; i < n; ++i) {
                JPDAThread jPDAThread = jPDAThreadArray[i];
                breakpointRequest.addThreadFilter(((JPDAThreadImpl)jPDAThread).getThreadReference());
            }
        }
        if ((jPDAThreadArray = this.getBreakpoint().getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
            for (JPDAThread jPDAThread : jPDAThreadArray) {
                breakpointRequest.addInstanceFilter((ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
            }
        }
    }

    @Override
    public boolean processCondition(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.processCondition(event, this.getBreakpoint().getCondition(), ((BreakpointEvent)event).thread(), null);
        }
        return true;
    }

    @Override
    public boolean exec(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.perform(event, ((BreakpointEvent)event).thread(), ((LocatableEvent)event).location().declaringType(), null);
        }
        return super.exec(event);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("lineNumber".equals(propertyChangeEvent.getPropertyName())) {
            int n = this.lineNumber;
            this.updateLineNumber();
            if (this.lineNumber == n) {
                return;
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    private static List getLocations(ReferenceType referenceType, String string, String string2, String string3, int n, String[] stringArray) {
        try {
            stringArray[0] = null;
            List<Location> list = LineBreakpointImpl.locationsOfLineInClass(referenceType, string, string2, string3, n, stringArray);
            if (list.isEmpty() && stringArray[0] == null) {
                stringArray[0] = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoLocation", (Object)Integer.toString(n), (Object)referenceType.name());
            }
            return list;
        }
        catch (AbsentInformationException absentInformationException) {
            stringArray[0] = NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_NoLineInfo", (Object)referenceType.name());
        }
        catch (ObjectCollectedException objectCollectedException) {
            stringArray[0] = objectCollectedException.getLocalizedMessage();
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            ErrorManager.getDefault().notify(65536, (Throwable)classNotPreparedException);
        }
        catch (InternalException internalException) {
            ErrorManager.getDefault().annotate((Throwable)internalException, NbBundle.getMessage(LineBreakpointImpl.class, (String)"MSG_jdi_internal_error"));
            ErrorManager.getDefault().notify((Throwable)internalException);
            stringArray[0] = internalException.getLocalizedMessage();
        }
        return Collections.EMPTY_LIST;
    }

    private static List<Location> locationsOfLineInClass(ReferenceType referenceType, String string, String string2, String string3, int n, String[] stringArray) throws AbsentInformationException, ObjectCollectedException, ClassNotPreparedException, InternalException {
        List<Location> list = referenceType.locationsOfLine(string, string2, n);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("LineBreakpoint: locations for ReferenceType=" + referenceType + ", stratum=" + string + ", source name=" + string2 + ", bpSourcePath=" + string3 + ", lineNumber=" + n + " are: {" + list + "}");
        }
        if (!list.isEmpty()) {
            if (string3 == null) {
                return list;
            }
            string3 = string3.replace(File.separatorChar, '/');
            ArrayList<Location> arrayList = new ArrayList<Location>(list.size());
            for (Location location : list) {
                String string4 = location.sourcePath().replace(File.separatorChar, '/');
                if ((string4 = LineBreakpointImpl.normalize(string4)).equals(string3)) {
                    arrayList.add(location);
                    continue;
                }
                stringArray[0] = "Breakpoint source path '" + string3 + "' is different from the location source path '" + string4 + "'.";
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("LineBreakpoint: relevant location(s) for path '" + string3 + "': " + arrayList);
            }
            if (!arrayList.isEmpty()) {
                return arrayList;
            }
        }
        return Collections.emptyList();
    }

    private static String normalize(String string) {
        Pattern pattern = Pattern.compile("(/|\\A)\\./");
        Pattern pattern2 = Pattern.compile("(/|\\A)([^/]+?)/\\.\\./");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            string = matcher.replaceAll("$1");
            matcher = pattern.matcher(string);
        }
        matcher = pattern2.matcher(string);
        while (matcher.find()) {
            if (matcher.group(2).equals("..")) continue;
            string = string.substring(0, matcher.start()) + matcher.group(1) + string.substring(matcher.end());
            matcher = pattern2.matcher(string);
        }
        return string;
    }
}

