/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodEntryEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.ClassBasedBreakpoint;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.NbBundle;

public class MethodBreakpointImpl
extends ClassBasedBreakpoint {
    private static final boolean IS_JDK_16 = !System.getProperty("java.version").startsWith("1.5");
    private MethodBreakpoint breakpoint;
    private Value[] returnValuePtr;

    public MethodBreakpointImpl(MethodBreakpoint methodBreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super((JPDABreakpoint)methodBreakpoint, jPDADebuggerImpl, session);
        this.breakpoint = methodBreakpoint;
        this.set();
    }

    public static boolean canGetMethodReturnValues(VirtualMachine virtualMachine) {
        if (!IS_JDK_16) {
            return false;
        }
        boolean bl = false;
        java.lang.reflect.Method method = null;
        try {
            method = virtualMachine.getClass().getMethod("canGetMethodReturnValues", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method != null) {
            try {
                method.setAccessible(true);
                Object object = method.invoke((Object)virtualMachine, new Object[0]);
                bl = Boolean.TRUE.equals(object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    protected void setRequests() {
        this.setClassRequests(this.breakpoint.getClassFilters(), this.breakpoint.getClassExclusionFilters(), 1);
        for (String string : this.breakpoint.getClassFilters()) {
            this.checkLoadedClasses(string, this.breakpoint.getClassExclusionFilters());
        }
    }

    protected EventRequest createEventRequest(EventRequest eventRequest) {
        if (eventRequest instanceof BreakpointRequest) {
            return this.getEventRequestManager().createBreakpointRequest(((BreakpointRequest)eventRequest).location());
        }
        if (eventRequest instanceof MethodEntryRequest) {
            JPDAThread[] jPDAThreadArray;
            MethodEntryRequest methodEntryRequest = this.getEventRequestManager().createMethodEntryRequest();
            ReferenceType referenceType = (ReferenceType)eventRequest.getProperty("ReferenceType");
            methodEntryRequest.addClassFilter(referenceType);
            JPDAThread[] jPDAThreadArray2 = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
            if (jPDAThreadArray2 != null && jPDAThreadArray2.length > 0) {
                jPDAThreadArray = jPDAThreadArray2;
                int n = jPDAThreadArray.length;
                for (int i = 0; i < n; ++i) {
                    JPDAThread jPDAThread = jPDAThreadArray[i];
                    methodEntryRequest.addThreadFilter(((JPDAThreadImpl)jPDAThread).getThreadReference());
                }
            }
            if ((jPDAThreadArray = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
                for (JPDAThread jPDAThread : jPDAThreadArray) {
                    methodEntryRequest.addInstanceFilter((ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
                }
            }
            Object object = eventRequest.getProperty("methodNames");
            methodEntryRequest.putProperty("methodNames", object);
            methodEntryRequest.putProperty("ReferenceType", referenceType);
            return methodEntryRequest;
        }
        if (eventRequest instanceof MethodExitRequest) {
            JPDAThread[] jPDAThreadArray;
            MethodExitRequest methodExitRequest = this.getEventRequestManager().createMethodExitRequest();
            ReferenceType referenceType = (ReferenceType)eventRequest.getProperty("ReferenceType");
            methodExitRequest.addClassFilter(referenceType);
            JPDAThread[] jPDAThreadArray3 = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
            if (jPDAThreadArray3 != null && jPDAThreadArray3.length > 0) {
                jPDAThreadArray = jPDAThreadArray3;
                int n = jPDAThreadArray.length;
                for (int i = 0; i < n; ++i) {
                    JPDAThread jPDAThread = jPDAThreadArray[i];
                    methodExitRequest.addThreadFilter(((JPDAThreadImpl)jPDAThread).getThreadReference());
                }
            }
            if ((jPDAThreadArray = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
                for (JPDAThread jPDAThread : jPDAThreadArray) {
                    methodExitRequest.addInstanceFilter((ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
                }
            }
            Object object = eventRequest.getProperty("methodNames");
            methodExitRequest.putProperty("methodNames", object);
            methodExitRequest.putProperty("ReferenceType", referenceType);
            return methodExitRequest;
        }
        return null;
    }

    public boolean processCondition(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.processCondition(event, this.breakpoint.getCondition(), ((BreakpointEvent)event).thread(), null);
        }
        if (event instanceof MethodEntryEvent) {
            String string = ((MethodEntryEvent)event).method().name();
            Set set = (Set)event.request().getProperty("methodNames");
            if (set == null || set.contains(string)) {
                return this.processCondition(event, this.breakpoint.getCondition(), ((MethodEntryEvent)event).thread(), null);
            }
            return false;
        }
        if (event instanceof MethodExitEvent) {
            String string = ((MethodExitEvent)event).method().name();
            Set set = (Set)event.request().getProperty("methodNames");
            if (set == null || set.contains(string)) {
                boolean bl;
                VirtualMachine virtualMachine;
                Value value = null;
                if (IS_JDK_16 && MethodBreakpointImpl.canGetMethodReturnValues(virtualMachine = event.virtualMachine())) {
                    java.lang.reflect.Method method = null;
                    try {
                        method = event.getClass().getDeclaredMethod("returnValue", new Class[0]);
                    }
                    catch (Exception exception) {
                        method = null;
                    }
                    if (method != null) {
                        try {
                            method.setAccessible(true);
                            Object object = method.invoke((Object)event, new Object[0]);
                            value = (Value)object;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (bl = this.processCondition(event, this.breakpoint.getCondition(), ((MethodExitEvent)event).thread(), value)) {
                    this.returnValuePtr = new Value[]{value};
                }
                return bl;
            }
            return false;
        }
        return true;
    }

    public boolean exec(Event event) {
        if (event instanceof BreakpointEvent) {
            return this.perform(event, ((BreakpointEvent)event).thread(), ((LocatableEvent)event).location().declaringType(), null);
        }
        if (event instanceof MethodEntryEvent) {
            ReferenceType referenceType = null;
            if (((LocatableEvent)event).location() != null) {
                referenceType = ((LocatableEvent)event).location().declaringType();
            }
            return this.perform(event, ((MethodEntryEvent)event).thread(), referenceType, null);
        }
        if (event instanceof MethodExitEvent) {
            Value value;
            ReferenceType referenceType = null;
            if (((LocatableEvent)event).location() != null) {
                referenceType = ((LocatableEvent)event).location().declaringType();
            }
            if (this.returnValuePtr != null) {
                value = this.returnValuePtr[0];
                this.returnValuePtr = null;
            } else {
                value = null;
            }
            return this.perform(event, ((MethodExitEvent)event).thread(), referenceType, value);
        }
        return super.exec(event);
    }

    protected void classLoaded(ReferenceType referenceType) {
        Iterator<Method> iterator = referenceType.methods().iterator();
        MethodEntryRequest methodEntryRequest = null;
        MethodExitRequest methodExitRequest = null;
        HashSet<String> hashSet = null;
        HashSet<String> hashSet2 = null;
        boolean bl = false;
        String string = this.breakpoint.getMethodName();
        String string2 = referenceType.name();
        int n = string2.lastIndexOf(46);
        if (n > 0) {
            string2 = string2.substring(n + 1);
        }
        if (string.equals(string2)) {
            string = "<init>";
        }
        String string3 = this.breakpoint.getMethodSignature();
        while (iterator.hasNext()) {
            JPDAThread jPDAThread;
            int n2;
            int n3;
            JPDAThread[] jPDAThreadArray;
            JPDAThread[] jPDAThreadArray2;
            Method method = iterator.next();
            if (!string.equals("") && (!MethodBreakpointImpl.match(method.name(), string) || string3 != null && !MethodBreakpointImpl.egualMethodSignatures(string3, method.signature()))) continue;
            if ((this.breakpoint.getBreakpointType() & 1) != 0) {
                if (method.location() != null && !method.isNative()) {
                    jPDAThreadArray2 = method.location();
                    try {
                        jPDAThreadArray = this.getEventRequestManager().createBreakpointRequest((Location)jPDAThreadArray2);
                        this.addEventRequest((EventRequest)jPDAThreadArray);
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        // empty catch block
                    }
                    bl = true;
                } else {
                    if (methodEntryRequest == null) {
                        methodEntryRequest = this.getEventRequestManager().createMethodEntryRequest();
                        methodEntryRequest.addClassFilter(referenceType);
                        jPDAThreadArray2 = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
                        if (jPDAThreadArray2 != null && jPDAThreadArray2.length > 0) {
                            jPDAThreadArray = jPDAThreadArray2;
                            n3 = jPDAThreadArray.length;
                            for (n2 = 0; n2 < n3; ++n2) {
                                JPDAThread jPDAThread2 = jPDAThreadArray[n2];
                                methodEntryRequest.addThreadFilter(((JPDAThreadImpl)jPDAThread2).getThreadReference());
                            }
                        }
                        if ((jPDAThreadArray = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
                            JPDAThread[] jPDAThreadArray3 = jPDAThreadArray;
                            n2 = jPDAThreadArray3.length;
                            for (int i = 0; i < n2; ++i) {
                                jPDAThread = jPDAThreadArray3[i];
                                methodEntryRequest.addInstanceFilter((ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
                            }
                        }
                        hashSet = new HashSet<String>();
                        methodEntryRequest.putProperty("methodNames", hashSet);
                        methodEntryRequest.putProperty("ReferenceType", referenceType);
                    }
                    hashSet.add(method.name());
                }
            }
            if ((this.breakpoint.getBreakpointType() & 2) == 0) continue;
            if (methodExitRequest == null) {
                methodExitRequest = this.getEventRequestManager().createMethodExitRequest();
                methodExitRequest.addClassFilter(referenceType);
                jPDAThreadArray2 = this.breakpoint.getThreadFilters((JPDADebugger)this.getDebugger());
                if (jPDAThreadArray2 != null && jPDAThreadArray2.length > 0) {
                    jPDAThreadArray = jPDAThreadArray2;
                    n3 = jPDAThreadArray.length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        JPDAThread jPDAThread3 = jPDAThreadArray[n2];
                        methodExitRequest.addThreadFilter(((JPDAThreadImpl)jPDAThread3).getThreadReference());
                    }
                }
                if ((jPDAThreadArray = this.breakpoint.getInstanceFilters((JPDADebugger)this.getDebugger())) != null && jPDAThreadArray.length > 0) {
                    JPDAThread[] jPDAThreadArray4 = jPDAThreadArray;
                    n2 = jPDAThreadArray4.length;
                    for (int i = 0; i < n2; ++i) {
                        jPDAThread = jPDAThreadArray4[i];
                        methodExitRequest.addInstanceFilter((ObjectReference)((JDIVariable)jPDAThread).getJDIValue());
                    }
                }
                hashSet2 = new HashSet<String>();
                methodExitRequest.putProperty("methodNames", hashSet2);
                methodExitRequest.putProperty("ReferenceType", referenceType);
            }
            hashSet2.add(method.name());
        }
        if (methodEntryRequest != null) {
            this.addEventRequest(methodEntryRequest);
        }
        if (methodExitRequest != null) {
            this.addEventRequest(methodExitRequest);
        }
        if (bl || methodEntryRequest != null || methodExitRequest != null) {
            this.setValidity(Breakpoint.VALIDITY.VALID, null);
        } else if (string3 == null) {
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(MethodBreakpointImpl.class, (String)"MSG_NoMethod", (Object)referenceType.name(), (Object)string));
        } else {
            this.setValidity(Breakpoint.VALIDITY.INVALID, NbBundle.getMessage(MethodBreakpointImpl.class, (String)"MSG_NoMethodSign", (Object)referenceType.name(), (Object)string, (Object)string3));
        }
    }

    private static boolean egualMethodSignatures(String string, String string2) {
        int n = string.lastIndexOf(")");
        if (n > 0) {
            string = string.substring(0, n);
        }
        if ((n = string2.lastIndexOf(")")) > 0) {
            string2 = string2.substring(0, n);
        }
        return string.equals(string2);
    }
}

