/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluationContext {
    private StackFrame frame;
    private int frameDepth;
    private ThreadReference thread;
    private List<String> sourceImports;
    private List<String> staticImports;
    private boolean canInvokeMethods;
    private Runnable methodInvokePreproc;
    private JPDADebuggerImpl debugger;
    private Trees trees;
    private CompilationUnitTree compilationUnitTree;
    private TreePath treePath;
    private Map<Tree, VariableInfo> variables = new HashMap<Tree, VariableInfo>();

    public EvaluationContext(ThreadReference threadReference, StackFrame stackFrame, int n, List<String> list, List<String> list2, boolean bl, Runnable runnable, JPDADebuggerImpl jPDADebuggerImpl) {
        if (threadReference == null) {
            throw new IllegalArgumentException("Thread argument must not be null");
        }
        if (stackFrame == null) {
            throw new IllegalArgumentException("Frame argument must not be null");
        }
        if (list == null) {
            throw new IllegalArgumentException("Imports argument must not be null");
        }
        if (list2 == null) {
            throw new IllegalArgumentException("Static imports argument must not be null");
        }
        this.thread = threadReference;
        this.frame = stackFrame;
        this.frameDepth = n;
        this.sourceImports = list;
        this.staticImports = list2;
        this.canInvokeMethods = bl;
        this.methodInvokePreproc = runnable;
        this.debugger = jPDADebuggerImpl;
    }

    public List<String> getStaticImports() {
        return this.staticImports;
    }

    public List<String> getImports() {
        return this.sourceImports;
    }

    public StackFrame getFrame() {
        return this.frame;
    }

    public boolean canInvokeMethods() {
        return this.canInvokeMethods;
    }

    void setCanInvokeMethods(boolean bl) {
        this.canInvokeMethods = bl;
    }

    void methodToBeInvoked() {
        if (this.methodInvokePreproc != null) {
            this.methodInvokePreproc.run();
        }
    }

    void methodInvokeDone() throws IncompatibleThreadStateException {
        this.frame = this.thread.frame(this.frameDepth);
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    public void setTrees(Trees trees) {
        this.trees = trees;
    }

    Trees getTrees() {
        return this.trees;
    }

    public void setCompilationUnit(CompilationUnitTree compilationUnitTree) {
        this.compilationUnitTree = compilationUnitTree;
    }

    CompilationUnitTree getCompilationUnit() {
        return this.compilationUnitTree;
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    TreePath getTreePath() {
        return this.treePath;
    }

    Map<Tree, VariableInfo> getVariables() {
        return this.variables;
    }

    static final class VariableInfo {
        public Field field;
        public ObjectReference fieldObject;
        public LocalVariable var;

        public VariableInfo(Field field) {
            this.field = field;
        }

        public VariableInfo(Field field, ObjectReference objectReference) {
            this.field = field;
            this.fieldObject = objectReference;
        }

        public VariableInfo(LocalVariable localVariable) {
            this.var = localVariable;
        }
    }
}

