/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.expr;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluationContext;
import org.netbeans.modules.debugger.jpda.expr.EvaluationException2;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.expr.Expression2;
import org.netbeans.modules.debugger.jpda.expr.InvocationExceptionTranslated;
import org.netbeans.modules.debugger.jpda.expr.Operators;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeEvaluator {
    private Expression2 expression;
    private EvaluationContext evaluationContext;
    private StackFrame frame;
    private VirtualMachine vm;
    private ThreadReference frameThread;
    private int frameIndex;
    private String currentPackage;
    private Operators operators;
    private static final Logger loggerMethod = Logger.getLogger("org.netbeans.modules.debugger.jpda.invokeMethod");

    TreeEvaluator(Expression2 expression2, EvaluationContext evaluationContext) {
        this.expression = expression2;
        this.evaluationContext = evaluationContext;
    }

    public Value evaluate() throws EvaluationException2, IncompatibleThreadStateException, InvalidExpressionException {
        this.frame = this.evaluationContext.getFrame();
        this.vm = this.evaluationContext.getFrame().virtualMachine();
        this.frameThread = this.frame.thread();
        this.frameIndex = this.indexOf(this.frameThread.frames(), this.frame);
        if (this.frameIndex == -1) {
            throw new IncompatibleThreadStateException("Thread does not contain current frame");
        }
        this.currentPackage = this.evaluationContext.getFrame().location().declaringType().name();
        int n = this.currentPackage.lastIndexOf(46);
        this.currentPackage = n > 0 ? this.currentPackage.substring(0, n + 1) : "";
        this.operators = new Operators(this.vm);
        int n2 = this.frame.location().lineNumber();
        String string = this.evaluationContext.getDebugger().getEngineContext().getURL(this.frame, "Java");
        try {
            Mirror mirror = EditorContextBridge.parseExpression(this.expression.getExpression(), string, n2, new EvaluatorVisitor(this.expression), this.evaluationContext, this.evaluationContext.getDebugger().getEngineContext().getContext());
            if (mirror instanceof Value || mirror == null) {
                return (Value)mirror;
            }
            throw new InvalidExpressionException(this.expression.getExpression());
        }
        catch (IllegalStateException illegalStateException) {
            Throwable throwable = illegalStateException.getCause();
            if (throwable instanceof IncompatibleThreadStateException) {
                throw (IncompatibleThreadStateException)throwable;
            }
            if (throwable instanceof InvalidExpressionException) {
                throw (InvalidExpressionException)throwable;
            }
            throw illegalStateException;
        }
        catch (InternalException internalException) {
            throw new InvalidExpressionException(internalException.getLocalizedMessage());
        }
    }

    private int indexOf(List<StackFrame> list, StackFrame stackFrame) {
        int n = list.size();
        Location location = stackFrame.location();
        for (int i = 0; i < n; ++i) {
            if (!((Object)location).equals(list.get(i).location())) continue;
            return i;
        }
        return -1;
    }

    public static Value invokeVirtual(ObjectReference objectReference, Method method, ThreadReference threadReference, List<Value> list, JPDADebuggerImpl jPDADebuggerImpl) throws InvalidExpressionException {
        try {
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("STARTED : " + objectReference + "." + method + " (" + list + ") in thread " + threadReference);
            }
            Value value = objectReference.invokeMethod(threadReference, method, list, 1);
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("   return = " + value);
            }
            Value value2 = value;
            return value2;
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)incompatibleThreadStateException);
            invalidExpressionException.initCause((Throwable)incompatibleThreadStateException);
            throw invalidExpressionException;
        }
        catch (InvocationException invocationException) {
            InvocationExceptionTranslated invocationExceptionTranslated = new InvocationExceptionTranslated(invocationException, jPDADebuggerImpl);
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)((Object)invocationExceptionTranslated));
            invalidExpressionException.initCause((Throwable)((Object)invocationExceptionTranslated));
            throw invalidExpressionException;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            InvalidExpressionException invalidExpressionException = new InvalidExpressionException((Throwable)unsupportedOperationException);
            invalidExpressionException.initCause((Throwable)unsupportedOperationException);
            throw invalidExpressionException;
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw new InvalidExpressionException(NbBundle.getMessage(TreeEvaluator.class, (String)"CTL_EvalError_collected"));
        }
        finally {
            if (loggerMethod.isLoggable(Level.FINE)) {
                loggerMethod.fine("FINISHED: " + objectReference + "." + method + " (" + list + ") in thread " + threadReference);
            }
        }
    }
}

