/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.AbstractVariable;
import org.netbeans.modules.debugger.jpda.models.ArrayFieldVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.models.ReturnVariableImpl;
import org.netbeans.modules.debugger.jpda.models.ThisVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class LocalsTreeModel
implements TreeModel,
PropertyChangeListener {
    private static boolean verbose = System.getProperty("netbeans.debugger.viewrefresh") != null && System.getProperty("netbeans.debugger.viewrefresh").indexOf(108) >= 0;
    private static final int ARRAY_CHILDREN_NESTED_LENGTH = 100;
    private JPDADebuggerImpl debugger;
    private Listener listener;
    private List<ModelListener> listeners = new ArrayList<ModelListener>();
    private PropertyChangeListener[] varListeners;
    private Map<Value, ArrayChildrenNode> cachedArrayChildren = new WeakHashMap<Value, ArrayChildrenNode>();

    public LocalsTreeModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
    }

    public Object getRoot() {
        return "Root";
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireTableValueChangedChanged(propertyChangeEvent.getSource(), null);
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        Object[] objectArray = this.getChildrenImpl(object, n, n2);
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof Customizer)) continue;
            ((Customizer)objectArray[i]).addPropertyChangeListener(this);
        }
        return objectArray;
    }

    public Object[] getChildrenImpl(Object object, int n, int n2) throws UnknownTypeException {
        try {
            if (object.equals("Root")) {
                Object[] objectArray = this.getLocalVariables(n, n2);
                return objectArray;
            }
            if (object instanceof AbstractObjectVariable) {
                AbstractObjectVariable abstractObjectVariable = (AbstractObjectVariable)object;
                boolean bl = abstractObjectVariable.getInnerValue() instanceof ArrayReference;
                if (bl) {
                    n2 = abstractObjectVariable.getFieldsCount();
                }
                if (bl && n2 - n > 100) {
                    ArrayChildrenNode arrayChildrenNode = this.cachedArrayChildren.get(abstractObjectVariable.getInnerValue());
                    if (arrayChildrenNode == null) {
                        arrayChildrenNode = new ArrayChildrenNode(abstractObjectVariable);
                        this.cachedArrayChildren.put(abstractObjectVariable.getInnerValue(), arrayChildrenNode);
                    } else {
                        arrayChildrenNode.update(abstractObjectVariable);
                    }
                    return arrayChildrenNode.getChildren();
                }
                return abstractObjectVariable.getFields(n, Math.min(n2, abstractObjectVariable.getFieldsCount()));
            }
            if (object instanceof AbstractVariable) {
                return new Object[0];
            }
            if (object instanceof ArrayChildrenNode) {
                return ((ArrayChildrenNode)object).getChildren();
            }
            if (object instanceof JPDAClassType) {
                JPDAClassType jPDAClassType = (JPDAClassType)object;
                List list = jPDAClassType.staticFields();
                Object[] objectArray = new Object[1 + list.size()];
                objectArray[0] = jPDAClassType.classObject();
                System.arraycopy(list.toArray(), 0, objectArray, 1, list.size());
                return objectArray;
            }
            if (object instanceof EditorContext.Operation) {
                boolean bl;
                List list;
                JPDAThread jPDAThread;
                Object[] objectArray = new Object[]{null, null};
                CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
                if (callStackFrameImpl == null) {
                    return new Object[0];
                }
                EditorContext.Operation operation = callStackFrameImpl.getThread().getCurrentOperation();
                EditorContext.Operation operation2 = null;
                if (operation != null && (jPDAThread = this.debugger.getCurrentThread()) != null && (list = jPDAThread.getLastOperations()) != null && list.size() > 0) {
                    operation2 = (EditorContext.Operation)list.get(list.size() - 1);
                }
                boolean bl2 = bl = operation != operation2;
                if (bl) {
                    objectArray[0] = "operationArguments " + operation.getMethodName();
                }
                if ((list = callStackFrameImpl.getThread().getLastOperations()) != null && list.size() > 0 && ((EditorContext.Operation)list.get(0)).getReturnValue() != null) {
                    objectArray[1] = "lastOperations";
                }
                if (objectArray[0] == null && objectArray[1] == null) {
                    return new Object[0];
                }
                if (objectArray[0] == null) {
                    return new Object[]{objectArray[1]};
                }
                if (objectArray[1] == null) {
                    return new Object[]{objectArray[0]};
                }
                return objectArray;
            }
            if ("lastOperations" == object) {
                CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
                if (callStackFrameImpl == null) {
                    return new Object[0];
                }
                List list = callStackFrameImpl.getThread().getLastOperations();
                if (list == null) {
                    return new Object[0];
                }
                ArrayList<Variable> arrayList = new ArrayList<Variable>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    Variable variable = ((EditorContext.Operation)list.get(i)).getReturnValue();
                    if (variable == null) continue;
                    arrayList.add(variable);
                }
                return arrayList.toArray();
            }
            if (object instanceof String && ((String)object).startsWith("operationArguments")) {
                List<LocalVariable> list;
                CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
                if (callStackFrameImpl == null) {
                    return new Object[0];
                }
                EditorContext.Operation operation = callStackFrameImpl.getThread().getCurrentOperation();
                if (operation == null) {
                    return new Object[0];
                }
                try {
                    list = callStackFrameImpl.findOperationArguments(operation);
                }
                catch (NativeMethodException nativeMethodException) {
                    return new Object[]{"NativeMethodException"};
                }
                if (list == null) {
                    return new Object[0];
                }
                return list.toArray();
            }
            throw new UnknownTypeException(object);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return new Object[0];
        }
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        try {
            if (object.equals("Root")) {
                return Integer.MAX_VALUE;
            }
            if (object instanceof AbstractVariable) {
                AbstractVariable abstractVariable = (AbstractVariable)object;
                if (abstractVariable.getInnerValue() instanceof ArrayReference) {
                    return Integer.MAX_VALUE;
                }
                return Integer.MAX_VALUE;
            }
            if (object instanceof ArrayChildrenNode) {
                return Integer.MAX_VALUE;
            }
            if (object instanceof JPDAClassType) {
                return Integer.MAX_VALUE;
            }
            if (object instanceof JPDAClassType) {
                JPDAClassType jPDAClassType = (JPDAClassType)object;
                return 1 + jPDAClassType.staticFields().size();
            }
            if (object instanceof EditorContext.Operation) {
                return Integer.MAX_VALUE;
            }
            if ("lastOperations" == object) {
                CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
                if (callStackFrameImpl == null) {
                    return 0;
                }
                List list = callStackFrameImpl.getThread().getLastOperations();
                if (list != null) {
                    return list.size();
                }
                return 0;
            }
            if (object instanceof String && ((String)object).startsWith("operationArguments")) {
                return Integer.MAX_VALUE;
            }
            throw new UnknownTypeException(object);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return 0;
        }
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return false;
        }
        if (object instanceof AbstractVariable) {
            return !(((AbstractVariable)object).getInnerValue() instanceof ObjectReference);
        }
        if (object.toString().startsWith("SubArray")) {
            return false;
        }
        if (object.equals("NoInfo")) {
            return true;
        }
        if (object instanceof JPDAClassType) {
            return false;
        }
        if (object instanceof EditorContext.Operation) {
            return false;
        }
        if (object == "lastOperations") {
            return false;
        }
        if (object instanceof String && ((String)object).startsWith("operationArguments")) {
            return false;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(modelListener);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(modelListener);
            if (this.listeners.size() == 0) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTreeChanged() {
        ArrayList<ModelListener> arrayList;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)arrayList.get(i)).modelChanged((ModelEvent)new ModelEvent.TreeChanged((Object)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableValueChangedChanged(Object object, String string) {
        ArrayList<ModelListener> arrayList;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)arrayList.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, object, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChanged(Object object) {
        ArrayList<ModelListener> arrayList;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            arrayList = new ArrayList<ModelListener>(this.listeners);
        }
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)arrayList.get(i)).modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, object));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getLocalVariables(int n, int n2) {
        Object object = this.debugger.LOCK;
        synchronized (object) {
            CallStackFrameImpl callStackFrameImpl = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
            if (callStackFrameImpl == null) {
                return new String[]{"No current thread"};
            }
            StackFrame stackFrame = null;
            try {
                stackFrame = callStackFrameImpl.getStackFrame();
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                // empty catch block
            }
            if (stackFrame == null) {
                return new String[]{"No current thread"};
            }
            try {
                ReturnVariableImpl returnVariableImpl;
                ObjectReference objectReference = stackFrame.thisObject();
                List list = callStackFrameImpl.getThread().getLastOperations();
                if (list != null && list.size() > 0 && ((EditorContext.Operation)list.get(0)).getReturnValue() != null) {
                    boolean bl = true;
                    returnVariableImpl = null;
                } else {
                    returnVariableImpl = ((JPDAThreadImpl)callStackFrameImpl.getThread()).getReturnVariable();
                    boolean bl = false;
                }
                int n3 = returnVariableImpl != null ? 1 : 0;
                EditorContext.Operation operation = callStackFrameImpl.getThread().getCurrentOperation();
                int n4 = operation != null ? 1 : 0;
                int n5 = n3 + n4;
                if (objectReference == null) {
                    ReferenceType referenceType = stackFrame.location().declaringType();
                    LocalVariable[] localVariableArray = null;
                    localVariableArray = this.getLocalVariables(callStackFrameImpl, stackFrame, Math.max(n - n5 - 1, 0), Math.max(n2 - n5 - 1, 0));
                    Object[] objectArray = new Object[localVariableArray.length + n5 + 1];
                    if (n < 1 && n3 > 0) {
                        objectArray[0] = returnVariableImpl;
                    }
                    if (n < 1 && n4 > 0) {
                        objectArray[n3] = operation;
                    }
                    if (n < 1 + n5) {
                        objectArray[n5] = this.debugger.getClassType(referenceType);
                    }
                    System.arraycopy(localVariableArray, 0, objectArray, 1 + n5, localVariableArray.length);
                    return objectArray;
                }
                LocalVariable[] localVariableArray = null;
                localVariableArray = this.getLocalVariables(callStackFrameImpl, stackFrame, Math.max(n - n5 - 1, 0), Math.max(n2 - n5 - 1, 0));
                Object[] objectArray = new Object[localVariableArray.length + n5 + 1];
                if (n < 1 && n3 > 0) {
                    objectArray[0] = returnVariableImpl;
                }
                if (n < 1 && n4 > 0) {
                    objectArray[n3] = operation;
                }
                if (n < 1 + n5) {
                    objectArray[n5] = new ThisVariable(this.debugger, objectReference, "");
                }
                System.arraycopy(localVariableArray, 0, objectArray, 1 + n5, localVariableArray.length);
                return objectArray;
            }
            catch (NativeMethodException nativeMethodException) {
                return new String[]{"NativeMethodException"};
            }
            catch (InternalException internalException) {
                return new String[]{internalException.getMessage()};
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                return new String[]{"No current thread"};
            }
        }
    }

    private LocalVariable[] getLocalVariables(CallStackFrameImpl callStackFrameImpl, StackFrame stackFrame, int n, int n2) {
        LocalVariable[] localVariableArray;
        try {
            localVariableArray = callStackFrameImpl.getLocalVariables();
        }
        catch (AbsentInformationException absentInformationException) {
            localVariableArray = callStackFrameImpl.getMethodArguments();
        }
        if (localVariableArray == null) {
            localVariableArray = new LocalVariable[]{};
        }
        int n3 = localVariableArray.length;
        n2 = Math.min(n3, n2);
        if ((n = Math.min(n3, n)) != 0 || n2 != n3) {
            LocalVariable[] localVariableArray2 = new LocalVariable[n2 - n];
            for (int i = n; i < n2; ++i) {
                localVariableArray2[i - n] = localVariableArray[i];
            }
            localVariableArray = localVariableArray2;
        }
        this.updateVarListeners(localVariableArray);
        return localVariableArray;
    }

    private void updateVarListeners(LocalVariable[] localVariableArray) {
        this.varListeners = new PropertyChangeListener[localVariableArray.length];
        for (int i = 0; i < localVariableArray.length; ++i) {
            PropertyChangeListener propertyChangeListener;
            final LocalVariable localVariable = localVariableArray[i];
            this.varListeners[i] = propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    LocalsTreeModel.this.fireNodeChanged(localVariable);
                }
            };
            ((AbstractVariable)localVariable).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)propertyChangeListener, (Object)localVariable));
        }
    }

    public Variable getVariable(Value value) {
        if (value instanceof ObjectReference) {
            return new AbstractObjectVariable(this.debugger, (ObjectReference)value, null);
        }
        return new AbstractVariable(this.debugger, value, null);
    }

    JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    private static final class ArrayChildrenNode {
        private AbstractObjectVariable var;
        private int from = 0;
        private int length;
        private int maxIndexLog;

        public ArrayChildrenNode(AbstractObjectVariable abstractObjectVariable) {
            this(abstractObjectVariable, 0, abstractObjectVariable.getFieldsCount(), -1);
        }

        private ArrayChildrenNode(AbstractObjectVariable abstractObjectVariable, int n, int n2, int n3) {
            this.var = abstractObjectVariable;
            this.from = n;
            this.length = n2;
            if (n3 < 0) {
                n3 = n + n2 - 1;
            }
            this.maxIndexLog = ArrayFieldVariable.log10(n3);
        }

        private static int pow(int n, int n2) {
            if (n2 == 0) {
                return 1;
            }
            int n3 = n;
            for (int i = 1; i < n2; ++i) {
                n3 *= n;
            }
            return n3;
        }

        public Object[] getChildren() {
            if (this.length > 100) {
                int n = (int)Math.ceil(Math.log(this.length) / Math.log(100.0) - 1.0);
                int n2 = ArrayChildrenNode.pow(100, n);
                int n3 = (int)Math.ceil((double)this.length / (double)n2);
                Object[] objectArray = new Object[n3];
                for (int i = 0; i < n3; ++i) {
                    int n4 = n2;
                    if (i == n3 - 1 && (n4 = this.length % n2) == 0) {
                        n4 = n2;
                    }
                    objectArray[i] = new ArrayChildrenNode(this.var, this.from + i * n2, n4, this.from + this.length - 1);
                }
                return objectArray;
            }
            return this.var.getFields(this.from, this.from + this.length);
        }

        public void update(AbstractObjectVariable abstractObjectVariable) {
            this.var = abstractObjectVariable;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ArrayChildrenNode)) {
                return false;
            }
            ArrayChildrenNode arrayChildrenNode = (ArrayChildrenNode)object;
            return arrayChildrenNode.var.equals(this.var) && arrayChildrenNode.from == this.from && arrayChildrenNode.length == this.length;
        }

        public int hashCode() {
            return this.var.hashCode() + this.from + this.length;
        }

        public String toString() {
            int n = this.maxIndexLog - ArrayFieldVariable.log10(this.from);
            String string = n > 0 ? ArrayFieldVariable.zeros(2 * n) + this.from : Integer.toString(this.from);
            int n2 = this.from + this.length - 1;
            n = this.maxIndexLog - ArrayFieldVariable.log10(n2);
            String string2 = n > 0 ? ArrayFieldVariable.zeros(2 * n) + n2 : Integer.toString(n2);
            return "SubArray" + string + "-" + string2;
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private JPDADebugger debugger;
        private WeakReference<LocalsTreeModel> model;
        private RequestProcessor.Task task;

        public Listener(LocalsTreeModel localsTreeModel, JPDADebugger jPDADebugger) {
            this.debugger = jPDADebugger;
            this.model = new WeakReference<LocalsTreeModel>(localsTreeModel);
            jPDADebugger.addPropertyChangeListener((PropertyChangeListener)this);
        }

        void destroy() {
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            if (this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("LTM cancel old task " + this.task);
                }
                this.task = null;
            }
        }

        private LocalsTreeModel getModel() {
            LocalsTreeModel localsTreeModel = (LocalsTreeModel)this.model.get();
            if (localsTreeModel == null) {
                this.destroy();
            }
            return localsTreeModel;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ((propertyChangeEvent.getPropertyName() == "currentCallStackFrame" || propertyChangeEvent.getPropertyName() == "state") && this.debugger.getState() == 3) {
                final LocalsTreeModel localsTreeModel = this.getModel();
                if (localsTreeModel == null) {
                    return;
                }
                if (this.task != null) {
                    this.task.cancel();
                    if (verbose) {
                        System.out.println("LTM cancel old task " + this.task);
                    }
                    this.task = null;
                }
                this.task = RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (Listener.this.debugger.getState() != 3) {
                            if (verbose) {
                                System.out.println("LTM cancel started task " + Listener.this.task);
                            }
                            return;
                        }
                        if (verbose) {
                            System.out.println("LTM do task " + Listener.this.task);
                        }
                        localsTreeModel.fireTreeChanged();
                    }
                }, 500);
                if (verbose) {
                    System.out.println("LTM  create task " + this.task);
                }
            } else if (propertyChangeEvent.getPropertyName() == "state" && this.debugger.getState() != 3 && this.task != null) {
                this.task.cancel();
                if (verbose) {
                    System.out.println("LTM cancel task " + this.task);
                }
                this.task = null;
            }
        }
    }
}

