/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.AbstractObjectVariable;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;

class ObjectLocalVariable
extends AbstractObjectVariable
implements org.netbeans.api.debugger.jpda.LocalVariable {
    LocalVariable local;
    JPDAThread thread;
    int depth;
    String className;
    String genericSignature;
    private int cloneNumber = 1;

    ObjectLocalVariable(JPDADebuggerImpl jPDADebuggerImpl, ObjectReference objectReference, String string, LocalVariable localVariable, String string2, CallStackFrameImpl callStackFrameImpl) {
        this(jPDADebuggerImpl, objectReference, string, localVariable, string2, localVariable.name() + ((Object)localVariable).hashCode() + (objectReference instanceof ObjectReference ? "^" : ""), callStackFrameImpl);
    }

    private ObjectLocalVariable(JPDADebuggerImpl jPDADebuggerImpl, ObjectReference objectReference, String string, LocalVariable localVariable, String string2, String string3, CallStackFrameImpl callStackFrameImpl) {
        super(jPDADebuggerImpl, objectReference, string2, string3);
        this.local = localVariable;
        if (callStackFrameImpl != null) {
            this.thread = callStackFrameImpl.getThread();
            this.depth = callStackFrameImpl.getFrameDepth();
        }
        this.className = string;
    }

    public String getName() {
        return this.local.name();
    }

    public String getClassName() {
        return this.className;
    }

    protected final void setClassName(String string) {
        this.className = string;
    }

    public String getDeclaredType() {
        return this.local.typeName();
    }

    protected final void setValue(Value value) throws InvalidExpressionException {
        try {
            StackFrame stackFrame = ((CallStackFrameImpl)this.thread.getCallStack(this.depth, this.depth + 1)[0]).getStackFrame();
            stackFrame.setValue(this.local, value);
            this.setInnerValue(value);
        }
        catch (AbsentInformationException absentInformationException) {
            throw new InvalidExpressionException((Throwable)absentInformationException);
        }
        catch (InvalidTypeException invalidTypeException) {
            throw new InvalidExpressionException((Throwable)invalidTypeException);
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            throw new InvalidExpressionException((Throwable)classNotLoadedException);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw new InvalidExpressionException((Throwable)invalidStackFrameException);
        }
    }

    public ObjectLocalVariable clone() {
        ObjectLocalVariable objectLocalVariable = new ObjectLocalVariable(this.getDebugger(), (ObjectReference)this.getJDIValue(), this.className, this.local, this.genericSignature, this.getID() + "_clone" + this.cloneNumber++, null);
        objectLocalVariable.depth = this.depth;
        objectLocalVariable.thread = this.thread;
        return objectLocalVariable;
    }

    final void setFrame(CallStackFrameImpl callStackFrameImpl) {
        this.thread = callStackFrameImpl.getThread();
        this.depth = callStackFrameImpl.getFrameDepth();
    }

    public String toString() {
        return "ObjectLocalVariable " + this.local.name();
    }
}

