/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.ui.tree;

import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.Icon;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.refactoring.php.ui.tree.ElementGrip;
import org.openide.filesystems.FileObject;

public class ElementGripFactory {
    private static ElementGripFactory instance;
    private WeakHashMap<FileObject, Interval> map = new WeakHashMap();

    private ElementGripFactory() {
    }

    public static ElementGripFactory getDefault() {
        if (instance == null) {
            instance = new ElementGripFactory();
        }
        return instance;
    }

    public void cleanUp() {
        this.map.clear();
    }

    public ElementGrip get(FileObject fileObject, int n) {
        Interval interval = this.map.get(fileObject);
        if (interval == null) {
            return null;
        }
        try {
            return interval.get((long)((long)n)).item;
        }
        catch (RuntimeException runtimeException) {
            return interval.item;
        }
    }

    public ElementGrip getParent(ElementGrip elementGrip) {
        Interval interval = this.map.get(elementGrip.getFileObject());
        return interval.getParent(elementGrip);
    }

    public void put(FileObject fileObject, String string, OffsetRange offsetRange, Icon icon) {
        Interval interval = this.map.get(fileObject);
        Interval interval2 = Interval.createInterval(offsetRange, string, icon, interval, null, fileObject);
        if (interval2 != null) {
            this.map.put(fileObject, interval2);
        }
    }

    private static class Interval {
        long from = -1L;
        long to = -1L;
        Set<Interval> subintervals = new HashSet<Interval>();
        ElementGrip item = null;

        private Interval() {
        }

        Interval get(long l) {
            if (this.from <= l && this.to >= l) {
                for (Interval interval : this.subintervals) {
                    Interval interval2 = interval.get(l);
                    if (interval2 == null) continue;
                    return interval2;
                }
                return this;
            }
            return null;
        }

        ElementGrip getParent(ElementGrip elementGrip) {
            for (Interval interval : this.subintervals) {
                if (interval.item.equals(elementGrip)) {
                    return this.item;
                }
                ElementGrip elementGrip2 = interval.getParent(elementGrip);
                if (elementGrip2 == null) continue;
                return elementGrip2;
            }
            return null;
        }

        public static Interval createInterval(OffsetRange offsetRange, String string, Icon icon, Interval interval, Interval interval2, FileObject fileObject) {
            long l = offsetRange.getStart();
            long l2 = offsetRange.getEnd();
            Interval interval3 = null;
            if (interval3 == null) {
                interval3 = new Interval();
            }
            if (interval3.from != l) {
                ElementGrip elementGrip;
                interval3.from = l;
                interval3.to = l2;
                interval3.item = elementGrip = new ElementGrip(string, fileObject, icon);
            }
            if (interval2 != null) {
                interval3.subintervals.add(interval2);
            }
            return interval3;
        }
    }
}

