/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.websvc.rest.codegen.Constants;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.projects.WebProjectRestSupport;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.JavaSourceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestUtils {
    public static void upgrade(Project project) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            restSupport.upgrade();
        }
    }

    public static void ensureRestDevelopmentReady(FileObject fileObject) throws IOException {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            RestUtils.ensureRestDevelopmentReady(project);
        }
    }

    public static void ensureRestDevelopmentReady(Project project) throws IOException {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            restSupport.ensureRestDevelopmentReady();
        }
    }

    public static void removeRestDevelopmentReadiness(Project project) throws IOException {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null && restSupport.isRestSupportOn()) {
            restSupport.removeRestDevelopmentReadiness();
        }
    }

    public static boolean supportsRestDevelopment(Project project) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        return restSupport != null;
    }

    public static boolean isRestEnabled(Project project) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        return restSupport != null && restSupport.isRestSupportOn();
    }

    public static void setRestEnabled(Project project, Boolean bl) {
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        if (restSupport != null) {
            restSupport.setRestSupport(bl);
        }
    }

    public static RestSupport getRestSupport(Project project) {
        return (RestSupport)project.getLookup().lookup(RestSupport.class);
    }

    public static RestServicesModel getRestServicesMetadataModel(Project project) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return restSupport.getRestServicesModel();
        }
        return null;
    }

    public static void disableRestServicesChangeListner(Project project) {
        RestServicesModel restServicesModel = RestUtils.getRestServicesMetadataModel(project);
        if (restServicesModel == null) {
            return;
        }
        restServicesModel.disablePropertyChangeListener();
    }

    public static void enableRestServicesChangeListner(Project project) {
        RestServicesModel restServicesModel = RestUtils.getRestServicesMetadataModel(project);
        if (restServicesModel == null) {
            return;
        }
        restServicesModel.enablePropertyChangeListener();
    }

    public static boolean hasJTASupport(Project project) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return restSupport.hasJTASupport();
        }
        return false;
    }

    public static boolean hasSpringSupport(Project project) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return restSupport.hasSpringSupport();
        }
        return false;
    }

    public static Datasource getDatasource(Project project, String string) {
        RestSupport restSupport = RestUtils.getRestSupport(project);
        if (restSupport != null) {
            return ((WebProjectRestSupport)restSupport).getDatasource(string);
        }
        return null;
    }

    public static String getAttributeValue(Node node, String string, String string2) throws XPathExpressionException {
        String string3 = null;
        int n = 0;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile(string + "/@" + string2);
        Object object = xPathExpression.evaluate(node, XPathConstants.NODESET);
        NodeList nodeList = (NodeList)object;
        if (n < nodeList.getLength()) {
            string3 = nodeList.item(n).getNodeValue();
        }
        return string3;
    }

    public static NodeList getNodeList(Node node, String string) throws XPathExpressionException {
        Object var2_2 = null;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        XPathExpression xPathExpression = xPath.compile(string);
        Object object = xPathExpression.evaluate(node, XPathConstants.NODESET);
        NodeList nodeList = (NodeList)object;
        return nodeList;
    }

    public static FileObject findWadlFile(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        FileObject fileObject2 = fileObject.getFileObject("/build/web/WEB-INF/classes/com/sun/ws/rest/wadl/resource/application.wadl");
        return fileObject2;
    }

    public static DataObject createDataObjectFromTemplate(String string, FileObject fileObject, String string2) throws IOException {
        assert (string != null);
        assert (fileObject != null);
        assert (string2 != null && string2.trim().length() > 0);
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        FileObject fileObject2 = fileSystem.findResource(string);
        DataObject dataObject = DataObject.find((FileObject)fileObject2);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
        return dataObject.createFromTemplate(dataFolder, string2);
    }

    public static String findStubNameFromClass(String string) {
        String string2 = string;
        int n = string2.lastIndexOf("Resource");
        if (n != -1) {
            string2 = string2.substring(0, n);
        } else {
            n = string2.lastIndexOf("Converter");
            if (n != -1) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    public static String findUri(JavaSource javaSource) {
        String string = null;
        List<? extends AnnotationMirror> list = JavaSourceHelper.getClassAnnotations(javaSource);
        for (AnnotationMirror annotationMirror : list) {
            String string2 = annotationMirror.getAnnotationType().toString();
            if (!"javax.ws.rs.Path".equals(string2) && !"Path".equals(string2)) continue;
            string = RestUtils.getValueFromAnnotation(annotationMirror);
        }
        return string;
    }

    public static boolean isStaticResource(JavaSource javaSource) {
        Iterator<? extends AnnotationMirror> iterator;
        List<? extends AnnotationMirror> list = JavaSourceHelper.getClassAnnotations(javaSource);
        if (list != null && list.size() > 0 && (iterator = list.iterator()).hasNext()) {
            AnnotationMirror annotationMirror = iterator.next();
            String string = annotationMirror.getAnnotationType().toString();
            return "javax.ws.rs.Path".equals(string);
        }
        return false;
    }

    public static boolean isConverter(JavaSource javaSource) {
        List<? extends AnnotationMirror> list = JavaSourceHelper.getClassAnnotations(javaSource);
        if (list != null && list.size() > 0) {
            for (AnnotationMirror annotationMirror : list) {
                String string = annotationMirror.getAnnotationType().toString();
                if (!"javax.xml.bind.annotation.XmlRootElement".equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDynamicResource(JavaSource javaSource) {
        List<MethodTree> list = JavaSourceHelper.getAllMethods(javaSource);
        for (MethodTree methodTree : list) {
            List<? extends AnnotationTree> list2 = methodTree.getModifiers().getAnnotations();
            if (list2 == null || list2.size() <= 0) continue;
            for (AnnotationTree annotationTree : list2) {
                String string = annotationTree.getAnnotationType().toString();
                if ("Path".equals(string) || "javax.ws.rs.Path".equals(string)) {
                    return true;
                }
                if (!"GET".equals(string) && !"javax.ws.rs.GET".equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static String findElementName(MethodTree methodTree) {
        String string = "";
        List<? extends AnnotationTree> list = methodTree.getModifiers().getAnnotations();
        if (list != null && list.size() > 0) {
            for (AnnotationTree annotationTree : list) {
                string = annotationTree.toString();
                if (string.indexOf("\"") != -1) {
                    string = RestUtils.getValueFromAnnotation(annotationTree);
                    continue;
                }
                string = RestUtils.getNameFromMethod(methodTree);
            }
        }
        return string.substring(0, 1).toLowerCase() + string.substring(1);
    }

    public static MethodTree findGetAsXmlMethod(JavaSource javaSource) {
        MethodTree methodTree = null;
        List<MethodTree> list = JavaSourceHelper.getAllMethods(javaSource);
        for (MethodTree methodTree2 : list) {
            boolean bl = false;
            boolean bl2 = false;
            List<? extends AnnotationTree> list2 = methodTree2.getModifiers().getAnnotations();
            if (list2 == null || list2.size() <= 0) continue;
            for (AnnotationTree annotationTree : list2) {
                List<String> list3;
                String string = annotationTree.getAnnotationType().toString();
                if ("GET".equals(string) || "javax.ws.rs.GET".equals(string)) {
                    bl = true;
                    continue;
                }
                if (!"Produces".equals(string) && !"javax.ws.rs.Produces".equals(string) || !(list3 = RestUtils.getMimeAnnotationValue(annotationTree)).contains(Constants.MimeType.JSON.value()) && !list3.contains(Constants.MimeType.XML.value())) continue;
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            methodTree = methodTree2;
            break;
        }
        return methodTree;
    }

    public static String getNameFromMethod(MethodTree methodTree) {
        String string = methodTree.getName().toString();
        string = string.substring(string.indexOf("get") + 3);
        string = string.substring(0, 1).toLowerCase() + string.substring(1);
        return string;
    }

    public static String getValueFromAnnotation(AnnotationMirror annotationMirror) {
        return RestUtils.getValueFromAnnotation(annotationMirror.getElementValues().values().toString());
    }

    public static String getValueFromAnnotation(AnnotationTree annotationTree) {
        return RestUtils.getValueFromAnnotation(annotationTree.toString());
    }

    public static String getValueFromAnnotation(ExpressionTree expressionTree) {
        return RestUtils.getValueFromAnnotation(expressionTree.toString());
    }

    public static String getValueFromAnnotation(String string) {
        if (string.indexOf("\"") != -1) {
            string = string.substring(string.indexOf("\"") + 1, string.lastIndexOf("\""));
        }
        return string;
    }

    public static List<String> getMimeAnnotationValue(AnnotationTree annotationTree) {
        List<? extends ExpressionTree> list = annotationTree.getArguments();
        if (list.size() > 0) {
            String string = RestUtils.getValueFromAnnotation(list.get(0));
            string = string.replace("\"", "");
            return Arrays.asList(string.split(","));
        }
        return Collections.emptyList();
    }

    public static String createGetterMethodName(ClientStubModel.RepresentationNode representationNode) {
        String string = "get";
        if (representationNode.getLink() != null) {
            string = RestUtils.escapeJSReserved(representationNode.getLink().getName().toString());
        } else {
            string = representationNode.getName();
            string = "get" + string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public static String escapeJSReserved(String string) {
        if (string.equals("delete")) {
            return string + "_";
        }
        return string;
    }
}

