/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.EntityResourcesGenerator;
import org.netbeans.modules.websvc.rest.codegen.EntityResourcesGeneratorFactory;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.support.PersistenceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.EntityResourcesSetupPanel;
import org.netbeans.modules.websvc.rest.wizard.EntitySelectionPanel;
import org.netbeans.modules.websvc.rest.wizard.ProgressDialog;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.TemplateWizard;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EntityResourcesIterator
implements TemplateWizard.Iterator {
    private int index;
    private transient WizardDescriptor.Panel[] panels;
    private RequestProcessor.Task transformTask;

    public Set instantiate(TemplateWizard templateWizard) throws IOException {
        final Project project = Templates.getProject((WizardDescriptor)templateWizard);
        RestUtils.ensureRestDevelopmentReady(project);
        FileObject fileObject = Templates.getTargetFolder((WizardDescriptor)templateWizard);
        String string = SourceGroupSupport.packageForFolder(fileObject);
        String string2 = (String)templateWizard.getProperty("resourcePackage");
        String string3 = (String)templateWizard.getProperty("converterPackage");
        EntityResourceBeanModel entityResourceBeanModel = (EntityResourceBeanModel)templateWizard.getProperty("EntityResourceModel");
        PersistenceHelper.PersistenceUnit persistenceUnit = (PersistenceHelper.PersistenceUnit)templateWizard.getProperty("PersistenceUnit");
        final EntityResourcesGenerator entityResourcesGenerator = EntityResourcesGeneratorFactory.newInstance(project);
        entityResourcesGenerator.initialize(entityResourceBeanModel, project, fileObject, string, string2, string3, persistenceUnit);
        final ProgressDialog progressDialog = new ProgressDialog(NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_RestSevicicesFromEntitiesProgress"));
        this.transformTask = RequestProcessor.getDefault().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    RestUtils.disableRestServicesChangeListner(project);
                    entityResourcesGenerator.generate(progressDialog.getProgressHandle());
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
                finally {
                    RestUtils.enableRestServicesChangeListner(project);
                    progressDialog.close();
                }
            }
        });
        this.transformTask.schedule(50);
        progressDialog.open();
        return Collections.singleton(DataFolder.findFolder((FileObject)fileObject));
    }

    public void initialize(TemplateWizard templateWizard) {
        this.index = 0;
        EntitySelectionPanel entitySelectionPanel = new EntitySelectionPanel(NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_EntityClasses"), (WizardDescriptor)templateWizard);
        EntityResourcesSetupPanel entityResourcesSetupPanel = new EntityResourcesSetupPanel(NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_RestResourcesAndClasses"), (WizardDescriptor)templateWizard);
        this.panels = new WizardDescriptor.Panel[]{entitySelectionPanel, entityResourcesSetupPanel};
        String[] stringArray = new String[]{NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_EntityClasses"), NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_RestResourcesAndClasses")};
        templateWizard.putProperty("NewFileWizard_Title", (Object)NbBundle.getMessage(EntityResourcesIterator.class, (String)"Templates/WebServices/RestServicesFromEntities"));
        Util.mergeSteps((WizardDescriptor)templateWizard, this.panels, stringArray);
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public String name() {
        return NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_WizardTitle_FromEntity");
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }
}

