/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Dialog;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.wizard.I18nWizardDescriptor;
import org.netbeans.modules.i18n.wizard.ResourceWizardPanel;
import org.netbeans.modules.i18n.wizard.SourceWizardPanel;
import org.netbeans.modules.i18n.wizard.TestStringWizardPanel;
import org.netbeans.modules.i18n.wizard.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class I18nTestWizardAction
extends NodeAction {
    static final long serialVersionUID = -3265587506739081248L;
    private static WeakReference dialogWRef = new WeakReference<Object>(null);

    public I18nTestWizardAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean enable(Node[] nodeArray) {
        if (!Util.wizardEnabled(nodeArray)) {
            return false;
        }
        Dialog dialog = (Dialog)dialogWRef.get();
        if (dialog == null) {
            return true;
        }
        return !dialog.isVisible();
    }

    protected void performAction(Node[] nodeArray) {
        Project project;
        Dialog dialog = (Dialog)dialogWRef.get();
        if (dialog != null) {
            dialog.setVisible(false);
            dialog.dispose();
        }
        if ((project = org.netbeans.modules.i18n.Util.getProjectFor(nodeArray)) == null) {
            return;
        }
        WizardDescriptor wizardDescriptor = I18nWizardDescriptor.createI18nWizardDescriptor((WizardDescriptor.Iterator<I18nWizardDescriptor.Settings>)this.getWizardIterator(), new I18nWizardDescriptor.Settings(Util.createWizardSourceMap(nodeArray), project));
        this.initWizard(wizardDescriptor);
        dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialogWRef = new WeakReference<Dialog>(dialog);
        dialog.setVisible(true);
    }

    private WizardDescriptor.Iterator getWizardIterator() {
        WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[]{new SourceWizardPanel.Panel(true), new ResourceWizardPanel.Panel(true), new TestStringWizardPanel.Panel()};
        return new WizardDescriptor.ArrayIterator(panelArray);
    }

    private void initWizard(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("WizardPanel_autoWizardStyle", (Object)Boolean.TRUE);
        wizardDescriptor.putProperty("WizardPanel_contentDisplayed", (Object)Boolean.TRUE);
        wizardDescriptor.putProperty("WizardPanel_contentNumbered", (Object)Boolean.TRUE);
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(Util.getString("TXT_SelectTestSources"));
        arrayList.add(Util.getString("TXT_SelectTestResources"));
        arrayList.add(Util.getString("TXT_FoundMissingResources"));
        wizardDescriptor.putProperty("WizardPanel_contentData", (Object)arrayList.toArray(new String[arrayList.size()]));
        wizardDescriptor.setTitle(Util.getString("LBL_TestWizardTitle"));
        wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
        wizardDescriptor.setModal(false);
    }

    public String getName() {
        return Util.getString("LBL_TestWizardActionName");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("internation.testing");
    }

    protected boolean asynchronous() {
        return false;
    }
}

