/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Util
extends org.netbeans.modules.i18n.Util {
    Util() {
    }

    public static String getString(String string) {
        return NbBundle.getMessage(Util.class, (String)string);
    }

    public static char getChar(String string) {
        return Util.getString(string).charAt(0);
    }

    public static Map<DataObject, SourceData> createWizardSourceMap() {
        return new TreeMap<DataObject, SourceData>(new DataObjectComparator());
    }

    public static Map<DataObject, SourceData> createWizardSourceMap(Node[] nodeArray) {
        Map<DataObject, SourceData> map = Util.createWizardSourceMap();
        if (nodeArray != null && nodeArray.length > 0) {
            VisibilityQuery visibilityQuery = VisibilityQuery.getDefault();
            for (Node node : nodeArray) {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject != null && !visibilityQuery.isVisible(dataObject.getPrimaryFile())) continue;
                DataObject.Container container = (DataObject.Container)node.getCookie(DataObject.Container.class);
                if (container != null) {
                    for (DataObject dataObject2 : I18nUtil.getAcceptedDataObjects(container)) {
                        Util.addSource(map, dataObject2);
                    }
                }
                if (dataObject == null || !FactoryRegistry.hasFactory(dataObject.getClass())) continue;
                Util.addSource(map, dataObject);
            }
        }
        return map;
    }

    public static void addSource(Map<DataObject, SourceData> map, DataObject dataObject) {
        if (map.containsKey(dataObject)) {
            return;
        }
        DataFolder dataFolder = dataObject.getFolder();
        if (dataFolder == null) {
            map.put(dataObject, null);
            return;
        }
        for (DataObject dataObject2 : dataFolder.getChildren()) {
            if (!(dataObject2 instanceof PropertiesDataObject)) continue;
            map.put(dataObject, new SourceData(dataObject2));
            return;
        }
        map.put(dataObject, null);
    }

    static boolean wizardEnabled(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return false;
        }
        for (Node node : nodeArray) {
            FileObject fileObject;
            DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
            if (dataObject != null) {
                boolean bl;
                fileObject = dataObject.getPrimaryFile();
                try {
                    bl = !fileObject.isVirtual() && fileObject.isValid() && fileObject.getURL().getProtocol().equals("file");
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    bl = false;
                }
                if (!bl) {
                    return false;
                }
            }
            if ((fileObject = node.getCookie(DataObject.Container.class)) != null) continue;
            if (dataObject == null) {
                return false;
            }
            if (FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile()) != null) continue;
            return false;
        }
        return true;
    }

    static void layoutSelectResourcePanel(Container container, String string, String string2, Component component, JButton jButton, JButton jButton2) {
        JTextArea jTextArea = new JTextArea();
        JLabel jLabel = new JLabel();
        jTextArea.setColumns(20);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setText(string);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setDisabledTextColor(new JLabel().getForeground());
        jTextArea.setEnabled(false);
        jTextArea.setOpaque(false);
        jLabel.setLabelFor(component);
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)string2);
        JScrollPane jScrollPane = new JScrollPane(component);
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout((Container)jPanel);
        jPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jScrollPane, 0, -1, Integer.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jButton).add((Component)jButton2))));
        groupLayout.linkSize(new Component[]{jButton, jButton2}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)jScrollPane, 0, -1, Integer.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)jButton).addPreferredGap(0).add((Component)jButton2)))));
        LayoutStyle layoutStyle = groupLayout.getLayoutStyle();
        if (layoutStyle == null) {
            layoutStyle = LayoutStyle.getSharedInstance();
        }
        BorderLayout borderLayout = new BorderLayout();
        container.setLayout(borderLayout);
        container.add((Component)jTextArea, "First");
        container.add((Component)jPanel, "Center");
        borderLayout.setVgap(layoutStyle.getPreferredGap((JComponent)jTextArea, (JComponent)jLabel, 1, 1, container));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DataObjectComparator
    implements Comparator<DataObject> {
        private DataObjectComparator() {
        }

        @Override
        public int compare(DataObject dataObject, DataObject dataObject2) {
            if (dataObject == dataObject2) {
                return 0;
            }
            if (dataObject == null) {
                return -1;
            }
            if (dataObject2 == null) {
                return 1;
            }
            return dataObject.getPrimaryFile().getPath().compareTo(dataObject2.getPrimaryFile().getPath());
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }
    }
}

