/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.ws.wadl.util;

import com.sun.research.ws.wadl2java.ast.PathSegment;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URIUtil {
    public static String buildURI(List<String> pathSegments, List<List<String>> matrixParams, Map<String, Object> paramValues) {
        ArrayList<String> merged = new ArrayList<String>();
        for (int i = 0; i < pathSegments.size(); ++i) {
            List<String> associatedMatrixParams = matrixParams == null ? null : matrixParams.get(i);
            PathSegment segment = new PathSegment(pathSegments.get(i), associatedMatrixParams);
            merged.add(segment.evaluate(paramValues));
        }
        return URIUtil.concatenate(merged);
    }

    public static String concatenate(List<String> components) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < components.size(); ++i) {
            if (i > 0 && buf.charAt(buf.length() - 1) != '/' && components.get(i).charAt(0) != '/') {
                buf.append('/');
            }
            buf.append(components.get(i));
        }
        return buf.toString();
    }

    public static String buildQueryString(Map<String, Object> queryParams) {
        StringBuffer buf = new StringBuffer();
        boolean firstParam = true;
        try {
            for (Map.Entry<String, Object> entry : queryParams.entrySet()) {
                if (entry.getValue() == null) continue;
                if (entry.getValue() instanceof List) {
                    List values = (List)entry.getValue();
                    for (Object value : values) {
                        if (!firstParam) {
                            buf.append('&');
                        }
                        buf.append(entry.getKey());
                        buf.append('=');
                        buf.append(URLEncoder.encode(value.toString(), "utf-8"));
                        firstParam = false;
                    }
                    continue;
                }
                if (!firstParam) {
                    buf.append('&');
                }
                buf.append(entry.getKey());
                buf.append('=');
                buf.append(URLEncoder.encode(entry.getValue().toString(), "utf-8"));
                firstParam = false;
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
        }
        return buf.toString();
    }
}

