/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.core.ServerType;
import org.netbeans.modules.websvc.core.WSStackUtils;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWsStackProvider;
import org.openide.filesystems.FileObject;

public class ProjectInfo {
    private Project project;
    private int projectType;
    public static final int JSE_PROJECT_TYPE = 0;
    public static final int WEB_PROJECT_TYPE = 1;
    public static final int EJB_PROJECT_TYPE = 2;
    public static final int CAR_PROJECT_TYPE = 3;
    private boolean jsr109Supported = false;
    private boolean wsgenSupported = false;
    private boolean wsimportSupported = false;
    private ServerType serverType;

    public ProjectInfo(Project project) {
        Car car;
        EjbJar ejbJar;
        String string;
        this.project = project;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (string = j2eeModuleProvider.getServerInstanceID()) != null) {
            try {
                ejbJar = Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
                car = JaxWsStackProvider.getJaxWsStack((J2eePlatform)ejbJar);
                if (car != null) {
                    this.jsr109Supported = car.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109);
                    this.wsgenSupported = true;
                    this.wsimportSupported = true;
                    this.serverType = WSStackUtils.getServerType(project);
                }
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Logger.getLogger(this.getClass().getName()).log(Level.FINE, "Failed to find J2eePlatform", instanceRemovedException);
            }
        }
        string = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        ejbJar = EjbJar.getEjbJar((FileObject)project.getProjectDirectory());
        car = Car.getCar((FileObject)project.getProjectDirectory());
        this.projectType = ejbJar != null ? 2 : (string != null ? 1 : (car != null ? 3 : 0));
    }

    public int getProjectType() {
        return this.projectType;
    }

    public Project getProject() {
        return this.project;
    }

    public boolean isJsr109Supported() {
        return this.jsr109Supported;
    }

    public boolean isWsgenSupported() {
        return this.wsgenSupported;
    }

    public boolean isWsimportSupported() {
        return this.wsimportSupported;
    }

    public ServerType getServerType() {
        return this.serverType;
    }
}

