/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.core.ServerType;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWsStackProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSStackUtils {
    Project project;
    J2eePlatform j2eePlatform;

    public WSStackUtils(Project project) {
        this.project = project;
        this.j2eePlatform = this.getJ2eePlatform(project);
    }

    private J2eePlatform getJ2eePlatform(Project project) {
        String string;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (string = j2eeModuleProvider.getServerInstanceID()) != null && string.length() > 0) {
            try {
                return Deployment.getDefault().getServerInstance(string).getJ2eePlatform();
            }
            catch (InstanceRemovedException instanceRemovedException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Failed to find J2eePlatform", instanceRemovedException);
            }
        }
        return null;
    }

    public boolean isWsitSupported() {
        if (this.j2eePlatform != null) {
            WSStack wSStack = JaxWsStackProvider.getJaxWsStack((J2eePlatform)this.j2eePlatform);
            return wSStack != null && wSStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.WSIT);
        }
        return false;
    }

    public boolean isJsr109Supported() {
        if (this.j2eePlatform != null) {
            WSStack wSStack = JaxWsStackProvider.getJaxWsStack((J2eePlatform)this.j2eePlatform);
            return wSStack != null && wSStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109);
        }
        return false;
    }

    public boolean isJsr109OldSupported() {
        return this.j2eePlatform != null && WSStackUtils.getServerType(this.project) == ServerType.GLASSFISH;
    }

    public boolean hasJAXWSLibrary() {
        SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        ClassPath classPath = ClassPath.getClassPath((FileObject)sourceGroupArray[0].getRootFolder(), (String)"classpath/compile");
        FileObject fileObject = classPath.findResource("com/sun/tools/ws/ant/WsImport.class");
        return fileObject != null;
    }

    public static ServerType getServerType(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null || j2eeModuleProvider.getServerInstanceID() == null) {
            return ServerType.NOT_SPECIFIED;
        }
        String string = j2eeModuleProvider.getServerID();
        if (string.startsWith("Tomcat")) {
            return ServerType.TOMCAT;
        }
        if (string.equals("J2EE")) {
            return ServerType.GLASSFISH;
        }
        if (string.equals("gfv3")) {
            return ServerType.GLASSFISH_V3;
        }
        if (string.equals("GlassFish")) {
            return ServerType.GLASSFISH;
        }
        if (string.equals("APPSERVER")) {
            return ServerType.GLASSFISH;
        }
        if (string.equals("JavaEE")) {
            return ServerType.GLASSFISH;
        }
        if (string.startsWith("JBoss")) {
            return ServerType.JBOSS;
        }
        if (string.startsWith("WebLogic")) {
            return ServerType.WEBLOGIC;
        }
        if (string.startsWith("WebSphere")) {
            return ServerType.WEBSPHERE;
        }
        return ServerType.UNKNOWN;
    }

    public ServerType getServerType() {
        return WSStackUtils.getServerType(this.project);
    }

    public <T> WSStack<T> getWsStack(Class<T> clazz) {
        if (this.j2eePlatform != null) {
            return WSStack.findWSStack((Lookup)this.j2eePlatform.getLookup(), clazz);
        }
        return null;
    }
}

