/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.websvc.core.ServiceNodesProvider;
import org.netbeans.modules.websvc.core.WsWsdlCookie;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JaxWsExplorerPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private DialogDescriptor descriptor;
    private ExplorerManager manager = new ExplorerManager();
    private BeanTreeView treeView;
    private Node selectedServiceNode = null;
    private JLabel jLblTreeView;

    public JaxWsExplorerPanel() {
        this.initComponents();
        this.initUserComponents();
    }

    private void initComponents() {
        this.jLblTreeView = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.jLblTreeView, (String)NbBundle.getMessage(JaxWsExplorerPanel.class, (String)"LBL_AvailableWebServices"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        this.add((Component)this.jLblTreeView, gridBagConstraints);
    }

    private void initUserComponents() {
        this.treeView = new BeanTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setPopupAllowed(false);
        this.treeView.setBorder((Border)new EtchedBorder());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(11, 11, 0, 11);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.treeView, gridBagConstraints);
        this.jLblTreeView.setLabelFor(this.treeView.getViewport().getView());
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JaxWsExplorerPanel.class, (String)"ACSD_WebServicesTreeView"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JaxWsExplorerPanel.class, (String)"ACSD_WebServicesTreeView"));
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void addNotify() {
        super.addNotify();
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        Children.Array array = new Children.Array();
        AbstractNode abstractNode = new AbstractNode((Children)array);
        ArrayList<ProjectNode> arrayList = new ArrayList<ProjectNode>();
        for (int i = 0; i < projectArray.length; ++i) {
            int n;
            Node[] nodeArray;
            Node[] nodeArray22;
            LogicalViewProvider logicalViewProvider = (LogicalViewProvider)projectArray[i].getLookup().lookup(LogicalViewProvider.class);
            if (logicalViewProvider == null) continue;
            Node node = logicalViewProvider.createLogicalView();
            Collection collection = Lookup.getDefault().lookupAll(ServiceNodesProvider.class);
            for (Node[] nodeArray22 : collection) {
                if (nodeArray22 == null || (nodeArray = nodeArray22.getServiceNodes(projectArray[i])) == null) continue;
                Children.Array array2 = new Children.Array();
                for (n = 0; n < nodeArray.length; ++n) {
                    nodeArray[n] = new ServiceNode(nodeArray[n]);
                }
                array2.add(nodeArray);
                arrayList.add(new ProjectNode((Children)array2, node));
            }
            Children children = node.getChildren();
            if (children.getNodesCount() <= 0) continue;
            nodeArray = nodeArray22 = children.getNodes();
            int n2 = nodeArray.length;
            for (n = 0; n < n2; ++n) {
                Node node2 = nodeArray[n];
                if (node2.getValue("is_web_service_root") == null) continue;
                Children.Array array3 = new Children.Array();
                Children children2 = node2.getChildren();
                if (children2.getNodesCount() <= 0) continue;
                Node[] nodeArray3 = children2.getNodes();
                Node[] nodeArray4 = new Node[nodeArray3.length];
                for (int j = 0; j < nodeArray3.length; ++j) {
                    nodeArray4[j] = new ServiceNode(nodeArray3[j]);
                }
                array3.add(nodeArray4);
                arrayList.add(new ProjectNode((Children)array3, node));
            }
        }
        Node[] nodeArray = new Node[arrayList.size()];
        arrayList.toArray(nodeArray);
        array.add(nodeArray);
        this.manager.setRootContext((Node)abstractNode);
        this.descriptor.setValid(false);
    }

    public void removeNotify() {
        this.manager.removePropertyChangeListener((PropertyChangeListener)this);
        super.removeNotify();
    }

    public void setDescriptor(DialogDescriptor dialogDescriptor) {
        this.descriptor = dialogDescriptor;
    }

    public Node getSelectedService() {
        return this.selectedServiceNode;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Node[] nodeArray;
        if (propertyChangeEvent.getSource() == this.manager && "selectedNodes".equals(propertyChangeEvent.getPropertyName()) && (nodeArray = this.manager.getSelectedNodes()) != null && nodeArray.length > 0) {
            Node node = nodeArray[0];
            if (node.getCookie(WsWsdlCookie.class) != null) {
                this.selectedServiceNode = node;
                this.descriptor.setValid(true);
            } else {
                this.selectedServiceNode = null;
                this.descriptor.setValid(false);
            }
        }
    }

    private class ServiceNode
    extends AbstractNode
    implements WsWsdlCookie {
        private Node serviceNode;

        ServiceNode(Node node) {
            super(Children.LEAF);
            this.serviceNode = node;
            this.setName(node.getDisplayName());
            this.getCookieSet().add((Node.Cookie)this);
        }

        public Image getIcon(int n) {
            return this.serviceNode.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.serviceNode.getOpenedIcon(n);
        }

        public String getWsdlURL() {
            WsWsdlCookie wsWsdlCookie = (WsWsdlCookie)this.serviceNode.getLookup().lookup(WsWsdlCookie.class);
            if (wsWsdlCookie != null) {
                return wsWsdlCookie.getWsdlURL();
            }
            String string = (String)this.serviceNode.getValue("wsdl-url");
            if (string != null) {
                return string;
            }
            return null;
        }
    }

    private class ProjectNode
    extends AbstractNode {
        private Node rootNode;

        ProjectNode(Children children, Node node) {
            super(children);
            this.rootNode = node;
            this.setName(node.getDisplayName());
        }

        public Image getIcon(int n) {
            return this.rootNode.getIcon(n);
        }

        public Image getOpenedIcon(int n) {
            return this.rootNode.getOpenedIcon(n);
        }
    }
}

