/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.awt.Dialog;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Binding;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelListener;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.core.ConfigureHandlerAction;
import org.netbeans.modules.websvc.core.ConfigureHandlerCookie;
import org.netbeans.modules.websvc.core.jaxws.actions.JaxWsRefreshClientAction;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandler;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandlerChains;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsHandlerClass;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsModel;
import org.netbeans.modules.websvc.core.jaxws.bindings.model.BindingsModelFactory;
import org.netbeans.modules.websvc.core.jaxws.nodes.ClientHandlerButtonListener;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsClientChildren;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.core.jaxws.nodes.RefreshClientDialog;
import org.netbeans.modules.websvc.core.webservices.ui.panels.MessageHandlerPanel;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesCookieImpl;
import org.netbeans.modules.websvc.core.wseditor.support.WSEditAttributesAction;
import org.netbeans.modules.websvc.jaxws.api.JaxWsRefreshCookie;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxWsClientNode
extends AbstractNode
implements OpenCookie,
JaxWsRefreshCookie,
ConfigureHandlerCookie {
    Client client;
    FileObject srcRoot;
    JaxWsModel jaxWsModel;
    InstanceContent content;
    private FileObject wsdlFileObject;
    boolean modelGenerationFinished;
    private static final String WAITING_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/waiting.png";
    private static final String ERROR_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/error-badge.gif";
    private static final String SERVICE_BADGE = "org/netbeans/modules/websvc/core/webservices/ui/resources/XMLServiceDataIcon.png";
    private Image cachedWaitingBadge;
    private Image cachedErrorBadge;
    private Image cachedServiceBadge;

    public JaxWsClientNode(JaxWsModel jaxWsModel, Client client, FileObject fileObject) {
        this(jaxWsModel, client, fileObject, new InstanceContent());
    }

    private JaxWsClientNode(JaxWsModel jaxWsModel, Client client, FileObject fileObject, InstanceContent instanceContent) {
        super((Children)new JaxWsClientChildren(client, fileObject), (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.jaxWsModel = jaxWsModel;
        this.client = client;
        this.srcRoot = fileObject;
        this.content = instanceContent;
        this.setName(client.getName());
        this.setDisplayName(client.getName());
        instanceContent.add((Object)this);
        instanceContent.add((Object)client);
        instanceContent.add((Object)fileObject);
        WsdlModeler wsdlModeler = this.getWsdlModeler();
        if (wsdlModeler != null) {
            this.changeIcon();
            wsdlModeler.generateWsdlModel(new WsdlModelListener(){

                public void modelCreated(WsdlModel wsdlModel) {
                    JaxWsClientNode.this.modelGenerationFinished = true;
                    JaxWsClientNode.this.changeIcon();
                }
            });
        }
        instanceContent.add((Object)new EditWSAttributesCookieImpl((Node)this, jaxWsModel));
        this.setValue("wsdl-url", client.getWsdlUrl());
    }

    public WsdlModel getWsdlModel() {
        return this.getWsdlModeler().getAndWaitForWsdlModel();
    }

    public String getShortDescription() {
        return this.client.getWsdlUrl();
    }

    public Image getIcon(int n) {
        if (((JaxWsClientChildren)this.getChildren()).getWsdlModel() != null) {
            return this.getServiceImage();
        }
        WsdlModeler wsdlModeler = this.getWsdlModeler();
        if (wsdlModeler != null && wsdlModeler.getCreationException() == null) {
            if (this.modelGenerationFinished) {
                return this.getServiceImage();
            }
            return ImageUtilities.mergeImages((Image)this.getServiceImage(), (Image)this.getWaitingBadge(), (int)15, (int)8);
        }
        Image image = ImageUtilities.mergeImages((Image)this.getServiceImage(), (Image)this.getErrorBadge(), (int)6, (int)6);
        if (this.modelGenerationFinished) {
            return image;
        }
        return ImageUtilities.mergeImages((Image)image, (Image)this.getWaitingBadge(), (int)15, (int)8);
    }

    private Image getServiceImage() {
        if (this.cachedServiceBadge == null) {
            this.cachedServiceBadge = ImageUtilities.loadImage((String)SERVICE_BADGE);
        }
        return this.cachedServiceBadge;
    }

    private Image getErrorBadge() {
        if (this.cachedErrorBadge == null) {
            this.cachedErrorBadge = ImageUtilities.loadImage((String)ERROR_BADGE);
        }
        return this.cachedErrorBadge;
    }

    private Image getWaitingBadge() {
        if (this.cachedWaitingBadge == null) {
            this.cachedWaitingBadge = ImageUtilities.loadImage((String)WAITING_BADGE);
        }
        return this.cachedWaitingBadge;
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public void open() {
        EditCookie editCookie = this.getEditCookie();
        if (editCookie != null) {
            editCookie.edit();
        }
    }

    void changeIcon() {
        this.fireIconChange();
    }

    private EditCookie getEditCookie() {
        try {
            FileObject fileObject = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot).getLocalWsdlFolderForClient(this.client.getName(), false).getFileObject(this.client.getLocalWsdlFile());
            assert (fileObject != null) : "Cannot find local WSDL file";
            if (fileObject != null) {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                return (EditCookie)dataObject.getCookie(EditCookie.class);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().log(iOException.getLocalizedMessage());
            return null;
        }
        return null;
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean bl) {
        ArrayList<CallableSystemAction> arrayList = new ArrayList<CallableSystemAction>(Arrays.asList((CallableSystemAction)SystemAction.get(OpenAction.class), (CallableSystemAction)SystemAction.get(JaxWsRefreshClientAction.class), null, (CallableSystemAction)SystemAction.get(WSEditAttributesAction.class), null, (CallableSystemAction)SystemAction.get(ConfigureHandlerAction.class), null, (CallableSystemAction)SystemAction.get(DeleteAction.class), null, (CallableSystemAction)SystemAction.get(PropertiesAction.class)));
        this.addFromLayers(arrayList, "WebServices/Clients/Actions");
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private void addFromLayers(ArrayList<Action> arrayList, String string) {
        Lookup lookup = Lookups.forPath((String)string);
        for (Object e : lookup.lookupAll(Object.class)) {
            if (e instanceof Action) {
                arrayList.add((Action)e);
                continue;
            }
            if (!(e instanceof JSeparator)) continue;
            arrayList.add(null);
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean canDestroy() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws IOException {
        FileObject fileObject;
        FileLock fileLock;
        FileObject fileObject2;
        String string = this.client.getName();
        JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
        FileObject fileObject3 = jAXWSClientSupport.getLocalWsdlFolderForClient(string, false);
        if (fileObject3 != null) {
            fileObject2 = fileObject3.getParent();
            fileLock = null;
            try {
                fileLock = fileObject2.lock();
                fileObject2.delete(fileLock);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
        if ((fileObject2 = FileOwnerQuery.getOwner((FileObject)this.srcRoot)).getLookup().lookup(J2eeModuleProvider.class) != null && (fileLock = this.findWsdlFolderForClient(jAXWSClientSupport, string)) != null) {
            fileObject = fileLock.getParent();
            FileLock fileLock2 = null;
            try {
                fileLock2 = fileLock.lock();
                fileLock.delete(fileLock2);
            }
            finally {
                if (fileLock2 != null) {
                    fileLock2.releaseLock();
                }
            }
            if (fileObject.getChildren().length == 0) {
                try {
                    fileLock2 = fileObject.lock();
                    fileObject.delete(fileLock2);
                }
                finally {
                    if (fileLock2 != null) {
                        fileLock2.releaseLock();
                    }
                }
            }
        }
        fileLock = fileObject2.getProjectDirectory().getFileObject("build.xml");
        try {
            fileObject = ActionUtils.runTarget((FileObject)fileLock, (String[])new String[]{"wsimport-client-clean-" + string}, null);
            fileObject.waitFinished();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().log(iOException.getLocalizedMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().log(illegalArgumentException.getLocalizedMessage());
        }
        jAXWSClientSupport.removeServiceClient(string);
        super.destroy();
    }

    public void refreshService(boolean bl) {
        if (bl) {
            String string = RefreshClientDialog.open(this.client.getWsdlUrl());
            if ("close".equals(string)) {
                return;
            }
            if ("no_download".equals(string)) {
                ((JaxWsClientChildren)this.getChildren()).refreshKeys(false);
            } else {
                this.wsdlFileObject = null;
                ((JaxWsClientChildren)this.getChildren()).refreshKeys(true, string);
            }
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(JaxWsClientNode.class, (String)"HINT_RefreshClient")));
            ((JaxWsClientChildren)this.getChildren()).refreshKeys(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWsdlFolderContents() {
        FileObject fileObject = this.getJAXWSClientSupport().getLocalWsdlFolderForClient(this.getName(), false);
        if (fileObject != null) {
            FileLock fileLock = null;
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                try {
                    FileObject fileObject2 = fileObjectArray[i];
                    fileLock = fileObject2.lock();
                    fileObject2.delete(fileLock);
                    continue;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    continue;
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                        fileLock = null;
                    }
                }
            }
        }
    }

    @Override
    public void configureHandler() {
        Object object;
        BindingsHandlerChains bindingsHandlerChains;
        Object object2;
        Object object3;
        Project project = FileOwnerQuery.getOwner((FileObject)this.srcRoot);
        ArrayList<String> arrayList = new ArrayList<String>();
        BindingsModel bindingsModel = this.getBindingsModel();
        if (bindingsModel != null && (object3 = bindingsModel.getGlobalBindings()) != null && (object2 = object3.getDefinitionsBindings()) != null) {
            bindingsHandlerChains = object2.getHandlerChains();
            object = bindingsHandlerChains.getHandlerChains().iterator().next();
            Collection<BindingsHandler> collection = object.getHandlers();
            for (BindingsHandler bindingsHandler : collection) {
                BindingsHandlerClass bindingsHandlerClass = bindingsHandler.getHandlerClass();
                arrayList.add(bindingsHandlerClass.getClassName());
            }
        }
        object3 = new MessageHandlerPanel(project, arrayList, true, this.client.getName());
        object2 = NbBundle.getMessage(JaxWsNode.class, (String)"TTL_MessageHandlerPanel");
        bindingsHandlerChains = new DialogDescriptor(object3, (String)object2);
        bindingsHandlerChains.setButtonListener(new ClientHandlerButtonListener((MessageHandlerPanel)object3, bindingsModel, this.client, (Node)this, this.jaxWsModel));
        object = DialogDisplayer.getDefault().createDialog((DialogDescriptor)bindingsHandlerChains);
        ((Dialog)object).getAccessibleContext().setAccessibleDescription(((Dialog)object).getTitle());
        ((Dialog)object).setVisible(true);
    }

    private BindingsModel getBindingsModel() {
        String string = this.client.getHandlerBindingFile();
        BindingsModel bindingsModel = null;
        try {
            FileObject fileObject;
            JAXWSClientSupport jAXWSClientSupport;
            FileObject fileObject2;
            if (string != null && (fileObject2 = (jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot)).getBindingsFolderForClient(this.getName(), false)) != null && (fileObject = fileObject2.getFileObject(string)) != null) {
                ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)true);
                bindingsModel = BindingsModelFactory.getDefault().getModel(modelSource);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return null;
        }
        return bindingsModel;
    }

    WsdlModeler getWsdlModeler() {
        if (this.getLocalWsdl() != null) {
            try {
                WsdlModeler wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(this.wsdlFileObject.getURL());
                if (wsdlModeler != null) {
                    String string = this.client.getPackageName();
                    if (string != null && this.client.isPackageNameForceReplace()) {
                        wsdlModeler.setPackageName(string);
                    } else {
                        wsdlModeler.setPackageName(null);
                    }
                    wsdlModeler.setCatalog(this.getJAXWSClientSupport().getCatalog());
                    this.setBindings(wsdlModeler);
                    return wsdlModeler;
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().log(fileStateInvalidException.getLocalizedMessage());
            }
        } else {
            ErrorManager.getDefault().log(65536, NbBundle.getMessage(JaxWsNode.class, (String)"ERR_missingLocalWsdl"));
        }
        return null;
    }

    FileObject getLocalWsdl() {
        String string;
        FileObject fileObject;
        if (this.wsdlFileObject == null && (fileObject = this.getJAXWSClientSupport().getLocalWsdlFolderForClient(this.client.getName(), false)) != null && (string = this.client.getLocalWsdlFile()) != null) {
            this.wsdlFileObject = fileObject.getFileObject(string);
        }
        return this.wsdlFileObject;
    }

    private JAXWSClientSupport getJAXWSClientSupport() {
        return JAXWSClientSupport.getJaxWsClientSupport((FileObject)this.srcRoot);
    }

    private void setBindings(WsdlModeler wsdlModeler) {
        Binding[] bindingArray = this.client.getBindings();
        if (bindingArray == null || bindingArray.length == 0) {
            wsdlModeler.setJAXBBindings(null);
            return;
        }
        String[] stringArray = new String[bindingArray.length];
        for (int i = 0; i < bindingArray.length; ++i) {
            stringArray[i] = bindingArray[i].getFileName();
        }
        FileObject fileObject = this.getJAXWSClientSupport().getBindingsFolderForClient(this.getName(), true);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < stringArray.length; ++i) {
            FileObject fileObject2 = fileObject.getFileObject(stringArray[i]);
            if (fileObject2 == null) continue;
            try {
                arrayList.add(fileObject2.getURL());
                continue;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        URL[] uRLArray = new URL[arrayList.size()];
        arrayList.toArray(uRLArray);
        wsdlModeler.setJAXBBindings(uRLArray);
    }

    void setModelGenerationFinished(boolean bl) {
        this.modelGenerationFinished = bl;
    }

    JaxWsModel getJaxWsModel() {
        return this.jaxWsModel;
    }

    private FileObject findWsdlFolderForClient(JAXWSClientSupport jAXWSClientSupport, String string) throws IOException {
        FileObject fileObject = jAXWSClientSupport.getWsdlFolder(false);
        if (fileObject != null) {
            return fileObject.getFileObject("client/" + string);
        }
        return null;
    }
}

