/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.saas;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Modifier;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModeler;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModelerFactory;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.java.GenerationUtils;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.jaxws.saas.RestWrapperForSoapGenerator;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.ui.ProgressDialog;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RestResourceGenerator {
    public static final String RESOURCE_TEMPLATE = "Templates/WebServices/GenericResource.java";
    private FileObject folder;
    private URI wsdlURL;
    private WsdlModel wsdlModel;
    private ProgressHandle pHandle;
    private int totalWorkUnits;
    private int workUnits;
    private RequestProcessor.Task generatorTask;
    private String packageName;
    private ProgressDialog dialog;

    public RestResourceGenerator(FileObject fileObject, URI uRI, String string) {
        this.folder = fileObject;
        this.wsdlURL = uRI;
        this.packageName = string;
    }

    public void generate() {
        String string = NbBundle.getMessage(RestResourceGenerator.class, (String)"MSG_GENERATING_REST_RESOURCE");
        this.dialog = new ProgressDialog(string);
        this.generatorTask = RequestProcessor.getDefault().create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    String string;
                    RestResourceGenerator.this.initProgressReporting(RestResourceGenerator.this.dialog.getProgressHandle());
                    Project project = FileOwnerQuery.getOwner((FileObject)RestResourceGenerator.this.folder);
                    String string2 = RestResourceGenerator.this.getPackageName(RestResourceGenerator.this.packageName + "_client");
                    JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
                    String string3 = RestResourceGenerator.this.getWsdlName(RestResourceGenerator.this.wsdlURL.toString());
                    Client client = RestResourceGenerator.this.clientExists(jaxWsModel, string3);
                    if (client == null) {
                        string = NbBundle.getMessage(RestResourceGenerator.class, (String)"MSG_GENERATING_CLIENT_ARTIFACTS");
                        RestResourceGenerator.this.reportProgress(string);
                        string3 = RestResourceGenerator.this.generateClient(project, RestResourceGenerator.this.wsdlURL.toString(), string2);
                    } else {
                        string2 = client.getPackageName();
                    }
                    string = jaxWsModel.findClientByName(string3);
                    if (string == null) {
                        RestResourceGenerator.this.finishProgressReporting();
                        RestResourceGenerator.this.dialog.close();
                        return;
                    }
                    JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)RestResourceGenerator.this.folder);
                    FileObject fileObject = jAXWSClientSupport.getLocalWsdlFolderForClient(string3, false);
                    FileObject fileObject2 = fileObject.getFileObject(string.getLocalWsdlFile());
                    WsdlModeler wsdlModeler = WsdlModelerFactory.getDefault().getWsdlModeler(fileObject2.getURL());
                    wsdlModeler.setPackageName(string2);
                    wsdlModeler.setCatalog(jAXWSClientSupport.getCatalog());
                    WsdlModel wsdlModel = wsdlModeler.getAndWaitForWsdlModel();
                    if (wsdlModel == null) {
                        RestResourceGenerator.this.finishProgressReporting();
                        RestResourceGenerator.this.dialog.close();
                        return;
                    }
                    JavaSource javaSource = null;
                    final RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
                    try {
                        restSupport.ensureRestDevelopmentReady();
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify();
                    }
                    List list = wsdlModel.getServices();
                    for (WsdlService wsdlService : list) {
                        List list2 = wsdlService.getPorts();
                        for (WsdlPort wsdlPort : list2) {
                            List list3;
                            String string4;
                            FileObject fileObject3 = RestResourceGenerator.this.folder.getFileObject(wsdlPort.getName(), "java");
                            if (fileObject3 != null) {
                                string4 = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(RestResourceGenerator.class, (String)"MSG_CONFIRM_DELETE", (Object)wsdlPort.getName()), NbBundle.getMessage(RestResourceGenerator.class, (String)"TITLE_CONFIRM_DELETE"), 0);
                                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)string4) != NotifyDescriptor.YES_OPTION) continue;
                                list3 = null;
                                try {
                                    list3 = fileObject3.lock();
                                    fileObject3.delete((FileLock)list3);
                                }
                                catch (IOException iOException) {
                                    ErrorManager.getDefault().notify((Throwable)iOException);
                                }
                                finally {
                                    if (list3 != null) {
                                        list3.releaseLock();
                                    }
                                }
                            }
                            string4 = NbBundle.getMessage(RestResourceGenerator.class, (String)"MSG_GENERATING_RESOURCE_FILE");
                            RestResourceGenerator.this.reportProgress(string4);
                            javaSource = JavaSourceHelper.createJavaSource((String)RestResourceGenerator.RESOURCE_TEMPLATE, (FileObject)RestResourceGenerator.this.folder, (String)RestResourceGenerator.this.packageName, (String)wsdlPort.getName());
                            list3 = wsdlPort.getOperations();
                            for (WSOperation wSOperation : list3) {
                                try {
                                    new RestWrapperForSoapGenerator((WSService)wsdlService, (WSPort)wsdlPort, wSOperation, project, (FileObject)javaSource.getFileObjects().iterator().next(), RestResourceGenerator.this.wsdlURL.toString()).generate();
                                }
                                catch (IOException iOException) {
                                    ErrorManager.getDefault().notify((Throwable)iOException);
                                    try {
                                        restSupport.getRestServicesModel().runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                                            public Void run(RestServicesMetadata restServicesMetadata) throws IOException {
                                                RestServices restServices = restServicesMetadata.getRoot();
                                                if (restServices.sizeRestServiceDescription() < 1) {
                                                    restSupport.removeRestDevelopmentReadiness();
                                                }
                                                return null;
                                            }
                                        });
                                    }
                                    catch (IOException iOException2) {
                                        Exceptions.printStackTrace((Throwable)iOException2);
                                    }
                                }
                            }
                            try {
                                RestResourceGenerator.this.initializeClient((WSService)wsdlService, (WSPort)wsdlPort, RestResourceGenerator.this.wsdlURL.toString(), javaSource);
                            }
                            catch (IOException iOException) {
                                Exceptions.printStackTrace((Throwable)iOException);
                            }
                            try {
                                FileObject fileObject4 = (FileObject)javaSource.getFileObjects().iterator().next();
                                RestResourceGenerator.openFileInEditor(DataObject.find((FileObject)fileObject4));
                            }
                            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
                finally {
                    RestResourceGenerator.this.finishProgressReporting();
                    RestResourceGenerator.this.dialog.close();
                }
            }
        });
        this.generatorTask.schedule(50);
        this.dialog.open();
    }

    private String getPackageName(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = string;
        int n = 0;
        Project project = FileOwnerQuery.getOwner((FileObject)this.folder);
        JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
        Client[] clientArray = jaxWsModel.getClients();
        for (Client client : clientArray) {
            arrayList.add(client.getPackageName());
        }
        for (String string3 : arrayList) {
            if (!string2.equals(string3)) continue;
            string2 = string + String.valueOf(++n);
        }
        return string2;
    }

    private void initializeClient(final WSService wSService, final WSPort wSPort, String string, JavaSource javaSource) throws IOException {
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree classTree = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                MethodTree methodTree = JavaSourceHelper.getDefaultConstructor((CompilationController)workingCopy);
                String string = "\n{\nport = getPort();\n}\n";
                ModifiersTree modifiersTree = GenerationUtils.newInstance((WorkingCopy)workingCopy).createModifiers(Modifier.PUBLIC);
                List list = Collections.emptyList();
                List list2 = Collections.emptyList();
                List list3 = Collections.emptyList();
                MethodTree methodTree2 = treeMaker.Constructor(modifiersTree, list, list2, list3, string);
                workingCopy.rewrite((Tree)methodTree, (Tree)methodTree2);
                ClassTree classTree2 = JavaSourceHelper.addField((WorkingCopy)workingCopy, (ClassTree)classTree, (Modifier[])new Modifier[]{Modifier.PRIVATE}, null, null, (String)"port", (Object)wSPort.getJavaName(), null);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
                ClassTree classTree3 = JavaSourceHelper.addMethod((WorkingCopy)workingCopy, (ClassTree)classTree2, (Modifier[])new Modifier[]{Modifier.PRIVATE}, null, null, (String)"getPort", (Object)wSPort.getJavaName(), null, null, null, null, (String)RestResourceGenerator.this.generateGetPort(wSService, wSPort), (String)"");
                workingCopy.rewrite((Tree)classTree, (Tree)classTree3);
            }

            public void cancel() {
            }
        };
        javaSource.runModificationTask((Task)cancellableTask).commit();
    }

    private String generateGetPort(WSService wSService, WSPort wSPort) {
        String string = "";
        String string2 = "service";
        String string3 = wSService.getJavaName();
        String string4 = wSPort.getJavaName();
        String string5 = wSPort.getPortGetter();
        Object[] objectArray = new String[]{string3, string4, string5, "", "", string2};
        String string6 = "\ntry '{' // Call Web Service Operation\n   {0} {5} = new {0}();\n   {1} p = {5}.{2}();\n\nreturn p;\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
        string6 = string6 + "\nreturn null;\n";
        string = "\n{\n" + MessageFormat.format(string6, objectArray) + "\n}\n";
        return string;
    }

    private Client clientExists(JaxWsModel jaxWsModel, String string) {
        Client[] clientArray = jaxWsModel.getClients();
        for (int i = 0; i < clientArray.length; ++i) {
            if (!clientArray[i].getName().equals(string)) continue;
            return clientArray[i];
        }
        return null;
    }

    private String generateClient(Project project, String string, String string2) throws IOException {
        JAXWSClientSupport jAXWSClientSupport = null;
        if (project != null) {
            jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)project.getProjectDirectory());
        }
        if (jAXWSClientSupport == null) {
            String string3 = NbBundle.getMessage(RestResourceGenerator.class, (String)"ERR_NoWebServiceClientSupport");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return null;
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        return jAXWSClientSupport.addServiceClient(this.getWsdlName(string), string, string2, true);
    }

    private String getWsdlName(String string) {
        String string2;
        int n = string.lastIndexOf("/");
        String string3 = string2 = n >= 0 ? string.substring(n + 1) : string;
        if (string2.toUpperCase().endsWith("?WSDL")) {
            string2 = string2.substring(0, string2.length() - 5);
        }
        if ((n = string2.lastIndexOf(".")) > 0) {
            string2 = string2.substring(0, n);
        }
        return this.convertAllSpecialChars(string2);
    }

    private String convertAllSpecialChars(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            char c = stringBuffer.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '/' || c == '.' || c == '_' || c == ' ' || c == '-') continue;
            stringBuffer.setCharAt(i, '_');
        }
        return stringBuffer.toString();
    }

    public static void openFileInEditor(DataObject dataObject) {
        final OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    openCookie.open();
                }
            }, 1000);
        } else {
            final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    editorCookie.open();
                }
            }, 1000);
        }
    }

    public void initProgressReporting(ProgressHandle progressHandle) {
        this.initProgressReporting(progressHandle, true);
    }

    public void initProgressReporting(ProgressHandle progressHandle, boolean bl) {
        this.pHandle = progressHandle;
        this.totalWorkUnits = this.getTotalWorkUnits();
        this.workUnits = 0;
        if (progressHandle != null && bl) {
            if (this.totalWorkUnits > 0) {
                progressHandle.start(this.totalWorkUnits);
            } else {
                progressHandle.start();
            }
        }
    }

    public void reportProgress(String string) {
        if (this.pHandle != null) {
            if (this.totalWorkUnits > 0) {
                this.pHandle.progress(string, ++this.workUnits);
            } else {
                this.pHandle.progress(string);
            }
        }
    }

    public void finishProgressReporting() {
        if (this.pHandle != null) {
            this.pHandle.finish();
        }
    }

    public int getTotalWorkUnits() {
        return 0;
    }

    protected ProgressHandle getProgressHandle() {
        return this.pHandle;
    }
}

