/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.saas;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSOperation;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSParameter;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSPort;
import org.netbeans.modules.websvc.jaxwsmodelapi.WSService;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestWrapperForSoapGenerator {
    private FileObject targetFile;
    private WSService service;
    private WSPort port;
    private WSOperation operation;
    private Project project;
    private Map<String, Class> primitiveTypes;
    public static final Modifier[] PUBLIC = new Modifier[]{Modifier.PUBLIC};
    public static final String INDENT = "        ";
    public static final String INDENT_2 = "             ";
    public static final String APP_XML_MIME = "application/xml";
    public static final String TEXT_PLAIN_MIME = "text/plain";
    public static final String APP_JSON_MIMI = "application/json";
    private String[] ANNOTATIONS_GET = new String[]{"javax.ws.rs.GET", "javax.ws.rs.Produces", "javax.ws.rs.Consumes", "javax.ws.rs.Path"};
    private String[] ANNOTATIONS_POST = new String[]{"javax.ws.rs.POST", "javax.ws.rs.Produces", "javax.ws.rs.Consumes", "javax.ws.rs.Path"};
    private String[] ANNOTATIONS_PUT = new String[]{"javax.ws.rs.PUT", "javax.ws.rs.Consumes", "javax.ws.rs.Path"};
    static final String JAVA_TRY = "\ntry '{' // Call Web Service Operation\n";
    static final String JAVA_SERVICE_DEF = "   {0} {5} = new {0}();\n";
    static final String JAVA_PORT_DEF = "   {1} p = {5}.{2}();\n";
    static final String JAVA_RESULT = "   {3} result = port.{4}({6});\n";
    static final String JAVA_VOID = "   port.{4}({6});\n";
    static final String JAVA_CATCH = "'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
    static final String IF_PORT_NOT_NULL = "\nif(port != null)'{'\n";
    static final String CLOSE_IF_PORT = "\n'}'\n";
    private String wsdlUrl;

    public RestWrapperForSoapGenerator(WSService wSService, WSPort wSPort, WSOperation wSOperation, Project project, FileObject fileObject, String string) {
        this.service = wSService;
        this.port = wSPort;
        this.operation = wSOperation;
        this.targetFile = fileObject;
        this.project = project;
        this.wsdlUrl = string;
    }

    public Set<FileObject> generate() throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.targetFile);
        final String string = this.operation.getReturnTypeName();
        CancellableTask<WorkingCopy> cancellableTask = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree classTree = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                List<? extends AnnotationMirror> list = typeElement.getAnnotationMirrors();
                String string2 = classTree.getSimpleName().toString().toLowerCase();
                AnnotationMirror annotationMirror = JavaSourceHelper.findAnnotation(list, (String)("javax.ws.rs.Path(\"" + string2 + "\")"));
                if (annotationMirror == null) {
                    RestWrapperForSoapGenerator.this.addPathAnnotation(workingCopy, new String[]{classTree.getSimpleName().toString().toLowerCase()});
                }
                if (!string.equals("void") && RestWrapperForSoapGenerator.this.getPrimitiveType(string) == null) {
                    RestWrapperForSoapGenerator.this.addQNameImport(workingCopy);
                }
                ClassTree classTree2 = RestWrapperForSoapGenerator.this.addHttpMethod(string, workingCopy, classTree);
                workingCopy.rewrite((Tree)classTree, (Tree)classTree2);
            }

            public void cancel() {
            }
        };
        javaSource.runModificationTask((Task)cancellableTask).commit();
        return new HashSet<FileObject>(Collections.EMPTY_LIST);
    }

    private void addQNameImport(WorkingCopy workingCopy) {
        JavaSourceHelper.addImports((WorkingCopy)workingCopy, (String[])new String[]{"javax.xml.namespace.QName"});
    }

    public List<WSParameter> getOutputParameters() {
        ArrayList<WSParameter> arrayList = new ArrayList<WSParameter>();
        for (WSParameter wSParameter : this.operation.getParameters()) {
            if (!wSParameter.isHolder()) continue;
            arrayList.add(wSParameter);
        }
        return arrayList;
    }

    private void addPathAnnotation(WorkingCopy workingCopy, String[] stringArray) {
        JavaSourceHelper.addClassAnnotation((WorkingCopy)workingCopy, (String[])new String[]{"Path"}, (Object[])stringArray);
    }

    private String wrapInJaxbElement(String string) {
        return "javax.xml.bind.JAXBElement<" + string + ">";
    }

    private ClassTree addHttpMethod(String string, WorkingCopy workingCopy, ClassTree classTree) throws IOException {
        String[][] stringArray;
        Object[] objectArray2;
        List list;
        Modifier[] modifierArray = PUBLIC;
        String string2 = string;
        if (string2.equals("void")) {
            list = this.getOutputParameters();
            for (Object[] objectArray2 : list) {
                if (!objectArray2.isHolder()) continue;
                stringArray = objectArray2.getTypeName();
                int n = stringArray.indexOf("<");
                int n2 = stringArray.lastIndexOf(">");
                string2 = stringArray.substring(n + 1, n2);
                break;
            }
        } else {
            string2 = this.getPrimitiveType(string2) != null ? "java.lang.String" : this.wrapInJaxbElement(string2);
        }
        list = this.operation.getParameters();
        String[] stringArray2 = this.getHttpParamNames(list);
        objectArray2 = this.getHttpParamTypes(list);
        stringArray = this.getHttpParamAnnotations((String[])objectArray2);
        Object[][] objectArray3 = this.getHttpParamAnnotationAttrs(list, (String[])objectArray2);
        String[] stringArray3 = this.getOperationAnnotations(string2, (String[])objectArray2);
        Object[] objectArray4 = this.getOperationAnnotationAttrs(this.operation.getName(), string2, (String[])objectArray2);
        String string3 = this.getSOAPClientInvocation(string2);
        String string4 = "Invokes the SOAP method " + this.operation.getName() + "\n";
        for (String string5 : stringArray2) {
            string4 = string4 + "@param $PARAM$ resource URI parameter\n".replace("$PARAM$", string5);
        }
        if (!string2.equals("void")) {
            string4 = string4 + "@return an instance of " + string2;
        }
        int n = stringArray3[0].lastIndexOf(".");
        String string6 = stringArray3[0].substring(n + 1).toLowerCase();
        return JavaSourceHelper.addMethod((WorkingCopy)workingCopy, (ClassTree)classTree, (Modifier[])modifierArray, (String[])stringArray3, (Object[])objectArray4, (String)this.getMethodName(string6), (Object)string2, (String[])stringArray2, (Object[])objectArray2, (Object[])stringArray, (Object[])objectArray3, (String)string3, (String)string4);
    }

    private String[] getHttpParamTypes(List<WSParameter> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WSParameter wSParameter : list) {
            String string = wSParameter.getTypeName();
            if (wSParameter.isHolder()) continue;
            if (this.getPrimitiveType(string) == null) {
                arrayList.add(this.wrapInJaxbElement(string));
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private String[] getHttpParamNames(List<WSParameter> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (WSParameter wSParameter : list) {
            if (wSParameter.isHolder()) continue;
            arrayList.add(wSParameter.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Object generateDefaultValue(Class clazz) {
        if (clazz == Integer.class || clazz == Short.class || clazz == Long.class || clazz == Float.class || clazz == Double.class) {
            try {
                return clazz.getConstructor(String.class).newInstance("0");
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (clazz == Boolean.class) {
            return Boolean.FALSE;
        }
        if (clazz == Character.class) {
            return new Character('\u0000');
        }
        return null;
    }

    private String[][] getHttpParamAnnotations(String[] stringArray) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray2 = null;
        if (!this.hasComplexTypes(stringArray)) {
            for (int i = 0; i < stringArray.length; ++i) {
                Class clazz = this.getType(this.project, stringArray[i]);
                stringArray2 = this.generateDefaultValue(clazz) != null ? new String[]{"javax.ws.rs.QueryParam", "javax.ws.rs.DefaultValue"} : new String[]{"javax.ws.rs.QueryParam"};
                arrayList.add(stringArray2);
            }
        }
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    public Class getGenericRawType(String string, ClassLoader classLoader) {
        int n = string.indexOf(60);
        if (n < 1) {
            return null;
        }
        String string2 = string.substring(0, n);
        try {
            return classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Logger.global.log(Level.INFO, "", classNotFoundException);
            return null;
        }
    }

    public Class getType(Project project, String string) {
        List<ClassPath> list = RestWrapperForSoapGenerator.getClassPath(project);
        for (ClassPath classPath : list) {
            try {
                Class clazz = this.getPrimitiveType(string);
                if (clazz != null) {
                    return clazz;
                }
                ClassLoader classLoader = classPath.getClassLoader(true);
                clazz = this.getGenericRawType(string, classLoader);
                if (clazz != null) {
                    return clazz;
                }
                if (classLoader == null) continue;
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class[] getInputParameterTypes() {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        for (WSParameter wSParameter : this.operation.getParameters()) {
            if (wSParameter.isHolder()) continue;
            Class clazz = null;
            RestWrapperForSoapGenerator restWrapperForSoapGenerator = this;
            synchronized (restWrapperForSoapGenerator) {
                try {
                    for (int i = 0; i < 60 && (clazz = this.getType(this.project, wSParameter.getTypeName())) == null; ++i) {
                        this.wait(2000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = Object.class;
            }
            arrayList.add(clazz);
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    private Object[][] getHttpParamAnnotationAttrs(List<WSParameter> list, String[] stringArray) {
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Object[] objectArray = null;
        if (!this.hasComplexTypes(stringArray)) {
            for (WSParameter wSParameter : list) {
                Class clazz = this.getType(this.project, wSParameter.getTypeName());
                Object object = this.generateDefaultValue(clazz);
                objectArray = this.generateDefaultValue(clazz) != null ? new Object[]{wSParameter.getName(), object.toString()} : new Object[]{wSParameter.getName()};
                arrayList.add(objectArray);
            }
        }
        return (Object[][])arrayList.toArray((T[])new Object[arrayList.size()][]);
    }

    private String getMethodName(String string) {
        String string2 = this.camelize(this.operation.getName(), true);
        if (string2.startsWith(string)) {
            return string2;
        }
        return string + this.camelize(string2, false);
    }

    private String getSOAPClientInvocation(String string) throws IOException {
        String string2 = "{\n";
        string2 = string2 + this.getCustomMethodBody() + "\n";
        if (!string.equals("void")) {
            string2 = string2 + "return null;\n";
        }
        string2 = string2 + "}\n";
        return string2;
    }

    private String getReturnTypeQName(String string) {
        int n = string.lastIndexOf(".");
        String string2 = string.substring(0, n);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[--n2] = stringTokenizer.nextToken();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuffer.append(".");
        }
        String string3 = "http//" + stringBuffer.toString() + "/";
        String string4 = string.substring(n + 1).toLowerCase();
        return "new QName(\"" + string3 + "\",\"" + string4 + "\")";
    }

    private String getReturnStatement(WSOperation wSOperation) {
        String string = "return result";
        String string2 = wSOperation.getReturnTypeName();
        Class clazz = this.getPrimitiveType(string2);
        if (clazz != null && !string2.equals("java.lang.String") && !string2.equals("String")) {
            string = "return new " + clazz.getName() + "(result).toString();";
        } else if (clazz == null) {
            string = "return new JAXBElement<" + string2 + ">(" + this.getReturnTypeQName(string2) + "," + string2 + ".class, result);";
        }
        return string;
    }

    private String getCustomMethodBody() throws IOException {
        String string = INDENT;
        string = string + this.getWSInvocationCode(this.targetFile, this.service, this.port, this.operation);
        return string;
    }

    public String getWSInvocationCode(FileObject fileObject, WSService wSService, WSPort wSPort, WSOperation wSOperation) {
        Object object2;
        String string = "service";
        String string2 = wSOperation.getJavaName();
        String string3 = wSPort.getJavaName();
        String string4 = wSPort.getPortGetter();
        String string5 = wSService.getJavaName();
        List list = wSOperation.getParameters();
        String string6 = wSOperation.getReturnTypeName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (Object object2 : list) {
            String string7 = object2.getTypeName();
            String string8 = object2.getName();
            if (this.getPrimitiveType(string7) == null) {
                string8 = string8 + ".getValue()";
            }
            stringBuffer.append(n > 0 ? ", " + string8 : string8);
            ++n;
        }
        String string9 = stringBuffer.toString();
        object2 = this.getJavaInvocationWithReturnBody(wSOperation, string3, string4, string6, string2, string, string9);
        return object2;
    }

    public String getJavaInvocationWithReturnBody(WSOperation wSOperation, String string, String string2, String string3, String string4, String string5, String string6) {
        String string7 = this.service.getJavaName();
        String string8 = "";
        Object[] objectArray = new Object[]{string7, string, string2, string3, string4, string5, string6};
        if ("void".equals(string3)) {
            String string9 = "\ntry '{' // Call Web Service Operation\n\nif(port != null)'{'\n   port.{4}({6});\n\n'}'\n'}' catch (Exception ex) '{'\n   // TODO handle custom exceptions here\n'}'\n";
            string8 = MessageFormat.format(string9, objectArray);
        } else {
            String string10 = "\ntry '{' // Call Web Service Operation\n\nif(port != null)'{'\n   {3} result = port.{4}({6});\n" + this.getReturnStatement(wSOperation) + CLOSE_IF_PORT + JAVA_CATCH;
            string8 = MessageFormat.format(string10, objectArray);
        }
        return string8;
    }

    private Class getPrimitiveType(String string) {
        if (this.primitiveTypes == null) {
            this.primitiveTypes = new HashMap<String, Class>();
            this.primitiveTypes.put("int", Integer.class);
            this.primitiveTypes.put("int[]", Integer[].class);
            this.primitiveTypes.put("boolean", Boolean.class);
            this.primitiveTypes.put("boolean[]", Boolean[].class);
            this.primitiveTypes.put("byte", Byte.class);
            this.primitiveTypes.put("byte[]", Byte[].class);
            this.primitiveTypes.put("char", Character.class);
            this.primitiveTypes.put("char[]", Character[].class);
            this.primitiveTypes.put("double", Double.class);
            this.primitiveTypes.put("double[]", Double[].class);
            this.primitiveTypes.put("float", Float.class);
            this.primitiveTypes.put("float[]", Float[].class);
            this.primitiveTypes.put("long", Long.class);
            this.primitiveTypes.put("long[]", Long[].class);
            this.primitiveTypes.put("short", Short.class);
            this.primitiveTypes.put("short[]", Short[].class);
            this.primitiveTypes.put("java.lang.String", String.class);
            this.primitiveTypes.put("String", String.class);
        }
        return this.primitiveTypes.get(string);
    }

    public static List<ClassPath> getClassPath(Project project) {
        ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>();
        ArrayList<SourceGroup> arrayList2 = new ArrayList<SourceGroup>();
        arrayList2.addAll(Arrays.asList(ProjectUtils.getSources((Project)project).getSourceGroups("java")));
        ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        for (SourceGroup sourceGroup : arrayList2) {
            ClassPath classPath = classPathProvider.findClassPath(sourceGroup.getRootFolder(), "classpath/compile");
            if (classPath != null) {
                arrayList.add(classPath);
            }
            if ((classPath = classPathProvider.findClassPath(sourceGroup.getRootFolder(), "classpath/source")) == null) continue;
            arrayList.add(classPath);
        }
        return arrayList;
    }

    public String camelize(String string, boolean bl) {
        if (string.length() == 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        if (bl) {
            stringBuffer.append(Character.toLowerCase(string.charAt(0)));
        } else {
            stringBuffer.append(Character.toUpperCase(string.charAt(0)));
        }
        boolean bl2 = false;
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl2) {
                stringBuffer.append(Character.toUpperCase(c));
                bl2 = false;
                continue;
            }
            if (c == '_') {
                bl2 = true;
                continue;
            }
            if (c == '/') {
                bl2 = true;
                stringBuffer.append('.');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private boolean hasComplexTypes(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.getPrimitiveType(stringArray[i]) != null) continue;
            return true;
        }
        return false;
    }

    private Object[] getOperationAnnotationAttrs(String string, String string2, String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(null);
        if (!string2.equals("void")) {
            if (this.getPrimitiveType(string2) == null) {
                arrayList.add(APP_XML_MIME);
            } else {
                arrayList.add(TEXT_PLAIN_MIME);
            }
        }
        if (this.hasComplexTypes(stringArray)) {
            arrayList.add(APP_XML_MIME);
        } else {
            arrayList.add(TEXT_PLAIN_MIME);
        }
        arrayList.add(string.toLowerCase() + "/");
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    private String[] getOperationAnnotations(String string, String[] stringArray) {
        if (!string.equals("void")) {
            if (this.hasComplexTypes(stringArray)) {
                return this.ANNOTATIONS_POST;
            }
            return this.ANNOTATIONS_GET;
        }
        return this.ANNOTATIONS_PUT;
    }
}

