/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.utils.RemoteUtils;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProvider;
import org.netbeans.modules.cnd.remote.support.RunFacade;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HostMappingProviderUnixAbstract
implements HostMappingProvider {
    private static final String NET = "/net/";
    private static final Pattern pattern = Pattern.compile("\t+| +");

    protected abstract String getShareCommand();

    protected abstract String fetchPath(String[] var1);

    @Override
    public Map<String, String> findMappings(String string, String string2) {
        RunFacade runFacade;
        String string3;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        boolean bl = RemoteUtils.isLocalhost((String)string);
        String string4 = string3 = bl ? HostMappingProviderUnixAbstract.getLocalHostName() : RemoteUtils.getHostName((String)string);
        if (string3 != null && (runFacade = RunFacade.getInstance(string)).run(this.getShareCommand())) {
            List<String> list = this.parseOutput(string, new StringReader(runFacade.getOutput()));
            for (String string5 : list) {
                assert (string5 != null && string5.length() > 0 && string5.charAt(0) == '/');
                String string6 = NET + string3 + string5;
                if (bl) {
                    hashMap.put(string5, string6);
                    continue;
                }
                hashMap.put(string6, string5);
            }
        }
        return hashMap;
    }

    private List<String> parseOutput(String string, Reader reader) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                String string3 = this.fetchPath(pattern.split(string2));
                if (string3 != null && HostInfoProvider.getDefault().fileExists(string, string3)) {
                    arrayList.add(string3);
                }
                string2 = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return arrayList;
    }

    private static String getLocalHostName() {
        String[] stringArray;
        String string;
        String string2 = null;
        RunFacade runFacade = RunFacade.getInstance("localhost");
        if (runFacade.run("uname -a") && (string = runFacade.getOutput()) != null && (stringArray = string.split(" +")).length > 1) {
            string2 = stringArray[1];
        }
        return string2;
    }
}

