/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.api.utils.RemoteUtils;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProvider;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostMappingProviderWindows
implements HostMappingProvider {
    @Override
    public Map<String, String> findMappings(String string, String string2) {
        Map<String, String> map = null;
        try {
            Process process = Runtime.getRuntime().exec("net use");
            InputStream inputStream = process.getInputStream();
            process.waitFor();
            map = HostMappingProviderWindows.parseNetUseOutput(RemoteUtils.getHostName((String)string2), new InputStreamReader(inputStream));
            return map;
        }
        catch (InterruptedException interruptedException) {
            Exceptions.printStackTrace((Throwable)interruptedException);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return map != null ? map : Collections.emptyMap();
    }

    @Override
    public boolean isApplicable(PlatformInfo platformInfo, PlatformInfo platformInfo2) {
        return 3 == platformInfo.getPlatform() && platformInfo.isLocalhost();
    }

    static Map<String, String> parseNetUseOutput(String string, Reader reader) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        String string2 = bufferedReader.readLine();
        while (string2 != null && !string2.contains("Status")) {
            string2 = bufferedReader.readLine();
        }
        if (string2 != null) {
            int n = string2.indexOf("Local");
            int n2 = string2.indexOf("Remote");
            int n3 = string2.indexOf("Network");
            string2 = bufferedReader.readLine();
            while (string2 != null && !string2.startsWith("----")) {
                string2 = bufferedReader.readLine();
            }
            if (string2 != null) {
                string2 = bufferedReader.readLine();
                while (string2 != null && string2.indexOf(58) != -1) {
                    String string3 = string2.substring(n, n2 - 1).trim();
                    String string4 = string2.substring(n2, n3 - 1).trim();
                    String[] stringArray = string4.substring(2).split("\\\\");
                    if (stringArray.length >= 2) {
                        String string5 = stringArray[0];
                        String string6 = stringArray[1];
                        if (string.equals(string5)) {
                            hashMap.put(string6, string3.toLowerCase());
                        }
                    }
                    string2 = bufferedReader.readLine();
                }
            }
        }
        return hashMap;
    }
}

