/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.remote.mapper.HostMappingsAnalyzer;
import org.netbeans.modules.cnd.remote.support.RemoteCommandSupport;
import org.netbeans.modules.cnd.remote.ui.EditPathMapDialog;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemotePathMap
implements PathMap {
    private static final Map<String, RemotePathMap> pmtable = new HashMap<String, RemotePathMap>();
    private final HashMap<String, String> map = new HashMap();
    private final String hkey;
    private static final String REMOTE_PATH_MAP = "remote-path-map";
    private static final String DELIMITER = "\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemotePathMap getMapper(String string) {
        RemotePathMap remotePathMap = pmtable.get(string);
        if (remotePathMap == null) {
            Map<String, RemotePathMap> map = pmtable;
            synchronized (map) {
                remotePathMap = new RemotePathMap(string);
                pmtable.put(string, remotePathMap);
            }
        }
        return remotePathMap;
    }

    public static boolean isReady(String string) {
        return pmtable.get(string) != null;
    }

    private RemotePathMap(String string) {
        this.hkey = string;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        HashMap<String, String> hashMap = this.map;
        synchronized (hashMap) {
            String string = RemotePathMap.getPreferences(this.hkey);
            if (string == null) {
                String string2 = System.getProperty("cnd.remote.pmap");
                if (string2 != null) {
                    File file = new File(string2);
                    if (file.exists() && file.canRead()) {
                        try {
                            String string3;
                            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                            while ((string3 = bufferedReader.readLine()) != null) {
                                int n = string3.indexOf(32);
                                if (n <= 0) continue;
                                this.map.put(string3.substring(0, n), string3.substring(n + 1).trim());
                            }
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    HostMappingsAnalyzer hostMappingsAnalyzer = new HostMappingsAnalyzer(this.hkey);
                    this.map.putAll(hostMappingsAnalyzer.getMappings());
                }
            } else {
                String[] stringArray = string.split(DELIMITER);
                for (int i = 0; i < stringArray.length; i += 2) {
                    if (i + 1 < stringArray.length) {
                        this.map.put(stringArray[i], stringArray[i + 1]);
                        continue;
                    }
                    System.err.println("mapping serialization flaw. Was found: " + string);
                }
            }
        }
    }

    public String getRemotePath(String string) {
        String string2 = RemotePathMap.unifySeparators(string);
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String string3 = RemotePathMap.unifySeparators(entry.getKey());
            if (!string2.startsWith(string3)) continue;
            String string4 = entry.getValue();
            return string4 + string.substring(string3.length()).replace('\\', '/');
        }
        return string;
    }

    public String getLocalPath(String string) {
        String string2 = RemotePathMap.unifySeparators(string);
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String string3 = RemotePathMap.unifySeparators(entry.getValue());
            if (!string2.startsWith(string3)) continue;
            String string4 = entry.getKey();
            return string4 + string.substring(string3.length());
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    public boolean isRemote(String string, boolean bl) {
        block13: {
            Object object;
            Object object22;
            String string2 = RemotePathMap.unifySeparators(string);
            for (Object object22 : this.map.entrySet()) {
                object = RemotePathMap.unifySeparators(object22.getValue());
                if (!string2.startsWith((String)object)) continue;
                return true;
            }
            Object object3 = this.map.keySet().iterator();
            while (object3.hasNext()) {
                object22 = (String)object3.next();
                if (!string2.startsWith(RemotePathMap.unifySeparators((String)object22))) continue;
                return true;
            }
            if (!PlatformInfo.getDefault((String)this.hkey).isWindows() && !PlatformInfo.getDefault((String)"localhost").isWindows() && ((File)(object3 = new File(string))).exists() && ((File)object3).isDirectory()) {
                object22 = null;
                try {
                    object22 = File.createTempFile("cnd", "tmp", (File)object3);
                    object = new BufferedWriter(new FileWriter((File)object22));
                    String string3 = Double.toString(Math.random());
                    ((Writer)object).write(string3);
                    ((BufferedWriter)object).close();
                    if (0 != RemoteCommandSupport.run(this.hkey, "cat " + ((File)object22).getAbsolutePath() + " | grep " + string3)) break block13;
                    HashMap<String, String> hashMap = this.map;
                    synchronized (hashMap) {
                        this.map.put(string, string);
                    }
                    boolean bl2 = true;
                    return bl2;
                }
                catch (IOException iOException) {
                }
                finally {
                    if (object22 != null && ((File)object22).exists()) {
                        ((File)object22).delete();
                    }
                }
            }
        }
        if (bl) {
            return EditPathMapDialog.showMe(this.hkey, string) && this.isRemote(string, false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePathMap(Map<String, String> map) {
        HashMap<String, String> hashMap = this.map;
        synchronized (hashMap) {
            this.map.clear();
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : map.keySet()) {
                String string2 = RemotePathMap.fixEnding(map.get(string));
                string = RemotePathMap.fixEnding(string);
                this.map.put(string, string2);
                stringBuilder.append(RemotePathMap.fixEnding(string));
                stringBuilder.append(DELIMITER);
                stringBuilder.append(string2);
                stringBuilder.append(DELIMITER);
            }
            RemotePathMap.setPreferences(this.hkey, stringBuilder.toString());
        }
    }

    public Map<String, String> getMap() {
        return (Map)this.map.clone();
    }

    private static String fixEnding(String string) {
        if (string.charAt(string.length() - 1) != '/' && string.charAt(string.length() - 1) != '\\') {
            return string + "/";
        }
        return string;
    }

    private static String unifySeparators(String string) {
        return string.replace('\\', '/').toLowerCase();
    }

    public static boolean isSubPath(String string, String string2) {
        return RemotePathMap.unifySeparators(string2).startsWith(RemotePathMap.unifySeparators(string));
    }

    private static String getPreferences(String string) {
        return NbPreferences.forModule(RemotePathMap.class).get(REMOTE_PATH_MAP + string, null);
    }

    private static void setPreferences(String string, String string2) {
        NbPreferences.forModule(RemotePathMap.class).put(REMOTE_PATH_MAP + string, string2);
    }
}

