/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.swing.JButton;
import org.netbeans.modules.cnd.remote.support.RemoteUserInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public abstract class RemoteConnectionSupport {
    private JSch jsch;
    protected final String key;
    protected Session session;
    protected Channel channel;
    private final String user;
    private final String host;
    private int exit_status;
    private boolean cancelled = false;
    private boolean failed = false;
    private String failureReason;
    private Integer timeout = Integer.getInteger("cnd.remote.timeout");
    protected static Logger log = Logger.getLogger("cnd.remote.logger");

    public RemoteConnectionSupport(String string, int n) {
        this.key = string;
        int n2 = string.indexOf(64);
        this.user = string.substring(0, n2);
        this.host = string.substring(n2 + 1);
        this.exit_status = -1;
        this.failureReason = "";
        boolean bl = false;
        log.finest("RCS<Init>: Starting " + this.getClass().getName() + " on " + string);
        do {
            try {
                this.jsch = new JSch();
                this.jsch.setKnownHosts(System.getProperty("user.home") + "/.ssh/known_hosts");
                this.session = this.jsch.getSession(this.user, this.host, n);
                RemoteUserInfo remoteUserInfo = RemoteUserInfo.getUserInfo(string, bl);
                bl = false;
                this.session.setUserInfo((UserInfo)remoteUserInfo);
                this.session.connect(this.timeout == null ? 30000 : this.timeout);
                if (this.session.isConnected()) continue;
                log.fine("RCS<Init>: Connection failed on " + string);
            }
            catch (JSchException jSchException) {
                log.warning("RCS<Init>: Got JSchException [" + jSchException.getMessage() + "]");
                String string2 = jSchException.getMessage();
                if (string2.equals("Auth cancel")) {
                    this.cancelled = true;
                    continue;
                }
                if (string2.equals("Auth fail")) {
                    JButton jButton = new JButton(NbBundle.getMessage(RemoteConnectionSupport.class, (String)"BTN_Retry"));
                    NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage(RemoteConnectionSupport.class, (String)"MSG_AuthFailedRetry"), NbBundle.getMessage(RemoteConnectionSupport.class, (String)"TITLE_AuthFailedRetryDialog"), 2, 3, new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton);
                    if (DialogDisplayer.getDefault().notify(notifyDescriptor) == jButton) {
                        bl = true;
                        continue;
                    }
                    this.failed = true;
                    this.failureReason = string2;
                    continue;
                }
                this.failed = true;
                this.failureReason = string2;
            }
        } while (bl);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    protected Channel createChannel(InputStream inputStream, OutputStream outputStream) throws JSchException {
        return (ChannelExec)this.session.openChannel("exec");
    }

    protected Channel createChannel() throws JSchException {
        return this.createChannel(null, null);
    }

    public int getExitStatus() {
        return !this.cancelled && this.channel != null ? this.channel.getExitStatus() : -1;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public void setFailed(String string) {
        this.failed = true;
        this.failureReason = string;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public boolean isFailedOrCancelled() {
        return this.failed || this.cancelled;
    }

    protected void setExitStatus(int n) {
        this.exit_status = n;
    }

    public void disconnect() {
        if (this.channel != null && this.channel.isConnected()) {
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    public String getUser() {
        return this.user;
    }

    public String getHost() {
        return this.host;
    }
}

