/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.utils.RemoteUtils;
import org.netbeans.modules.cnd.makeproject.api.compilers.BasicCompiler;
import org.netbeans.modules.cnd.remote.support.RemoteCopySupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemIncludesUtils {
    private static final Logger log = Logger.getLogger("cnd.remote.logger");
    private static final String tempDir = System.getProperty("java.io.tmpdir");

    public static RequestProcessor.Task load(final String string, final List<CompilerSet> list) {
        return RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)(SystemIncludesUtils.getMessage("SIU_ProgressTitle") + " " + RemoteUtils.getHostName((String)string)));
                progressHandle.start();
                log.fine("SystemIncludesUtils.load for " + string);
                String string3 = null;
                try {
                    HashSet<String> hashSet = new HashSet<String>();
                    for (CompilerSet compilerSet : list) {
                        for (Tool tool : compilerSet.getTools()) {
                            if (!(tool instanceof BasicCompiler)) continue;
                            BasicCompiler basicCompiler = (BasicCompiler)tool;
                            string3 = basicCompiler.getIncludeFilePathPrefix();
                            for (Object e : basicCompiler.getSystemIncludeDirectories()) {
                                String string2 = (String)e;
                                if (string2.length() < string3.length()) {
                                    log.warning("CompilerSet " + basicCompiler.getDisplayName() + " has returned invalid include path: " + string2);
                                    continue;
                                }
                                hashSet.add(string2.substring(string3.length()));
                            }
                        }
                    }
                    if (string3 != null) {
                        SystemIncludesUtils.doLoad(string, string3, hashSet, progressHandle);
                    }
                }
                finally {
                    progressHandle.finish();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doLoad(String string, String string2, Collection<String> collection, ProgressHandle progressHandle) {
        File file = new File(string2);
        File file2 = new File(file.getParent(), file.getName() + ".download");
        if (file.exists()) {
            return true;
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!file2.isDirectory()) {
            return false;
        }
        boolean bl = false;
        try {
            RemoteCopySupport remoteCopySupport = new RemoteCopySupport(string);
            bl = SystemIncludesUtils.load(file2.getAbsolutePath(), remoteCopySupport, collection, progressHandle);
            log.fine("SystemIncludesUtils.doLoad for " + file2 + " finished " + bl);
            if (bl) {
                log.fine("SystemIncludesUtils.doLoad renaming " + file2 + " to " + file);
                file2.renameTo(file);
            }
        }
        finally {
            if (!bl && file.exists()) {
                log.fine("SystemIncludesUtils.doLoad removing " + file + " due to faile");
                file.delete();
            }
        }
        return true;
    }

    private static boolean load(String string, RemoteCopySupport remoteCopySupport, Collection<String> collection, ProgressHandle progressHandle) {
        progressHandle.switchToDeterminate(3 * collection.size());
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : collection) {
            String string3;
            log.fine("SystemIncludesUtils.load loading " + string2);
            String string4 = "cnd" + string2.replaceAll("(/|\\\\)", "-") + ".zip";
            String string5 = "/tmp/" + string4;
            try {
                File file = File.createTempFile(string4, ".zip", new File(tempDir));
                string3 = file.getAbsolutePath();
            }
            catch (IOException iOException) {
                string3 = tempDir + File.separator + string4;
            }
            progressHandle.progress(SystemIncludesUtils.getMessage("SIU_Archiving") + " " + string2, n++);
            remoteCopySupport.run("zip -r -q " + string5 + " " + string2);
            progressHandle.progress(SystemIncludesUtils.getMessage("SIU_Downloading") + " " + string2, n++);
            remoteCopySupport.copyFrom(string5, string3);
            progressHandle.progress(SystemIncludesUtils.getMessage("SIU_Preparing") + " " + string2, n++);
            SystemIncludesUtils.unzip(string, string3);
            arrayList.add(string3);
            log.fine("SystemIncludesUtils.load loading done for " + string2);
        }
        remoteCopySupport.disconnect();
        for (String string2 : arrayList) {
            new File(string2).delete();
        }
        return true;
    }

    private static void unzip(String string, String string2) {
        long l = System.currentTimeMillis();
        try {
            File file = new File(string);
            if (!file.exists()) {
                file.mkdir();
            }
            assert (file.isDirectory());
            ZipFile zipFile = new ZipFile(string2);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                File file2 = new File(file, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                    continue;
                }
                SystemIncludesUtils.copyInputStream(zipFile.getInputStream(zipEntry), new BufferedOutputStream(new FileOutputStream(file2.getAbsolutePath())));
            }
            zipFile.close();
        }
        catch (IOException iOException) {
            log.warning("unzipping " + string2 + " to " + string + " failed");
            log.warning(iOException.getMessage());
            return;
        }
        log.fine("unzipping " + string2 + " to " + string + " took " + (System.currentTimeMillis() - l) + " ms");
    }

    private static final void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.close();
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(SystemIncludesUtils.class, (String)string);
    }
}

