/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.server.RemoteServerList;
import org.netbeans.modules.cnd.remote.ui.AddServerDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class EditPathMapDialog
extends JPanel
implements ActionListener {
    private final JButton btnOK;
    private Dialog presenter;
    private String currentHkey;
    private DefaultComboBoxModel serverListModel;
    private final String pathToValidate;
    private final Map<String, DefaultTableModel> cache = new HashMap<String, DefaultTableModel>();
    private ProgressHandle phandle;
    private JComboBox cbHostsList;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblHostName;
    private JTable tblPathMappings;
    private JTextArea txtError;
    private JTextArea txtExplanation;

    public static boolean showMe(String string, String[] stringArray) {
        return EditPathMapDialog.showMe(string, null, stringArray);
    }

    public static boolean showMe(String string, String string2) {
        return EditPathMapDialog.showMe(string, string2, RemoteServerList.getInstance().getServerNames());
    }

    private static boolean showMe(String string, String string2, String[] stringArray) {
        Dialog dialog;
        JButton jButton = new JButton(NbBundle.getMessage(AddServerDialog.class, (String)"BTN_OK"));
        EditPathMapDialog editPathMapDialog = new EditPathMapDialog(string, string2, stringArray, jButton);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editPathMapDialog, NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialogTitle"), true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, null, (ActionListener)editPathMapDialog);
        dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        editPathMapDialog.presenter = dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            editPathMapDialog.applyChanges();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected EditPathMapDialog(String string, String string2, String[] stringArray, JButton jButton) {
        void var5_8;
        this.btnOK = jButton;
        this.pathToValidate = string2;
        this.currentHkey = string;
        this.serverListModel = new DefaultComboBoxModel();
        for (String string3 : stringArray) {
            if ("localhost".equals(string3)) continue;
            this.serverListModel.addElement(string3);
        }
        this.initComponents();
        this.tblPathMappings.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblPathMappings.getTableHeader().setPreferredSize(new Dimension(0, 20));
        this.cbHostsList.setSelectedItem(this.currentHkey);
        if (string2 != null) {
            String string4 = NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_ExplanationWithPath", (Object)string2);
        } else {
            String string5 = NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Explanation");
        }
        this.txtExplanation.setText((String)var5_8);
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.jScrollPane1.setOpaque(false);
            this.jScrollPane3.setOpaque(false);
        }
        this.initTableModel(this.currentHkey);
    }

    private static RemotePathMap getRemotePathMap(String string) {
        return RemotePathMap.getMapper(string);
    }

    private synchronized void initTableModel(final String string) {
        DefaultTableModel defaultTableModel = this.cache.get(string);
        if (defaultTableModel == null) {
            if (RemotePathMap.isReady(string)) {
                defaultTableModel = this.prepareTableModel(string);
            } else {
                this.handleProgress(true);
                defaultTableModel = new DefaultTableModel(0, 2);
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        final DefaultTableModel defaultTableModel = EditPathMapDialog.this.prepareTableModel(string);
                        EditPathMapDialog.this.cache.put(string, defaultTableModel);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (EditPathMapDialog.this.tblPathMappings != null) {
                                    EditPathMapDialog.this.handleProgress(false);
                                    EditPathMapDialog.this.updatePathMappingsTable(defaultTableModel);
                                    EditPathMapDialog.this.enableControls(true, "");
                                }
                            }
                        });
                    }
                });
                this.enableControls(false, NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Loading"));
            }
            this.cache.put(string, defaultTableModel);
        }
        this.updatePathMappingsTable(defaultTableModel);
    }

    private void enableControls(boolean bl, String string) {
        this.btnOK.setEnabled(bl);
        this.tblPathMappings.setEnabled(bl);
        this.cbHostsList.setEnabled(bl);
        this.txtError.setText(string);
    }

    private void updatePathMappingsTable(DefaultTableModel defaultTableModel) {
        this.tblPathMappings.setModel(defaultTableModel);
        this.setColumnNames();
    }

    private DefaultTableModel prepareTableModel(String string) {
        Map<String, String> map = EditPathMapDialog.getRemotePathMap(string).getMap();
        DefaultTableModel defaultTableModel = new DefaultTableModel(0, 2);
        for (String string2 : map.keySet()) {
            defaultTableModel.addRow(new String[]{string2, map.get(string2)});
        }
        if (defaultTableModel.getRowCount() < 4) {
            for (int i = 4; i > defaultTableModel.getRowCount(); --i) {
                defaultTableModel.addRow(new String[]{null, null});
            }
        } else {
            defaultTableModel.addRow(new String[]{null, null});
        }
        return defaultTableModel;
    }

    private void setColumnNames() {
        this.tblPathMappings.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(EditPathMapDialog.class, (String)"LocalPathColumnName"));
        this.tblPathMappings.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(EditPathMapDialog.class, (String)"RemotePathColumnName"));
    }

    void applyChanges() {
        for (String string : this.cache.keySet()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            DefaultTableModel defaultTableModel = this.cache.get(string);
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                String string2 = (String)defaultTableModel.getValueAt(i, 0);
                String string3 = (String)defaultTableModel.getValueAt(i, 1);
                if (string2 == null || string3 == null) continue;
                string2 = string2.trim();
                string3 = string3.trim();
                if (string2.length() <= 0 || string3.length() <= 0) continue;
                hashMap.put(string2, string3);
            }
            EditPathMapDialog.getRemotePathMap(string).updatePathMap(hashMap);
        }
    }

    private void initComponents() {
        this.lblHostName = new JLabel();
        this.cbHostsList = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.tblPathMappings = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.txtExplanation = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.txtError = new JTextArea();
        this.jPanel1 = new JPanel();
        this.lblHostName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/remote/ui/Bundle").getString("EPMD_Hostname").charAt(0));
        this.lblHostName.setLabelFor(this.cbHostsList);
        this.lblHostName.setText(NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialog.lblHostName.text"));
        this.lblHostName.setFocusable(false);
        this.cbHostsList.setModel(this.serverListModel);
        this.cbHostsList.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                EditPathMapDialog.this.cbHostsListItemStateChanged(itemEvent);
            }
        });
        this.tblPathMappings.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tblPathMappings.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tblPathMappings);
        this.tblPathMappings.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_MappingsTable_AN"));
        this.tblPathMappings.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_MappingsTable_AD"));
        this.jScrollPane2.setBorder(null);
        this.txtExplanation.setBackground(this.getBackground());
        this.txtExplanation.setColumns(20);
        this.txtExplanation.setLineWrap(true);
        this.txtExplanation.setRows(4);
        this.txtExplanation.setText(NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialog.txtExplanation.text"));
        this.txtExplanation.setWrapStyleWord(true);
        this.txtExplanation.setAutoscrolls(false);
        this.txtExplanation.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.txtExplanation.setFocusable(false);
        this.txtExplanation.setMargin(new Insets(0, 0, 0, 0));
        this.jScrollPane2.setViewportView(this.txtExplanation);
        this.jScrollPane3.setBorder(null);
        this.txtError.setBackground(this.getBackground());
        this.txtError.setColumns(20);
        this.txtError.setForeground(new Color(255, 0, 0));
        this.txtError.setLineWrap(true);
        this.txtError.setRows(4);
        this.txtError.setWrapStyleWord(true);
        this.txtError.setFocusable(false);
        this.jScrollPane3.setViewportView(this.txtError);
        this.jPanel1.setLayout(new BorderLayout());
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane3, -1, 427, Short.MAX_VALUE).add(1, (Component)this.jPanel1, -1, 427, Short.MAX_VALUE).add(1, (Component)this.jScrollPane2, -1, 427, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblHostName).addPreferredGap(1).add((Component)this.cbHostsList, 0, 391, Short.MAX_VALUE)).add(1, (Component)this.jScrollPane1, -1, 427, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblHostName).add((Component)this.cbHostsList, -2, -1, -2)).addPreferredGap(0).add((Component)this.jScrollPane2, -2, 61, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 97, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, 23, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.jScrollPane3, -2, 118, -2).addContainerGap()));
        this.lblHostName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Hostname"));
        this.lblHostName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Host_AD"));
        this.cbHostsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Hostname"));
        this.cbHostsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Host_AD"));
    }

    private void cbHostsListItemStateChanged(ItemEvent itemEvent) {
        this.currentHkey = (String)this.cbHostsList.getSelectedItem();
        this.initTableModel(this.currentHkey);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnOK) {
            if (this.cache.get(this.currentHkey).getRowCount() == 0) {
                this.presenter.setVisible(false);
                return;
            }
            this.handleProgress(true);
            this.enableControls(false, NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Validating"));
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    final String string = EditPathMapDialog.this.validateMaps();
                    Runnable runnable = string.length() == 0 ? new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                Exceptions.printStackTrace((Throwable)interruptedException);
                            }
                            EditPathMapDialog.this.presenter.setVisible(false);
                        }
                    } : new Runnable(){

                        public void run() {
                            EditPathMapDialog.this.handleProgress(false);
                            EditPathMapDialog.this.enableControls(true, string);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
        }
    }

    private void handleProgress(boolean bl) {
        if (bl) {
            this.phandle = ProgressHandleFactory.createHandle((String)"");
            this.jPanel1.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)this.phandle), "North");
            this.jPanel1.setVisible(true);
            this.phandle.start();
        } else {
            this.phandle.finish();
            this.jPanel1.setVisible(false);
            this.jPanel1.removeAll();
        }
    }

    private String validateMaps() {
        DefaultTableModel defaultTableModel = this.cache.get(this.currentHkey);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            String string = (String)defaultTableModel.getValueAt(i, 0);
            String string2 = (String)defaultTableModel.getValueAt(i, 1);
            if (string != null && (string = string.trim()).length() > 0) {
                if (!HostInfoProvider.getDefault().fileExists("localhost", string)) {
                    stringBuilder.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_BadLocalPath", (Object)string));
                }
                if (this.pathToValidate != null && !bl && string2 != null && RemotePathMap.isSubPath(string, this.pathToValidate)) {
                    bl = true;
                }
            }
            if (string2 == null || (string2 = string2.trim()).length() <= 0 || HostInfoProvider.getDefault().fileExists(this.currentHkey, string2)) continue;
            stringBuilder.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_BadRemotePath", (Object)string2));
        }
        if (this.pathToValidate != null && !bl) {
            stringBuilder.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_PathNotResolved", (Object)this.pathToValidate));
        }
        return stringBuilder.toString();
    }
}

