/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmIdentifiable;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeclarationContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceImpl
implements CsmNamespace,
MutableDeclarationsContainer,
Persistent,
SelfPersistent,
Disposable {
    private static final CharSequence GLOBAL = CharSequenceKey.create((CharSequence)"$Global$");
    private Object projectRef;
    private final CsmUID<CsmProject> projectUID;
    private CsmNamespace parentRef;
    private final CsmUID<CsmNamespace> parentUID;
    private final CharSequence name;
    private final CharSequence qualifiedName;
    private Map<CharSequence, CsmUID<CsmNamespace>> nestedNamespaces = new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>();
    private final Key declarationsSorageKey;
    private final Set<CsmUID<CsmOffsetableDeclaration>> unnamedDeclarations = Collections.synchronizedSet(new HashSet());
    private Map<CharSequence, CsmUID<CsmNamespaceDefinition>> nsDefinitions = new TreeMap<CharSequence, CsmUID<CsmNamespaceDefinition>>(CharSequenceKey.Comparator);
    private ReadWriteLock nsDefinitionsLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock projectLock = new ReentrantReadWriteLock();
    private final boolean global;
    private static final boolean CHECK_PARENT = false;
    private static final String UNNAMED_PREFIX = "<unnamed>";
    private Set<Integer> unnamedNrs = new HashSet<Integer>();
    private CsmUID<CsmNamespace> uid = null;

    public NamespaceImpl(ProjectBase projectBase) {
        this.name = GLOBAL;
        this.qualifiedName = CharSequenceKey.empty();
        this.parentUID = null;
        this.parentRef = null;
        this.global = true;
        assert (projectBase != null);
        this.projectUID = UIDCsmConverter.projectToUID(projectBase);
        assert (this.projectUID != null);
        this.projectRef = new WeakReference<ProjectBase>(projectBase);
        this.declarationsSorageKey = new DeclarationContainer(this).getKey();
        projectBase.registerNamespace(this);
    }

    public NamespaceImpl(ProjectBase projectBase, NamespaceImpl namespaceImpl, String string, String string2) {
        this.name = NameCache.getManager().getString((CharSequence)string);
        this.global = false;
        assert (projectBase != null);
        this.projectUID = UIDCsmConverter.projectToUID(projectBase);
        assert (this.projectUID != null);
        this.projectRef = new WeakReference<ProjectBase>(projectBase);
        this.qualifiedName = QualifiedNameCache.getManager().getString((CharSequence)string2);
        this.parentUID = UIDCsmConverter.namespaceToUID(namespaceImpl);
        assert (this.parentUID != null || namespaceImpl == null);
        this.parentRef = null;
        this.declarationsSorageKey = new DeclarationContainer(this).getKey();
        projectBase.registerNamespace(this);
        if (namespaceImpl != null) {
            namespaceImpl.addNestedNamespace(this);
        }
        this.notifyCreation();
    }

    protected void notifyCreation() {
        assert (!this.isGlobal());
        Notificator.instance().registerNewNamespace(this);
    }

    @Override
    public void dispose() {
        this.onDispose();
        this.notifyRemove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDispose() {
        this.projectLock.writeLock().lock();
        try {
            if (TraceFlags.RESTORE_CONTAINER_FROM_UID) {
                this.projectRef = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
                assert (this.projectRef != null || this.projectUID == null) : "no object for UID " + this.projectUID;
                this.parentRef = UIDCsmConverter.UIDtoNamespace(this.parentUID);
                assert (this.parentRef != null || this.parentUID == null) : "no object for UID " + this.parentUID;
            }
        }
        finally {
            this.projectLock.writeLock().unlock();
        }
    }

    protected void notifyRemove() {
        assert (!this.isGlobal());
        Notificator.instance().registerRemovedNamespace(this);
    }

    public String getNameForUnnamedElement() {
        String string = UNNAMED_PREFIX;
        int n = this.getMinUnnamedValue();
        if (n != 0) {
            string = string + n;
        }
        this.unnamedNrs.add(n);
        return string;
    }

    private int getMinUnnamedValue() {
        for (int i = 0; i < this.unnamedNrs.size(); ++i) {
            if (this.unnamedNrs.contains(i)) continue;
            return i;
        }
        return this.unnamedNrs.size();
    }

    public CsmNamespace getParent() {
        return this._getParentNamespace();
    }

    public Collection<CsmNamespace> getNestedNamespaces() {
        Collection<CsmNamespace> collection = UIDCsmConverter.UIDsToNamespaces(new ArrayList(this.nestedNamespaces.values()));
        return collection;
    }

    private DeclarationContainer getDeclarationsSorage() {
        DeclarationContainer declarationContainer = (DeclarationContainer)RepositoryUtils.get(this.declarationsSorageKey);
        if (declarationContainer == null) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get DeclarationsSorage by key " + this.declarationsSorageKey));
        }
        return declarationContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        Collection collection = this.getDeclarationsSorage().getDeclarationsUIDs();
        Collection<Object> collection2 = this.unnamedDeclarations;
        synchronized (collection2) {
            collection.addAll(this.unnamedDeclarations);
        }
        collection2 = UIDCsmConverter.UIDsToDeclarations(collection);
        return collection2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmSelect.CsmFilter csmFilter) {
        Collection collection = this.getDeclarationsSorage().getDeclarationsUIDs();
        Set<CsmUID<CsmOffsetableDeclaration>> set = this.unnamedDeclarations;
        synchronized (set) {
            collection.addAll(this.unnamedDeclarations);
        }
        return UIDCsmConverter.UIDsToDeclarations(collection, csmFilter);
    }

    public Collection<CsmUID<CsmOffsetableDeclaration>> findUidsByPrefix(String string) {
        char c = '\u00ff';
        return this.getDeclarationsSorage().getUIDsRange(string, string + c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getUnnamedUids() {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> arrayList;
        Set<CsmUID<CsmOffsetableDeclaration>> set = this.unnamedDeclarations;
        synchronized (set) {
            arrayList = new ArrayList<CsmUID<CsmOffsetableDeclaration>>(this.unnamedDeclarations);
        }
        return arrayList;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public CharSequence getQualifiedName() {
        return this.qualifiedName;
    }

    public NamespaceImpl getNamespace(String string) {
        assert (string != null && string.length() != 0) : "non empty namespace should be asked";
        String string2 = Utils.getNestedNamespaceQualifiedName(string, this, true);
        NamespaceImpl namespaceImpl = this._getNestedNamespace(string2);
        if (namespaceImpl == null) {
            namespaceImpl = new NamespaceImpl(this._getProject(), this, string, string2);
        }
        return namespaceImpl;
    }

    public CharSequence getName() {
        return this.name;
    }

    private NamespaceImpl _getNestedNamespace(CharSequence charSequence) {
        charSequence = CharSequenceKey.create((CharSequence)charSequence);
        CsmUID<CsmNamespace> csmUID = this.nestedNamespaces.get(charSequence);
        NamespaceImpl namespaceImpl = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(csmUID);
        assert (namespaceImpl != null || csmUID == null);
        return namespaceImpl;
    }

    private void addNestedNamespace(NamespaceImpl namespaceImpl) {
        assert (namespaceImpl != null);
        CsmUID csmUID = RepositoryUtils.put((CsmIdentifiable)namespaceImpl);
        assert (csmUID != null);
        this.nestedNamespaces.put(namespaceImpl.getQualifiedName(), (CsmUID<CsmNamespace>)csmUID);
        RepositoryUtils.put((CsmIdentifiable)this);
    }

    private void removeNestedNamespace(NamespaceImpl namespaceImpl) {
        assert (namespaceImpl != null);
        CsmUID<CsmNamespace> csmUID = this.nestedNamespaces.remove(namespaceImpl.getQualifiedName());
        assert (csmUID != null);
        if (namespaceImpl.getName().length() == 0) {
            String string = ((Object)namespaceImpl.getQualifiedName()).toString();
            int n = string.lastIndexOf(62);
            assert (n >= 0);
            if (n + 1 < string.length()) {
                try {
                    Integer n2 = Integer.parseInt(string.substring(n + 1));
                    this.unnamedNrs.remove(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    DiagnosticExceptoins.register(numberFormatException);
                }
            } else {
                this.unnamedNrs.remove(0);
            }
        }
    }

    public static boolean isNamespaceScope(VariableImpl variableImpl, boolean bl) {
        if (((FileImpl)variableImpl.getContainingFile()).isHeaderFile() && !CsmKindUtilities.isVariableDefinition((CsmObject)variableImpl)) {
            return true;
        }
        if (variableImpl.isStatic()) {
            return false;
        }
        return !variableImpl.isConst() || !bl || variableImpl.isExtern();
    }

    public static boolean isNamespaceScope(FunctionImpl functionImpl) {
        if (((FileImpl)functionImpl.getContainingFile()).isHeaderFile() && !functionImpl.isPureDefinition()) {
            return true;
        }
        return !functionImpl.isStatic();
    }

    @Override
    public void addDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        boolean bl;
        boolean bl2 = bl = !ProjectBase.canRegisterDeclaration((CsmDeclaration)csmOffsetableDeclaration);
        if (bl && !CsmKindUtilities.isEnum((CsmObject)csmOffsetableDeclaration)) {
            return;
        }
        if (csmOffsetableDeclaration instanceof VariableImpl) {
            VariableImpl variableImpl = (VariableImpl)csmOffsetableDeclaration;
            if (NamespaceImpl.isNamespaceScope(variableImpl, this.isGlobal())) {
                variableImpl.setScope((CsmScope)this);
            } else {
                return;
            }
        }
        if (bl) {
            this.unnamedDeclarations.add(UIDCsmConverter.declarationToUID(csmOffsetableDeclaration));
        } else {
            this.getDeclarationsSorage().putDeclaration(csmOffsetableDeclaration);
        }
        RepositoryUtils.put((CsmIdentifiable)this);
        Notificator.instance().registerNewDeclaration(csmOffsetableDeclaration);
    }

    @Override
    public void removeDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (csmOffsetableDeclaration.getName().length() == 0) {
            CsmUID csmUID = csmOffsetableDeclaration.getUID();
            this.unnamedDeclarations.remove(csmUID);
        } else {
            this.getDeclarationsSorage().removeDeclaration((CsmDeclaration)csmOffsetableDeclaration);
        }
        RepositoryUtils.put((CsmIdentifiable)this);
        Notificator.instance().registerRemovedDeclaration(csmOffsetableDeclaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmNamespaceDefinition> getDefinitions() {
        ArrayList arrayList = new ArrayList();
        try {
            this.nsDefinitionsLock.readLock().lock();
            arrayList.addAll(this.nsDefinitions.values());
        }
        finally {
            this.nsDefinitionsLock.readLock().unlock();
        }
        Collection<CsmNamespaceDefinition> collection = UIDCsmConverter.UIDsToDeclarations(arrayList);
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNamespaceDefinition(CsmNamespaceDefinition csmNamespaceDefinition) {
        CsmUID csmUID = RepositoryUtils.put((CsmIdentifiable)csmNamespaceDefinition);
        try {
            this.nsDefinitionsLock.writeLock().lock();
            this.nsDefinitions.put(NamespaceImpl.getSortKey(csmNamespaceDefinition), (CsmUID<CsmNamespaceDefinition>)csmUID);
        }
        finally {
            this.nsDefinitionsLock.writeLock().unlock();
        }
        RepositoryUtils.put((CsmIdentifiable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNamespaceDefinition(CsmNamespaceDefinition csmNamespaceDefinition) {
        assert (!this.isGlobal());
        boolean bl = false;
        CsmUID<CsmNamespaceDefinition> csmUID = null;
        try {
            this.nsDefinitionsLock.writeLock().lock();
            csmUID = this.nsDefinitions.remove(NamespaceImpl.getSortKey(csmNamespaceDefinition));
        }
        finally {
            this.nsDefinitionsLock.writeLock().unlock();
        }
        RepositoryUtils.put((CsmIdentifiable)this);
        try {
            this.nsDefinitionsLock.readLock().lock();
            bl = this.nsDefinitions.size() == 0;
        }
        finally {
            this.nsDefinitionsLock.readLock().unlock();
        }
        if (bl) {
            NamespaceImpl namespaceImpl = (NamespaceImpl)this._getParentNamespace();
            if (namespaceImpl != null) {
                namespaceImpl.removeNestedNamespace(this);
            }
            this.projectRef = this._getProject();
            ((ProjectBase)this.projectRef).unregisterNamesace(this);
            this.dispose();
        }
    }

    public static String getSortKey(CsmNamespaceDefinition csmNamespaceDefinition) {
        StringBuilder stringBuilder = new StringBuilder(csmNamespaceDefinition.getContainingFile().getAbsolutePath());
        int n = csmNamespaceDefinition.getStartOffset();
        String string = Integer.toString(n);
        int n2 = 8 - string.length();
        while (n2-- > 0) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append(csmNamespaceDefinition.getName());
        return stringBuilder.toString();
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return (List)this.getDeclarations();
    }

    public CsmProject getProject() {
        return this._getProject();
    }

    public CsmUID<CsmNamespace> getUID() {
        if (this.uid == null) {
            this.uid = this.createUID();
        }
        return this.uid;
    }

    protected CsmUID<CsmNamespace> createUID() {
        return UIDUtilities.createNamespaceUID(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectBase _getProject() {
        this.projectLock.readLock().lock();
        try {
            ProjectBase projectBase = null;
            if (this.projectRef instanceof ProjectBase) {
                projectBase = (ProjectBase)this.projectRef;
            } else if (this.projectRef instanceof Reference) {
                projectBase = (ProjectBase)((Reference)this.projectRef).get();
            }
            if (projectBase == null) {
                projectBase = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
                assert (projectBase != null || this.projectUID == null) : "empty project for UID " + this.projectUID;
                this.projectRef = new WeakReference<ProjectBase>(projectBase);
            }
            ProjectBase projectBase2 = projectBase;
            return projectBase2;
        }
        finally {
            this.projectLock.readLock().unlock();
        }
    }

    private CsmNamespace _getParentNamespace() {
        CsmNamespace csmNamespace = this.parentRef;
        if (csmNamespace == null) {
            csmNamespace = UIDCsmConverter.UIDtoNamespace(this.parentUID);
            assert (csmNamespace != null || this.parentUID == null) : "null object for UID " + this.parentUID;
        }
        return csmNamespace;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getName());
        stringBuilder.append(' ');
        stringBuilder.append(this.getQualifiedName());
        stringBuilder.append(" NamespaceImpl @");
        stringBuilder.append(this.hashCode());
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.global);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        assert (this.projectUID != null);
        uIDObjectFactory.writeUID(this.projectUID, dataOutput);
        uIDObjectFactory.writeUID(this.parentUID, dataOutput);
        assert (this.name != null);
        dataOutput.writeUTF(((Object)this.name).toString());
        assert (this.qualifiedName != null);
        dataOutput.writeUTF(((Object)this.qualifiedName).toString());
        uIDObjectFactory.writeStringToUIDMap(this.nestedNamespaces, dataOutput, true);
        ProjectComponent.writeKey(this.declarationsSorageKey, dataOutput);
        try {
            this.nsDefinitionsLock.readLock().lock();
            uIDObjectFactory.writeStringToUIDMap(this.nsDefinitions, dataOutput, false);
        }
        finally {
            this.nsDefinitionsLock.readLock().unlock();
        }
        uIDObjectFactory.writeUIDCollection(this.unnamedDeclarations, dataOutput, true);
    }

    public NamespaceImpl(DataInput dataInput) throws IOException {
        this.global = dataInput.readBoolean();
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        this.projectUID = uIDObjectFactory.readUID(dataInput);
        this.parentUID = uIDObjectFactory.readUID(dataInput);
        assert (this.projectUID != null);
        this.projectRef = null;
        this.parentRef = null;
        this.name = NameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.name != null);
        this.qualifiedName = QualifiedNameCache.getManager().getString((CharSequence)dataInput.readUTF());
        assert (this.qualifiedName != null);
        uIDObjectFactory.readStringToUIDMap(this.nestedNamespaces, dataInput, QualifiedNameCache.getManager());
        this.declarationsSorageKey = ProjectComponent.readKey(dataInput);
        assert (this.declarationsSorageKey != null) : "declarationsSorageKey can not be null";
        uIDObjectFactory.readStringToUIDMap(this.nsDefinitions, dataInput, QualifiedNameCache.getManager());
        uIDObjectFactory.readUIDCollection(this.unnamedDeclarations, dataInput);
    }
}

