/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.File;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JEditorPane;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.api.project.DefaultSystemSettings;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.loaders.CCDataLoader;
import org.netbeans.modules.cnd.loaders.CCDataObject;
import org.netbeans.modules.cnd.loaders.CDataLoader;
import org.netbeans.modules.cnd.loaders.CDataObject;
import org.netbeans.modules.cnd.loaders.CndDataObject;
import org.netbeans.modules.cnd.loaders.HDataLoader;
import org.netbeans.modules.cnd.loaders.HDataObject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

public class CsmStandaloneFileProviderImpl
extends CsmStandaloneFileProvider {
    private static final boolean TRACE = Boolean.getBoolean("cnd.standalone.trace");
    private final CsmModelListener listener = new CsmModelListener(){

        public void projectOpened(CsmProject csmProject) {
        }

        public void projectClosed(CsmProject csmProject) {
        }

        public void modelChanged(CsmChangeEvent csmChangeEvent) {
            for (CsmFile csmFile : csmChangeEvent.getNewFiles()) {
                CsmStandaloneFileProviderImpl.this.clean(csmFile);
            }
            for (CsmFile csmFile : csmChangeEvent.getRemovedFiles()) {
                CsmStandaloneFileProviderImpl.this.onFileRemove(csmFile);
            }
        }
    };
    private final CsmProgressListener progressListener = new CsmProgressAdapter(){

        public void projectLoaded(CsmProject csmProject) {
            CsmStandaloneFileProviderImpl.this.clean((ProjectBase)csmProject);
        }

        public void projectParsingFinished(CsmProject csmProject) {
        }
    };

    public CsmStandaloneFileProviderImpl() {
        CsmListeners.getDefault().addModelListener(this.listener);
        CsmListeners.getDefault().addProgressListener(this.progressListener);
    }

    static CsmStandaloneFileProviderImpl getDefaultImpl() {
        return (CsmStandaloneFileProviderImpl)CsmStandaloneFileProvider.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmFile getCsmFile(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        String string = file.getAbsolutePath();
        ProjectBase projectBase = null;
        CsmStandaloneFileProviderImpl csmStandaloneFileProviderImpl = this;
        synchronized (csmStandaloneFileProviderImpl) {
            CsmFile csmFile = ModelImpl.instance().findFile(string);
            if (csmFile != null) {
                return csmFile;
            }
            NativeProject nativeProject = NativeProjectImpl.getNativeProjectImpl(FileUtil.toFile((FileObject)fileObject));
            if (nativeProject != null) {
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("adding project %s", string);
                }
                projectBase = ModelImpl.instance().addProject(nativeProject, string, true);
            }
        }
        if (projectBase != null && projectBase.isValid()) {
            try {
                return projectBase.getFile(file);
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                DiagnosticExceptoins.register(bufferUnderflowException);
            }
            catch (IllegalStateException illegalStateException) {
                DiagnosticExceptoins.register(illegalStateException);
            }
        }
        return null;
    }

    private void clean(ProjectBase projectBase) {
        if (projectBase.getPlatformProject() instanceof NativeProjectImpl) {
            return;
        }
        if (TRACE) {
            CsmStandaloneFileProviderImpl.trace("checking project %s", projectBase.toString());
        }
        for (CsmProject csmProject : ModelImpl.instance().projects()) {
            if (!(csmProject.getPlatformProject() instanceof NativeProjectImpl)) continue;
            for (CsmFile csmFile : csmProject.getAllFiles()) {
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("\nchecking file %s", csmFile.getAbsolutePath());
                }
                if (projectBase.getFile(((FileImpl)csmFile).getFile()) == null) continue;
                this.scheduleProjectRemoval(csmProject);
            }
        }
    }

    private void clean(CsmFile csmFile) {
        if (!(csmFile.getProject().getPlatformProject() instanceof NativeProjectImpl)) {
            this.notifyClosed(csmFile);
        }
    }

    void onFileRemove(CsmFile csmFile) {
        FileObject fileObject = CsmUtilities.getFileObject((CsmFile)csmFile);
        if (fileObject != null && this.isOpen(fileObject)) {
            this.getCsmFile(fileObject);
        }
    }

    private boolean isOpen(FileObject fileObject) {
        try {
            EditorCookie editorCookie;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null) {
                JEditorPane[] jEditorPaneArray = CsmUtilities.getOpenedPanesInEQ((EditorCookie)editorCookie);
                return jEditorPaneArray != null && jEditorPaneArray.length > 0;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public synchronized void notifyClosed(CsmFile csmFile) {
        if (TRACE) {
            CsmStandaloneFileProviderImpl.trace("checking file %s", csmFile.toString());
        }
        FileImpl fileImpl = (FileImpl)csmFile;
        for (CsmProject csmProject : ModelImpl.instance().projects()) {
            CndDataObject cndDataObject;
            NativeFileItemSet nativeFileItemSet;
            File file;
            Object object = csmProject.getPlatformProject();
            if (!(object instanceof NativeProjectImpl) || ((ProjectBase)csmProject).getFile(file = fileImpl.getFile()) == null) continue;
            DataObject dataObject = NativeProjectImpl.getDataObject(file);
            if (dataObject instanceof CndDataObject && (nativeFileItemSet = (NativeFileItemSet)(cndDataObject = (CndDataObject)dataObject).getLookup().lookup(NativeFileItemSet.class)) != null) {
                NativeProjectImpl nativeProjectImpl = (NativeProjectImpl)object;
                nativeFileItemSet.remove(nativeProjectImpl.findFileItem(file));
            }
            this.scheduleProjectRemoval(csmProject);
        }
    }

    private void scheduleProjectRemoval(final CsmProject csmProject) {
        if (TRACE) {
            CsmStandaloneFileProviderImpl.trace("schedulling removal %s", csmProject.toString());
        }
        ModelImpl.instance().enqueueModelTask(new Runnable(){

            public void run() {
                if (csmProject.isValid()) {
                    if (TRACE) {
                        CsmStandaloneFileProviderImpl.trace("removing %s", new Object[]{csmProject.toString()});
                    }
                    ProjectBase projectBase = (ProjectBase)csmProject;
                    ModelImpl.instance().closeProjectBase(projectBase, false);
                }
            }
        }, "Standalone project removal.");
    }

    private static void trace(String string, Object ... objectArray) {
        assert (TRACE) : "Should not be called if TRACE is off!";
        System.err.printf("### Standalone provider:  %s\n", String.format(string, objectArray));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyNativeFileItemSet
    implements NativeFileItemSet {
        private List<NativeFileItem> items = new ArrayList<NativeFileItem>(1);

        private MyNativeFileItemSet() {
        }

        public synchronized Collection<NativeFileItem> getItems() {
            return new ArrayList<NativeFileItem>(this.items);
        }

        public synchronized void add(NativeFileItem nativeFileItem) {
            if (!this.items.contains(nativeFileItem)) {
                this.items.add(nativeFileItem);
            }
        }

        public synchronized void remove(NativeFileItem nativeFileItem) {
            this.items.remove(nativeFileItem);
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NativeFileItemImpl
    implements NativeFileItem {
        private final File file;
        private final NativeProjectImpl project;
        private final NativeFileItem.Language lang;

        public NativeFileItemImpl(File file, NativeProjectImpl nativeProjectImpl, NativeFileItem.Language language) {
            this.project = nativeProjectImpl;
            this.file = file;
            this.lang = language;
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public File getFile() {
            return this.file;
        }

        public List<String> getSystemIncludePaths() {
            List<String> list = this.project.getSystemIncludePaths();
            return this.project.pathsRelCurFile ? this.toAbsolute(list) : list;
        }

        public List<String> getUserIncludePaths() {
            List<String> list = this.project.getUserIncludePaths();
            return this.project.pathsRelCurFile ? this.toAbsolute(list) : list;
        }

        private List<String> toAbsolute(List<String> list) {
            File file = this.file.getParentFile();
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string : list) {
                File file2 = new File(string);
                if (file2.isAbsolute()) {
                    arrayList.add(string);
                    continue;
                }
                file2 = new File(file, string);
                arrayList.add(file2.getAbsolutePath());
            }
            return arrayList;
        }

        public List<String> getSystemMacroDefinitions() {
            return this.project.getSystemMacroDefinitions();
        }

        public List<String> getUserMacroDefinitions() {
            return this.project.getUserMacroDefinitions();
        }

        public NativeFileItem.Language getLanguage() {
            return this.lang;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return NativeFileItem.LanguageFlavor.GENERIC;
        }

        public boolean isExcluded() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NativeProjectImpl
    implements NativeProject {
        private final List<String> sysIncludes;
        private final List<String> usrIncludes;
        private final List<String> sysMacros;
        private final List<String> usrMacros;
        private final List<NativeFileItem> files = new ArrayList<NativeFileItem>();
        private final String projectRoot;
        boolean pathsRelCurFile;
        private List<NativeProjectItemsListener> listeners = new ArrayList<NativeProjectItemsListener>();
        private final Object listenersLock = new Object();

        static NativeProject getNativeProjectImpl(File file) {
            Object object;
            NativeProject nativeProject;
            Object object22;
            ModelImpl modelImpl = ModelImpl.instance();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            ArrayList<String> arrayList4 = new ArrayList<String>();
            DataObject dataObject = NativeProjectImpl.getDataObject(file);
            NativeFileItem.Language language = NativeProjectImpl.getLanguage(file, dataObject);
            NativeProject nativeProject2 = null;
            for (Object object3 : modelImpl.projects()) {
                object22 = object3.getPlatformProject();
                if (!(object22 instanceof NativeProject)) continue;
                nativeProject = (NativeProject)object22;
                if (file.getAbsolutePath().startsWith(nativeProject.getProjectRoot())) {
                    nativeProject2 = nativeProject;
                    break;
                }
                for (String string : nativeProject.getSourceRoots()) {
                    if (!file.getAbsolutePath().startsWith(string)) continue;
                    nativeProject2 = nativeProject;
                    break;
                }
                if (nativeProject2 == null) continue;
                break;
            }
            if (nativeProject2 == null) {
                object = (NativeFileItemSet)dataObject.getLookup().lookup(NativeFileItemSet.class);
                if (object != null) {
                    for (Object object22 : object.getItems()) {
                        nativeProject = object22.getNativeProject();
                        if (nativeProject == null || !ModelImpl.instance().isProjectDiabled(nativeProject)) continue;
                        return null;
                    }
                }
                arrayList.addAll(DefaultSystemSettings.getDefault().getSystemIncludes(language));
                arrayList3.addAll(DefaultSystemSettings.getDefault().getSystemMacros(language));
            } else {
                if (ModelImpl.instance().isProjectDiabled(nativeProject2)) {
                    return null;
                }
                arrayList.addAll(nativeProject2.getSystemIncludePaths());
                arrayList3.addAll(nativeProject2.getSystemMacroDefinitions());
                arrayList2.addAll(nativeProject2.getUserIncludePaths());
                arrayList4.addAll(nativeProject2.getUserMacroDefinitions());
            }
            object = new NativeProjectImpl(file, arrayList, arrayList2, arrayList3, arrayList4);
            super.addFile(file);
            if (dataObject instanceof CndDataObject) {
                Object object3;
                object3 = (CndDataObject)dataObject;
                object22 = (NativeFileItemSet)object3.getLookup().lookup(NativeFileItemSet.class);
                if (object22 == null) {
                    object22 = new MyNativeFileItemSet();
                    object3.addCookie((Node.Cookie)object22);
                }
                object22.add(((NativeProjectImpl)object).findFileItem(file));
            }
            return object;
        }

        private NativeProjectImpl(File file, List<String> list, List<String> list2, List<String> list3, List<String> list4) {
            this(file.getAbsolutePath(), list, list2, list3, list4, false);
        }

        private NativeProjectImpl(String string, List<String> list, List<String> list2, List<String> list3, List<String> list4, boolean bl) {
            this.projectRoot = string;
            this.pathsRelCurFile = bl;
            this.sysIncludes = this.createIncludes(list);
            this.usrIncludes = this.createIncludes(list2);
            this.sysMacros = new ArrayList<String>(list3);
            this.usrMacros = new ArrayList<String>(list4);
        }

        private List<String> createIncludes(List<String> list) {
            if (this.pathsRelCurFile) {
                return new ArrayList<String>(list);
            }
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (String string : list) {
                File file = new File(string);
                arrayList.add(file.getAbsolutePath());
            }
            return arrayList;
        }

        private void addFile(File file) {
            DataObject dataObject = NativeProjectImpl.getDataObject(file);
            NativeFileItem.Language language = NativeProjectImpl.getLanguage(file, dataObject);
            NativeFileItemImpl nativeFileItemImpl = new NativeFileItemImpl(file, this, language);
            this.files.add(nativeFileItemImpl);
        }

        static NativeFileItem.Language getLanguage(File file, DataObject dataObject) {
            if (dataObject == null) {
                String string = file.getAbsolutePath();
                if (CCDataLoader.getInstance().getDefaultExtensionList().isRegistered(string)) {
                    return NativeFileItem.Language.CPP;
                }
                if (CDataLoader.getInstance().getDefaultExtensionList().isRegistered(string)) {
                    return NativeFileItem.Language.C;
                }
                if (HDataLoader.getInstance().getDefaultExtensionList().isRegistered(string)) {
                    return NativeFileItem.Language.C_HEADER;
                }
                return NativeFileItem.Language.OTHER;
            }
            if (dataObject instanceof CCDataObject) {
                return NativeFileItem.Language.CPP;
            }
            if (dataObject instanceof HDataObject) {
                return NativeFileItem.Language.C_HEADER;
            }
            if (dataObject instanceof CDataObject) {
                return NativeFileItem.Language.C;
            }
            return NativeFileItem.Language.OTHER;
        }

        private static DataObject getDataObject(File file) {
            DataObject dataObject = null;
            try {
                FileObject fileObject = FileUtil.toFileObject((File)file.getCanonicalFile());
                if (fileObject != null) {
                    try {
                        dataObject = DataObject.find((FileObject)fileObject);
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return dataObject;
        }

        public Object getProject() {
            return null;
        }

        public List<String> getSourceRoots() {
            return Collections.emptyList();
        }

        public String getProjectRoot() {
            return this.projectRoot;
        }

        public String getProjectDisplayName() {
            return this.getProjectRoot();
        }

        public List<NativeFileItem> getAllFiles() {
            return Collections.unmodifiableList(this.files);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectItemsListener(NativeProjectItemsListener nativeProjectItemsListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.add(nativeProjectItemsListener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProjectItemsListener(NativeProjectItemsListener nativeProjectItemsListener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(nativeProjectItemsListener);
            }
        }

        public NativeFileItem findFileItem(File file) {
            for (NativeFileItem nativeFileItem : this.files) {
                if (!nativeFileItem.getFile().equals(file)) continue;
                return nativeFileItem;
            }
            return null;
        }

        public List<String> getSystemIncludePaths() {
            return this.sysIncludes;
        }

        public List<String> getUserIncludePaths() {
            return this.usrIncludes;
        }

        public List<String> getSystemMacroDefinitions() {
            return this.sysMacros;
        }

        public List<String> getUserMacroDefinitions() {
            return this.usrMacros;
        }

        public List<NativeProject> getDependences() {
            return Collections.emptyList();
        }

        public void runOnCodeModelReadiness(Runnable runnable) {
            runnable.run();
        }
    }
}

