/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.ClassForwardDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.InheritanceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.UsingDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelutil.AntiLoop;
import org.netbeans.modules.cnd.utils.cache.CharSequenceKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resolver3
implements Resolver {
    private static final boolean TRACE_RECURSION = false;
    private static final int INFINITE_RECURSION = 200;
    private static final int LIMITED_RECURSION = 5;
    private ProjectBase project;
    private CsmFile file;
    private int offset;
    private final int origOffset;
    private Resolver parentResolver;
    private List<CharSequence> usedNamespaces = new ArrayList<CharSequence>();
    private Map<CharSequence, CsmNamespace> namespaceAliases = new HashMap<CharSequence, CsmNamespace>();
    private Map<CharSequence, CsmDeclaration> usingDeclarations = new HashMap<CharSequence, CsmDeclaration>();
    private CsmTypedef currTypedef;
    private CharSequence[] names;
    private int currNamIdx;
    private int interestedKind;
    private boolean resolveInBaseClass;
    private CsmNamespace containingNamespace;
    private CsmClass containingClass;
    private boolean contextFound = false;
    private Set<CsmFile> visitedFiles = new HashSet<CsmFile>();

    private CharSequence currName() {
        return this.names != null && this.currNamIdx < this.names.length ? this.names[this.currNamIdx] : CharSequenceKey.empty();
    }

    private CsmNamespace getContainingNamespace() {
        if (!this.contextFound) {
            this.findContext();
        }
        return this.containingNamespace;
    }

    private CsmClass getContainingClass() {
        if (!this.contextFound) {
            this.findContext();
        }
        return this.containingClass;
    }

    private void findContext() {
        this.contextFound = true;
        CsmSelect.CsmFilter csmFilter = CsmSelect.getDefault().getFilterBuilder().createOffsetFilter(0, this.offset);
        this.findContext(CsmSelect.getDefault().getDeclarations(this.file, csmFilter), csmFilter);
    }

    public Resolver3(CsmFile csmFile, int n, Resolver resolver) {
        this.file = csmFile;
        this.offset = n;
        this.origOffset = n;
        this.parentResolver = resolver;
        this.project = (ProjectBase)csmFile.getProject();
    }

    public Resolver3(CsmOffsetable csmOffsetable, Resolver resolver) {
        this.file = csmOffsetable.getContainingFile();
        this.origOffset = this.offset = csmOffsetable.getStartOffset();
        this.parentResolver = resolver;
        this.project = (ProjectBase)csmOffsetable.getContainingFile().getProject();
    }

    private CsmClassifier findClassifier(CsmNamespace csmNamespace, CharSequence charSequence) {
        CsmClassifier csmClassifier = null;
        while (csmNamespace != null && csmClassifier == null) {
            String string = csmNamespace.getQualifiedName() + "::" + charSequence;
            csmClassifier = this.findClassifier(string);
            csmNamespace = csmNamespace.getParent();
        }
        return csmClassifier;
    }

    private CsmClassifier findClassifier(CharSequence charSequence) {
        CsmClassifier csmClassifier = CsmClassifierResolver.getDefault().findClassifierUsedInFile(charSequence, this.file, true);
        return csmClassifier;
    }

    public CsmNamespace findNamespace(CharSequence charSequence) {
        CsmNamespace csmNamespace = this.project.findNamespace(charSequence);
        if (csmNamespace == null) {
            Iterator<CsmProject> iterator = this.project.getLibraries().iterator();
            while (iterator.hasNext() && csmNamespace == null) {
                CsmProject csmProject = iterator.next();
                csmNamespace = csmProject.findNamespace(charSequence);
            }
        }
        return csmNamespace;
    }

    @Override
    public CsmClassifier getOriginalClassifier(CsmClassifier csmClassifier) {
        if (this.isRecursionOnResolving(200)) {
            return null;
        }
        AntiLoop antiLoop = new AntiLoop(100);
        while (true) {
            CsmClass csmClass;
            CsmClassForwardDeclaration csmClassForwardDeclaration;
            antiLoop.add(csmClassifier);
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)csmClassifier)) {
                csmClassForwardDeclaration = (CsmClassForwardDeclaration)csmClassifier;
                csmClass = csmClassForwardDeclaration instanceof ClassForwardDeclarationImpl ? ((ClassForwardDeclarationImpl)csmClassForwardDeclaration).getCsmClass(this) : csmClassForwardDeclaration.getCsmClass();
                if (csmClass == null) break;
                csmClassifier = csmClass;
                continue;
            }
            if (!CsmKindUtilities.isTypedef((CsmObject)csmClassifier)) break;
            csmClassForwardDeclaration = ((CsmTypedef)csmClassifier).getType();
            csmClass = null;
            csmClass = csmClassForwardDeclaration instanceof Resolver.SafeClassifierProvider ? ((Resolver.SafeClassifierProvider)csmClassForwardDeclaration).getClassifier(this) : csmClassForwardDeclaration.getClassifier();
            if (csmClass == null || antiLoop.contains((CsmClassifier)csmClass) && (csmClass = Resolver3.findOtherClassifier(csmClassifier)) == null) break;
            csmClassifier = csmClass;
        }
        return csmClassifier;
    }

    public static CsmClassifier findOtherClassifier(CsmClassifier csmClassifier) {
        CsmNamespace csmNamespace = CsmBaseUtilities.getClassNamespace((CsmClassifier)csmClassifier);
        CsmClassifier csmClassifier2 = null;
        if (csmNamespace != null) {
            CsmUID csmUID = csmClassifier.getUID();
            CharSequence charSequence = csmClassifier.getQualifiedName();
            for (CsmOffsetableDeclaration csmOffsetableDeclaration : csmNamespace.getDeclarations()) {
                if (!CsmKindUtilities.isClassifier((CsmObject)csmOffsetableDeclaration) || !csmOffsetableDeclaration.getQualifiedName().equals(charSequence) || csmOffsetableDeclaration.getUID().equals(csmUID)) continue;
                csmClassifier2 = (CsmClassifier)csmOffsetableDeclaration;
                break;
            }
        }
        return csmClassifier2;
    }

    private void findContext(Iterator iterator, CsmSelect.CsmFilter csmFilter) {
        while (iterator.hasNext()) {
            CsmFunction csmFunction;
            CsmNamespaceDefinition csmNamespaceDefinition;
            CsmDeclaration csmDeclaration = (CsmDeclaration)iterator.next();
            if (csmDeclaration.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
                csmNamespaceDefinition = (CsmNamespaceDefinition)csmDeclaration;
                if (csmNamespaceDefinition.getStartOffset() >= this.offset || this.offset >= csmNamespaceDefinition.getEndOffset()) continue;
                this.containingNamespace = csmNamespaceDefinition.getNamespace();
                this.findContext(CsmSelect.getDefault().getDeclarations(csmNamespaceDefinition, csmFilter), csmFilter);
                continue;
            }
            if (csmDeclaration.getKind() == CsmDeclaration.Kind.CLASS || csmDeclaration.getKind() == CsmDeclaration.Kind.STRUCT || csmDeclaration.getKind() == CsmDeclaration.Kind.UNION) {
                csmNamespaceDefinition = (CsmClass)csmDeclaration;
                if (csmNamespaceDefinition.getStartOffset() >= this.offset || this.offset >= csmNamespaceDefinition.getEndOffset()) continue;
                this.containingClass = csmNamespaceDefinition;
                continue;
            }
            if (csmDeclaration.getKind() != CsmDeclaration.Kind.FUNCTION_DEFINITION || (csmNamespaceDefinition = (CsmFunctionDefinition)csmDeclaration).getStartOffset() >= this.offset || this.offset >= csmNamespaceDefinition.getEndOffset()) continue;
            CsmNamespace csmNamespace = CsmBaseUtilities.getFunctionNamespace((CsmFunction)csmNamespaceDefinition);
            if (csmNamespace != null && !csmNamespace.isGlobal()) {
                this.containingNamespace = csmNamespace;
            }
            if ((csmFunction = this.getFunctionDeclaration((CsmFunctionDefinition)csmNamespaceDefinition)) == null || !CsmKindUtilities.isMethodDeclaration((CsmObject)csmFunction)) continue;
            this.containingClass = ((CsmMethod)csmFunction).getContainingClass();
        }
    }

    private CsmFunction getFunctionDeclaration(CsmFunctionDefinition csmFunctionDefinition) {
        if (csmFunctionDefinition instanceof FunctionDefinitionImpl) {
            if (this.isRecursionOnResolving(200)) {
                return null;
            }
            return ((FunctionDefinitionImpl)csmFunctionDefinition).getDeclaration(this);
        }
        return csmFunctionDefinition.getDeclaration();
    }

    private boolean isRecursionOnResolving(int n) {
        Resolver3 resolver3 = (Resolver3)this.parentResolver;
        int n2 = 0;
        while (resolver3 != null) {
            if (resolver3.origOffset == this.origOffset && resolver3.file.equals(this.file)) {
                return true;
            }
            resolver3 = (Resolver3)resolver3.parentResolver;
            if (++n2 <= n) continue;
            return true;
        }
        return false;
    }

    private void traceRecursion() {
        System.out.println("Detected recursion in resolver:");
        System.out.println("\t" + this);
        Resolver3 resolver3 = (Resolver3)this.parentResolver;
        while (resolver3 != null) {
            System.out.println("\t" + resolver3);
            resolver3 = (Resolver3)resolver3.parentResolver;
        }
        new Exception().printStackTrace();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.file.getAbsolutePath() + ":" + this.origOffset);
        stringBuilder.append(":Looking for ");
        if (this.needClassifiers()) {
            stringBuilder.append("C");
        }
        if (this.needNamespaces()) {
            stringBuilder.append("N");
        }
        stringBuilder.append(":" + this.currName());
        for (int i = 0; i < this.names.length; ++i) {
            if (i == 0) {
                stringBuilder.append("?");
            } else {
                stringBuilder.append("::");
            }
            stringBuilder.append(this.names[i]);
        }
        if (this.containingClass != null) {
            stringBuilder.append(":Class=" + this.containingClass.getName());
        }
        if (this.containingNamespace != null) {
            stringBuilder.append(":NS=" + this.containingNamespace.getName());
        }
        return stringBuilder.toString();
    }

    protected void gatherMaps(CsmFile csmFile) {
        if (csmFile == null || this.visitedFiles.contains(csmFile)) {
            return;
        }
        this.visitedFiles.add(csmFile);
        CsmSelect.CsmFilter csmFilter = CsmSelect.getDefault().getFilterBuilder().createOffsetFilter(0, this.offset);
        Iterator iterator = CsmSelect.getDefault().getIncludes(csmFile, csmFilter);
        while (iterator.hasNext()) {
            CsmInclude csmInclude = (CsmInclude)iterator.next();
            CsmFile csmFile2 = csmInclude.getIncludeFile();
            if (csmFile2 == null) continue;
            int n = this.offset;
            this.offset = Integer.MAX_VALUE;
            this.gatherMaps(csmFile2);
            this.offset = n;
        }
        this.gatherMaps(CsmSelect.getDefault().getDeclarations(csmFile, csmFilter));
    }

    protected void gatherMaps(Iterable iterable) {
        this.gatherMaps(iterable.iterator());
    }

    protected void gatherMaps(Iterator iterator) {
        while (iterator.hasNext()) {
            Object e = iterator.next();
            assert (e instanceof CsmOffsetable);
            try {
                int n = ((CsmOffsetable)e).getStartOffset();
                int n2 = ((CsmOffsetable)e).getEndOffset();
                if (n >= this.offset) break;
                if (e instanceof CsmScopeElement) {
                    this.gatherMaps((CsmScopeElement)e, n2);
                    continue;
                }
                if (!FileImpl.reportErrors) continue;
                System.err.println("Expected CsmScopeElement, got " + e);
            }
            catch (NullPointerException nullPointerException) {
                if (!FileImpl.reportErrors) continue;
                System.err.println("Unexpected NULL element in declarations collection");
                DiagnosticExceptoins.register(nullPointerException);
            }
        }
    }

    private CsmClassifier findNestedClassifier(CsmClassifier csmClassifier) {
        if (CsmKindUtilities.isClass((CsmObject)csmClassifier)) {
            Iterator iterator = CsmSelect.getDefault().getClassMembers((CsmClass)csmClassifier, CsmSelect.getDefault().getFilterBuilder().createNameFilter(((Object)this.currName()).toString(), true, true, false));
            while (iterator.hasNext()) {
                CsmMember csmMember = (CsmMember)iterator.next();
                if (CharSequenceKey.Comparator.compare(this.currName(), csmMember.getName()) != 0 || !CsmKindUtilities.isClassifier((CsmObject)csmMember)) continue;
                return (CsmClassifier)csmMember;
            }
        }
        return null;
    }

    private void doProcessTypedefsInUpperNamespaces(CsmNamespaceDefinition csmNamespaceDefinition) {
        CsmSelect.CsmFilter csmFilter = CsmSelect.getDefault().getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.TYPEDEF});
        Iterator iterator = CsmSelect.getDefault().getDeclarations(csmNamespaceDefinition, csmFilter);
        while (iterator.hasNext()) {
            CsmDeclaration csmDeclaration = (CsmDeclaration)iterator.next();
            if (csmDeclaration.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
                this.processTypedefsInUpperNamespaces((CsmNamespaceDefinition)csmDeclaration);
                continue;
            }
            if (csmDeclaration.getKind() != CsmDeclaration.Kind.TYPEDEF) continue;
            CsmTypedef csmTypedef = (CsmTypedef)csmDeclaration;
            if (CharSequenceKey.Comparator.compare(this.currName(), csmTypedef.getName()) != 0) continue;
            this.currTypedef = csmTypedef;
        }
    }

    private void processTypedefsInUpperNamespaces(CsmNamespaceDefinition csmNamespaceDefinition) {
        if (CharSequenceKey.Comparator.compare(csmNamespaceDefinition.getName(), this.currName()) == 0) {
            ++this.currNamIdx;
            this.doProcessTypedefsInUpperNamespaces(csmNamespaceDefinition);
        } else {
            CsmNamespace csmNamespace = this.getContainingNamespace();
            if (csmNamespace != null && csmNamespace.equals(csmNamespaceDefinition.getNamespace())) {
                this.doProcessTypedefsInUpperNamespaces(csmNamespaceDefinition);
            }
        }
    }

    protected void gatherMaps(CsmScopeElement csmScopeElement, int n) {
        CsmDeclaration.Kind kind;
        CsmDeclaration.Kind kind2 = kind = csmScopeElement instanceof CsmDeclaration ? ((CsmDeclaration)csmScopeElement).getKind() : null;
        if (kind == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            CsmNamespaceDefinition csmNamespaceDefinition = (CsmNamespaceDefinition)csmScopeElement;
            if (csmNamespaceDefinition.getName().length() == 0) {
                this.usedNamespaces.add(csmNamespaceDefinition.getQualifiedName());
            }
            if (this.offset < n || this.isInContext((CsmScope)csmNamespaceDefinition)) {
                this.gatherMaps(csmNamespaceDefinition.getDeclarations());
            } else if (this.needClassifiers()) {
                this.processTypedefsInUpperNamespaces(csmNamespaceDefinition);
            }
        } else if (kind == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            CsmNamespaceAlias csmNamespaceAlias = (CsmNamespaceAlias)csmScopeElement;
            this.namespaceAliases.put(csmNamespaceAlias.getAlias(), csmNamespaceAlias.getReferencedNamespace());
        } else if (kind == CsmDeclaration.Kind.USING_DECLARATION) {
            CsmDeclaration csmDeclaration = this.resolveUsingDeclaration((CsmUsingDeclaration)csmScopeElement);
            if (csmDeclaration != null) {
                CharSequence charSequence = csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION || csmDeclaration.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION ? ((CsmFunction)csmDeclaration).getSignature() : csmDeclaration.getName();
                this.usingDeclarations.put(charSequence, csmDeclaration);
            }
        } else if (kind == CsmDeclaration.Kind.USING_DIRECTIVE) {
            CsmUsingDirective csmUsingDirective = (CsmUsingDirective)csmScopeElement;
            this.usedNamespaces.add(csmUsingDirective.getName());
        } else if (csmScopeElement instanceof CsmDeclarationStatement) {
            CsmDeclarationStatement csmDeclarationStatement = (CsmDeclarationStatement)csmScopeElement;
            if (csmDeclarationStatement.getStartOffset() < this.offset) {
                this.gatherMaps(((CsmDeclarationStatement)csmScopeElement).getDeclarators());
            }
        } else if (CsmKindUtilities.isScope((CsmObject)csmScopeElement)) {
            if (this.offset < n || this.isInContext((CsmScope)csmScopeElement)) {
                this.gatherMaps(((CsmScope)csmScopeElement).getScopeElements());
            }
        } else if (kind == CsmDeclaration.Kind.TYPEDEF && this.needClassifiers()) {
            CsmTypedef csmTypedef = (CsmTypedef)csmScopeElement;
            if (CharSequenceKey.Comparator.compare(this.currName(), csmTypedef.getName()) == 0) {
                this.currTypedef = csmTypedef;
            }
        }
    }

    private boolean isInContext(CsmScope csmScope) {
        if (!CsmKindUtilities.isClass((CsmObject)csmScope) && !CsmKindUtilities.isNamespace((CsmObject)csmScope)) {
            return false;
        }
        CsmQualifiedNamedElement csmQualifiedNamedElement = (CsmQualifiedNamedElement)csmScope;
        CsmNamespace csmNamespace = this.getContainingNamespace();
        if (csmNamespace != null && this.startsWith(csmNamespace.getQualifiedName(), csmQualifiedNamedElement.getQualifiedName())) {
            return true;
        }
        CsmClass csmClass = this.getContainingClass();
        return csmClass != null && this.startsWith(csmClass.getQualifiedName(), csmQualifiedNamedElement.getQualifiedName());
    }

    private boolean startsWith(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence.length() < charSequence2.length()) {
            return false;
        }
        for (int i = 0; i < charSequence2.length(); ++i) {
            if (charSequence.charAt(i) == charSequence2.charAt(i)) continue;
            return false;
        }
        return charSequence.length() == charSequence2.length() || charSequence.charAt(charSequence2.length()) == ':';
    }

    private CsmDeclaration resolveUsingDeclaration(CsmUsingDeclaration csmUsingDeclaration) {
        CsmDeclaration csmDeclaration = null;
        if (csmUsingDeclaration instanceof UsingDeclarationImpl) {
            if (this.isRecursionOnResolving(5)) {
                return null;
            }
            csmDeclaration = ((UsingDeclarationImpl)csmUsingDeclaration).getReferencedDeclaration(this);
        }
        return csmDeclaration;
    }

    @Override
    public CsmObject resolve(CharSequence charSequence, int n) {
        return this.resolve(Utils.splitQualifiedName(((Object)charSequence).toString()), n);
    }

    @Override
    public CsmObject resolve(CharSequence[] charSequenceArray, int n) {
        Object object = null;
        this.names = charSequenceArray;
        this.currNamIdx = 0;
        this.interestedKind = n;
        CsmNamespace csmNamespace = null;
        if (charSequenceArray.length == 1) {
            Object object2;
            String string;
            Object object3;
            if (object == null && this.needClassifiers() && (object = this.findClassifier(csmNamespace = this.getContainingNamespace(), charSequenceArray[0])) == null && csmNamespace != null) {
                object3 = CsmUsingResolver.getDefault().findUsingDirectives(csmNamespace).iterator();
                while (object3.hasNext() && (object = this.findClassifier(string = (object2 = (CsmUsingDirective)object3.next()).getName() + "::" + charSequenceArray[0])) == null) {
                }
            }
            if (object == null && this.needClassifiers() && (object = this.resolveInClass((CsmClass)(object3 = this.getContainingClass()), charSequenceArray[0])) == null && (this.parentResolver == null || !((Resolver3)this.parentResolver).resolveInBaseClass)) {
                object = this.resolveInBaseClasses((CsmClass)object3, charSequenceArray[0]);
            }
            if (object == null && this.needNamespaces()) {
                if (this.getContainingNamespace() != null) {
                    object = this.findNamespace(this.getContainingNamespace().getQualifiedName() + "::" + charSequenceArray[0]);
                }
                if (object == null) {
                    object = this.findNamespace(charSequenceArray[0]);
                }
            }
            if (object == null && this.needClassifiers()) {
                object = this.findClassifier(charSequenceArray[0]);
            }
            if (object == null) {
                this.currTypedef = null;
                this.gatherMaps(this.file);
                if (this.currTypedef != null && this.needClassifiers() && (object3 = this.currTypedef.getType()) != null) {
                    object = this.getTypeClassifier((CsmType)object3);
                }
                if (object == null && (object3 = this.usingDeclarations.get(CharSequenceKey.create((CharSequence)charSequenceArray[0]))) != null) {
                    object = object3;
                }
                if (object == null && this.needClassifiers()) {
                    object3 = this.usedNamespaces.iterator();
                    while (object3.hasNext()) {
                        CsmNamespace csmNamespace2;
                        object2 = ((Object)((CharSequence)object3.next())).toString();
                        string = (String)object2 + "::" + charSequenceArray[0];
                        object = this.findClassifier(string);
                        if (object == null) {
                            object = this.findClassifier(csmNamespace, string);
                        }
                        if (object == null && (csmNamespace2 = this.findNamespace((CharSequence)object2)) != null) {
                            CsmUsingDirective csmUsingDirective;
                            Iterator iterator = CsmUsingResolver.getDefault().findUsingDirectives(csmNamespace2).iterator();
                            while (iterator.hasNext() && (object = this.findClassifier(string = (csmUsingDirective = (CsmUsingDirective)iterator.next()).getName() + "::" + charSequenceArray[0])) == null) {
                            }
                        }
                        if (object == null) continue;
                        break;
                    }
                }
                if (object == null && this.needNamespaces() && (object3 = this.namespaceAliases.get(CharSequenceKey.create((CharSequence)charSequenceArray[0]))) instanceof CsmNamespace) {
                    object = (CsmNamespace)object3;
                }
                if (object == null && this.needNamespaces()) {
                    object3 = this.usedNamespaces.iterator();
                    while (object3.hasNext() && (object = this.findNamespace(string = (String)(object2 = ((Object)((CharSequence)object3.next())).toString()) + "::" + charSequenceArray[0])) == null) {
                    }
                }
            }
        } else if (charSequenceArray.length > 1) {
            StringBuilder stringBuilder = new StringBuilder(charSequenceArray[0]);
            for (int i = 1; i < charSequenceArray.length; ++i) {
                stringBuilder.append("::");
                stringBuilder.append(charSequenceArray[i]);
            }
            if (this.needClassifiers()) {
                object = this.findClassifier(stringBuilder.toString());
            }
            if (object == null && this.needClassifiers()) {
                csmNamespace = this.getContainingNamespace();
                object = this.findClassifier(csmNamespace, stringBuilder.toString());
            }
            if (object == null && this.needNamespaces()) {
                object = this.findNamespace(stringBuilder.toString());
            }
            if (object == null && this.needClassifiers()) {
                CsmObject csmObject;
                String string;
                Object object4;
                CsmType csmType;
                this.gatherMaps(this.file);
                if (this.currTypedef != null && (csmType = this.currTypedef.getType()) != null) {
                    object4 = this.getTypeClassifier(csmType);
                    while (this.currNamIdx < this.names.length - 1 && object4 != null) {
                        ++this.currNamIdx;
                        if (!CsmKindUtilities.isTypedef((CsmObject)(object4 = this.findNestedClassifier((CsmClassifier)object4)))) continue;
                        string = ((CsmTypedef)object4).getType();
                        object4 = string == null ? null : this.getTypeClassifier((CsmType)string);
                    }
                    if (this.currNamIdx == this.names.length - 1) {
                        object = object4;
                    }
                }
                if (object == null) {
                    Iterator<CharSequence> iterator = this.usedNamespaces.iterator();
                    while (iterator.hasNext() && (object = this.findClassifier(string = (String)(object4 = ((Object)iterator.next()).toString()) + "::" + stringBuilder)) == null) {
                    }
                }
                if (object == null && (csmObject = new Resolver3(this.file, this.origOffset, this).resolve(charSequenceArray[0], 1)) != null) {
                    if (csmObject instanceof CsmNamespace) {
                        object4 = (NamespaceImpl)csmObject;
                        stringBuilder = new StringBuilder(((NamespaceImpl)object4).getQualifiedName());
                        for (int i = 1; i < charSequenceArray.length; ++i) {
                            stringBuilder.append("::");
                            stringBuilder.append(charSequenceArray[i]);
                        }
                        object = this.findClassifier(stringBuilder.toString());
                    } else if (csmObject instanceof CsmClass) {
                        // empty if block
                    }
                }
            }
        }
        return object;
    }

    private CsmClassifier getTypeClassifier(CsmType csmType) {
        if (csmType instanceof Resolver.SafeClassifierProvider) {
            if (this.isRecursionOnResolving(200)) {
                return null;
            }
            return ((Resolver.SafeClassifierProvider)csmType).getClassifier(this);
        }
        return csmType.getClassifier();
    }

    private CsmObject resolveInBaseClasses(CsmClass csmClass, CharSequence charSequence) {
        this.resolveInBaseClass = true;
        CsmObject csmObject = this._resolveInBaseClasses(csmClass, charSequence, new HashSet<CharSequence>(), 0);
        this.resolveInBaseClass = false;
        return csmObject;
    }

    private CsmObject _resolveInBaseClasses(CsmClass csmClass, CharSequence charSequence, Set<CharSequence> set, int n) {
        if (n == 50) {
            new Exception("Too many loops in resolver!!!").printStackTrace(System.err);
            return null;
        }
        if (csmClass != null && csmClass.isValid()) {
            List<CsmClass> list = this.getClassesContainers(csmClass);
            for (CsmClass csmClass2 : list) {
                for (CsmInheritance csmInheritance : csmClass2.getBaseClasses()) {
                    CsmClass csmClass3 = this.getInheritanceClass(csmInheritance);
                    if (csmClass3 == null || set.contains(csmClass3.getQualifiedName())) continue;
                    set.add(csmClass3.getQualifiedName());
                    CsmObject csmObject = this.resolveInClass(csmClass3, charSequence);
                    if (csmObject != null) {
                        return csmObject;
                    }
                    csmObject = this._resolveInBaseClasses(csmClass3, charSequence, set, n + 1);
                    if (csmObject == null) continue;
                    return csmObject;
                }
            }
        }
        return null;
    }

    private CsmClass getInheritanceClass(CsmInheritance csmInheritance) {
        if (csmInheritance instanceof InheritanceImpl) {
            if (this.isRecursionOnResolving(200)) {
                return null;
            }
            CsmClassifier csmClassifier = ((InheritanceImpl)csmInheritance).getClassifier(this);
            if (CsmKindUtilities.isClass((CsmObject)(csmClassifier = this.getOriginalClassifier(csmClassifier)))) {
                return (CsmClass)csmClassifier;
            }
        }
        return this.getCsmClass(csmInheritance);
    }

    private CsmClass getCsmClass(CsmInheritance csmInheritance) {
        CsmClassifier csmClassifier = csmInheritance instanceof Resolver.SafeClassifierProvider ? ((Resolver.SafeClassifierProvider)csmInheritance).getClassifier(this) : csmInheritance.getClassifier();
        if (CsmKindUtilities.isClass((CsmObject)(csmClassifier = this.getOriginalClassifier(csmClassifier)))) {
            return (CsmClass)csmClassifier;
        }
        return null;
    }

    private CsmObject resolveInClass(CsmClass csmClass, CharSequence charSequence) {
        if (csmClass != null && csmClass.isValid()) {
            List<CsmClass> list = this.getClassesContainers(csmClass);
            for (CsmClass csmClass2 : list) {
                String string = csmClass2.getQualifiedName() + "::" + charSequence;
                CsmClassifier csmClassifier = this.findClassifier(string);
                if (csmClassifier == null) continue;
                return csmClassifier;
            }
        }
        return null;
    }

    private List<CsmClass> getClassesContainers(CsmClass csmClass) {
        ArrayList<CsmClass> arrayList = new ArrayList<CsmClass>();
        CsmClass csmClass2 = csmClass;
        while (CsmKindUtilities.isClass((CsmObject)csmClass2)) {
            arrayList.add(csmClass2);
            csmClass2 = csmClass2.getScope();
        }
        return arrayList;
    }

    private boolean needClassifiers() {
        return (this.interestedKind & 2) == 2;
    }

    private boolean needNamespaces() {
        return (this.interestedKind & 1) == 1;
    }
}

