/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmIncludeResolver;
import org.netbeans.modules.cnd.modelimpl.csm.core.ResolverFactory;

public class ClassifierResolverImpl
extends CsmClassifierResolver {
    public CsmClassifier getOriginalClassifier(CsmClassifier csmClassifier) {
        if (csmClassifier instanceof CsmOffsetable) {
            return ResolverFactory.createResolver((CsmOffsetable)csmClassifier).getOriginalClassifier(csmClassifier);
        }
        return csmClassifier;
    }

    public CsmClassifier findClassifierUsedInFile(CharSequence charSequence, CsmFile csmFile, boolean bl) {
        CsmProject csmProject = csmFile.getProject();
        if (csmProject == null) {
            return null;
        }
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        CsmClassifier csmClassifier = this.findVisibleDeclaration(csmProject, charSequence, csmFile, atomicBoolean);
        if (atomicBoolean.get()) {
            assert (csmClassifier != null) : "how can visible be true without a result?";
            return csmClassifier;
        }
        for (CsmProject csmProject2 : csmProject.getLibraries()) {
            CsmClassifier csmClassifier2 = this.findVisibleDeclaration(csmProject2, charSequence, csmFile, atomicBoolean);
            if (atomicBoolean.get()) {
                return csmClassifier2;
            }
            if (csmClassifier != null) continue;
            csmClassifier = csmClassifier2;
        }
        return csmClassifier;
    }

    private CsmClassifier findVisibleDeclaration(CsmProject csmProject, CharSequence charSequence, CsmFile csmFile, AtomicBoolean atomicBoolean) {
        Collection collection = csmProject.findClassifiers(charSequence);
        CsmClassifier csmClassifier = null;
        for (CsmClassifier csmClassifier2 : collection) {
            if (csmClassifier == null) {
                csmClassifier = csmClassifier2;
            }
            if (!CsmIncludeResolver.getDefault().isObjectVisible(csmFile, (CsmObject)csmClassifier2)) continue;
            atomicBoolean.set(true);
            return csmClassifier2;
        }
        return csmClassifier;
    }
}

