/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.StartEntry;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTFindMacrosWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTFindUnusedBlocksWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.GuardBlockWalker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileInfoQueryImpl
extends CsmFileInfoQuery {
    public List<String> getSystemIncludePaths(CsmFile csmFile) {
        return this.getIncludePaths(csmFile, true);
    }

    public List<String> getUserIncludePaths(CsmFile csmFile) {
        return this.getIncludePaths(csmFile, false);
    }

    private List<String> getIncludePaths(CsmFile csmFile, boolean bl) {
        NativeFileItem nativeFileItem;
        List list = Collections.emptyList();
        if (csmFile instanceof FileImpl && (nativeFileItem = ProjectBase.getCompiledFileItem((FileImpl)csmFile)) != null) {
            if (nativeFileItem.getLanguage() == NativeFileItem.Language.C_HEADER) {
                NativeProject nativeProject = nativeFileItem.getNativeProject();
                if (nativeProject != null) {
                    list = bl ? nativeProject.getSystemIncludePaths() : nativeProject.getUserIncludePaths();
                }
            } else {
                list = bl ? nativeFileItem.getSystemIncludePaths() : nativeFileItem.getUserIncludePaths();
            }
        }
        return list;
    }

    public List<CsmOffsetable> getUnusedCodeBlocks(CsmFile csmFile) {
        List<CsmOffsetable> list = Collections.emptyList();
        if (csmFile instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)csmFile;
            try {
                APTFile aPTFile = APTDriver.getInstance().findAPTLight((APTFileBuffer)fileImpl.getBuffer());
                if (FileInfoQueryImpl.hasConditionalsDirectives(aPTFile)) {
                    Collection<APTPreprocHandler> collection = fileImpl.getPreprocHandlers();
                    if (collection.isEmpty()) {
                        DiagnosticExceptoins.register(new IllegalStateException("Empty preprocessor handlers for " + csmFile.getAbsolutePath()));
                        return Collections.emptyList();
                    }
                    if (collection.size() == 1) {
                        APTFindUnusedBlocksWalker aPTFindUnusedBlocksWalker = new APTFindUnusedBlocksWalker(aPTFile, fileImpl, collection.iterator().next());
                        aPTFindUnusedBlocksWalker.visit();
                        list = aPTFindUnusedBlocksWalker.getBlocks();
                    } else {
                        List<CsmOffsetable> list2 = new ArrayList<CsmOffsetable>();
                        boolean bl = true;
                        for (APTPreprocHandler aPTPreprocHandler : collection) {
                            APTFindUnusedBlocksWalker aPTFindUnusedBlocksWalker = new APTFindUnusedBlocksWalker(aPTFile, fileImpl, aPTPreprocHandler);
                            aPTFindUnusedBlocksWalker.visit();
                            List<CsmOffsetable> list3 = aPTFindUnusedBlocksWalker.getBlocks();
                            if (bl) {
                                list2 = list3;
                                bl = false;
                                continue;
                            }
                            if (!(list2 = FileInfoQueryImpl.intersection(list2, list3)).isEmpty()) continue;
                            break;
                        }
                        list = list2;
                    }
                }
            }
            catch (IOException iOException) {
                System.err.println("skip getting unused blocks\nreason:" + iOException.getMessage());
                DiagnosticExceptoins.register(iOException);
            }
        }
        return list;
    }

    private static boolean contains(CsmOffsetable csmOffsetable, CsmOffsetable csmOffsetable2) {
        return csmOffsetable != null && csmOffsetable2 != null && csmOffsetable.getStartOffset() <= csmOffsetable2.getStartOffset() && csmOffsetable2.getEndOffset() <= csmOffsetable.getEndOffset();
    }

    private static List<CsmOffsetable> intersection(Collection<CsmOffsetable> collection, Collection<CsmOffsetable> collection2) {
        ArrayList<CsmOffsetable> arrayList = new ArrayList<CsmOffsetable>(Math.max(collection.size(), collection2.size()));
        for (CsmOffsetable csmOffsetable : collection) {
            for (CsmOffsetable csmOffsetable2 : collection2) {
                if (csmOffsetable == null) continue;
                if (csmOffsetable.equals(csmOffsetable2)) {
                    arrayList.add(csmOffsetable);
                    continue;
                }
                if (FileInfoQueryImpl.contains(csmOffsetable, csmOffsetable2)) {
                    arrayList.add(csmOffsetable2);
                    continue;
                }
                if (!FileInfoQueryImpl.contains(csmOffsetable2, csmOffsetable)) continue;
                arrayList.add(csmOffsetable);
            }
        }
        return arrayList;
    }

    private static boolean hasConditionalsDirectives(APTFile aPTFile) {
        if (aPTFile == null) {
            return false;
        }
        for (APT aPT = aPTFile.getFirstChild(); aPT != null; aPT = aPT.getNextSibling()) {
            if (aPT.getType() == 7) {
                return true;
            }
            assert (aPT.getFirstChild() == null);
        }
        return false;
    }

    public List<CsmReference> getMacroUsages(CsmFile csmFile) {
        List<CsmReference> list = Collections.emptyList();
        if (csmFile instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)csmFile;
            List<CsmReference> list2 = fileImpl.getLastMacroUsages();
            if (list2 != null) {
                return list2;
            }
            try {
                long l = fileImpl.getLastParsedTime();
                APTFile aPTFile = APTDriver.getInstance().findAPT((APTFileBuffer)fileImpl.getBuffer());
                if (aPTFile != null) {
                    Collection<APTPreprocHandler> collection = fileImpl.getPreprocHandlers();
                    if (collection.isEmpty()) {
                        DiagnosticExceptoins.register(new IllegalStateException("Empty preprocessor handlers for " + csmFile.getAbsolutePath()));
                        return Collections.emptyList();
                    }
                    if (collection.size() == 1) {
                        APTFindMacrosWalker aPTFindMacrosWalker = new APTFindMacrosWalker(aPTFile, fileImpl, collection.iterator().next());
                        aPTFindMacrosWalker.getTokenStream();
                        list = aPTFindMacrosWalker.getCollectedData();
                    } else {
                        OffsetableComparator offsetableComparator = new OffsetableComparator();
                        TreeSet treeSet = new TreeSet(offsetableComparator);
                        for (APTPreprocHandler aPTPreprocHandler : collection) {
                            APTFindMacrosWalker aPTFindMacrosWalker = new APTFindMacrosWalker(aPTFile, fileImpl, aPTPreprocHandler);
                            aPTFindMacrosWalker.getTokenStream();
                            treeSet.addAll(aPTFindMacrosWalker.getCollectedData());
                        }
                        list = new ArrayList(treeSet);
                    }
                }
                if (l == fileImpl.getLastParsedTime()) {
                    fileImpl.setLastMacroUsages(list);
                }
            }
            catch (IOException iOException) {
                System.err.println("skip marking macros\nreason:" + iOException.getMessage());
                DiagnosticExceptoins.register(iOException);
            }
        }
        return list;
    }

    public CsmOffsetable getGuardOffset(CsmFile csmFile) {
        if (csmFile instanceof FileImpl) {
            FileImpl fileImpl = (FileImpl)csmFile;
            try {
                Token token;
                APTFile aPTFile = APTDriver.getInstance().findAPT((APTFileBuffer)fileImpl.getBuffer());
                GuardBlockWalker guardBlockWalker = new GuardBlockWalker(aPTFile, fileImpl.getPreprocHandler());
                TokenStream tokenStream = guardBlockWalker.getTokenStream();
                try {
                    token = tokenStream.nextToken();
                    while (!APTUtils.isEOF((Token)token)) {
                        if (!APTUtils.isCommentToken((Token)token)) {
                            guardBlockWalker.clearGuard();
                            break;
                        }
                        token = tokenStream.nextToken();
                    }
                }
                catch (TokenStreamException tokenStreamException) {
                    guardBlockWalker.clearGuard();
                }
                token = guardBlockWalker.getGuard();
                if (token != null && token instanceof APTToken) {
                    APTToken aPTToken = (APTToken)token;
                    return new OffsetableBase(csmFile, aPTToken.getOffset(), aPTToken.getEndOffset());
                }
            }
            catch (IOException iOException) {
                System.err.println("IOExeption in getGuardOffset:" + iOException.getMessage());
            }
        }
        return null;
    }

    public NativeFileItem getNativeFileItem(CsmFile csmFile) {
        if (csmFile instanceof FileImpl) {
            return ((FileImpl)csmFile).getNativeFileItem();
        }
        return null;
    }

    public List<CsmInclude> getIncludeStack(CsmFile csmFile) {
        if (csmFile instanceof FileImpl) {
            FileImpl fileImpl;
            FileImpl fileImpl2 = (FileImpl)csmFile;
            APTPreprocHandler.State state = ((ProjectBase)fileImpl2.getProject()).getPreprocState(fileImpl2);
            List list = APTHandlersSupport.extractIncludeStack((APTPreprocHandler.State)state);
            StartEntry startEntry = APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state);
            ProjectBase projectBase = ProjectBase.getStartProject(startEntry);
            if (projectBase != null && (fileImpl = projectBase.getFile(new File(startEntry.getStartFile()))) != null) {
                ArrayList<CsmInclude> arrayList = new ArrayList<CsmInclude>();
                for (APTIncludeHandler.IncludeInfo includeInfo : list) {
                    int n = includeInfo.getIncludeDirectiveLine();
                    CsmInclude csmInclude = null;
                    for (CsmInclude csmInclude2 : fileImpl.getIncludes()) {
                        if (n != csmInclude2.getEndPosition().getLine()) continue;
                        csmInclude = csmInclude2;
                        break;
                    }
                    if (csmInclude == null) break;
                    arrayList.add(csmInclude);
                    fileImpl = csmInclude.getIncludeFile();
                    if (fileImpl != null) continue;
                    break;
                }
                return arrayList;
            }
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OffsetableComparator<T extends CsmOffsetable>
    implements Comparator<T> {
        private OffsetableComparator() {
        }

        @Override
        public int compare(CsmOffsetable csmOffsetable, CsmOffsetable csmOffsetable2) {
            int n = csmOffsetable.getStartOffset() - csmOffsetable2.getStartOffset();
            if (n == 0) {
                return csmOffsetable.getEndOffset() - csmOffsetable2.getEndOffset();
            }
            return n;
        }
    }
}

