/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTMacroExpandedStream;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.IncludeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.SimpleOffsetableImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTProjectFileBasedWalker;

public class APTParseFileWalker
extends APTProjectFileBasedWalker {
    private boolean createMacroAndIncludes = false;
    private final EvalCallback evalCallback;

    public APTParseFileWalker(ProjectBase projectBase, APTFile aPTFile, FileImpl fileImpl, APTPreprocHandler aPTPreprocHandler) {
        this(projectBase, aPTFile, fileImpl, aPTPreprocHandler, null);
    }

    public APTParseFileWalker(ProjectBase projectBase, APTFile aPTFile, FileImpl fileImpl, APTPreprocHandler aPTPreprocHandler, EvalCallback evalCallback) {
        super(projectBase, aPTFile, fileImpl, aPTPreprocHandler);
        this.evalCallback = evalCallback;
    }

    public void addMacroAndIncludes(boolean bl) {
        this.createMacroAndIncludes = bl;
    }

    protected boolean needMacroAndIncludes() {
        return this.createMacroAndIncludes;
    }

    public TokenStream getFilteredTokenStream(APTLanguageFilter aPTLanguageFilter) {
        return aPTLanguageFilter.getFilteredStream(this.getTokenStream());
    }

    public TokenStream getTokenStream() {
        this.setMode(1);
        TokenStream tokenStream = super.getTokenStream();
        tokenStream = new APTCommentsFilter(tokenStream);
        tokenStream = new APTMacroExpandedStream(tokenStream, (APTMacroCallback)this.getMacroMap());
        return tokenStream;
    }

    protected void onDefine(APT aPT) {
        super.onDefine(aPT);
        if (this.needMacroAndIncludes()) {
            this.getFile().addMacro(this.createMacro((APTDefine)aPT));
        }
    }

    protected void postInclude(APTInclude aPTInclude, FileImpl fileImpl) {
        if (this.needMacroAndIncludes()) {
            this.getFile().addInclude(this.createInclude(aPTInclude, fileImpl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FileImpl includeAction(ProjectBase projectBase, String string, int n, APTInclude aPTInclude) throws IOException {
        try {
            FileImpl fileImpl = projectBase.onFileIncluded(this.getStartProject(), string, this.getPreprocHandler(), n);
            return fileImpl;
        }
        catch (NullPointerException nullPointerException) {
            APTUtils.LOG.log(Level.SEVERE, "NPE when processing file", nullPointerException);
            DiagnosticExceptoins.register(nullPointerException);
        }
        finally {
            this.getIncludeHandler().popInclude();
        }
        return null;
    }

    private MacroImpl createMacro(APTDefine aPTDefine) {
        APTToken aPTToken;
        List list2;
        ArrayList<String> arrayList = null;
        Collection collection = aPTDefine.getParams();
        if (collection != null) {
            arrayList = new ArrayList<String>();
            for (List list2 : collection) {
                if (!APTUtils.isID((Token)list2)) continue;
                arrayList.add(list2.getText());
            }
        }
        SimpleOffsetableImpl simpleOffsetableImpl = this.getOffsetable((APTToken)aPTDefine.getToken());
        list2 = aPTDefine.getBody();
        String string = "";
        if (list2.isEmpty()) {
            aPTToken = (APTToken)aPTDefine.getName();
        } else {
            aPTToken = (APTToken)list2.get(list2.size() - 1);
            APTToken aPTToken2 = (APTToken)list2.get(0);
            string = "";
        }
        this.setEndPosition(simpleOffsetableImpl, aPTToken);
        return new MacroImpl(aPTDefine.getName().getText(), arrayList, string, this.getFile(), simpleOffsetableImpl);
    }

    private IncludeImpl createInclude(APTInclude aPTInclude, FileImpl fileImpl) {
        SimpleOffsetableImpl simpleOffsetableImpl = this.getOffsetable((APTToken)aPTInclude.getToken());
        this.setEndPosition(simpleOffsetableImpl, this.getLastToken(aPTInclude.getInclude()));
        IncludeImpl includeImpl = new IncludeImpl(aPTInclude.getFileName((APTMacroCallback)this.getMacroMap()), aPTInclude.isSystem((APTMacroCallback)this.getMacroMap()), fileImpl, this.getFile(), simpleOffsetableImpl);
        return includeImpl;
    }

    private SimpleOffsetableImpl getOffsetable(APTToken aPTToken) {
        return new SimpleOffsetableImpl(aPTToken.getLine(), aPTToken.getColumn(), aPTToken.getOffset());
    }

    private void setEndPosition(SimpleOffsetableImpl simpleOffsetableImpl, APTToken aPTToken) {
        if (aPTToken != null && !APTUtils.isEOF((Token)aPTToken)) {
            simpleOffsetableImpl.setEndPosition(aPTToken.getEndLine(), aPTToken.getEndColumn(), aPTToken.getEndOffset());
        } else {
            assert (simpleOffsetableImpl.getStartPosition() != null);
            simpleOffsetableImpl.setEndPosition(simpleOffsetableImpl.getStartPosition());
        }
    }

    private APTToken getLastToken(TokenStream tokenStream) {
        try {
            Token token = tokenStream.nextToken();
            Token token2 = null;
            while (!APTUtils.isEOF((Token)(token2 = tokenStream.nextToken()))) {
                token = token2;
            }
            return (APTToken)token;
        }
        catch (TokenStreamException tokenStreamException) {
            DiagnosticExceptoins.register(tokenStreamException);
            return null;
        }
    }

    protected void onEval(APT aPT, boolean bl) {
        if (this.evalCallback != null) {
            this.evalCallback.onEval(aPT, bl);
        }
    }

    public static interface EvalCallback {
        public void onEval(APT var1, boolean var2);
    }
}

