/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib;

import com.sun.rave.designtime.DisplayItem;
import com.sun.rave.designtime.impl.BasicBeanCreateInfo;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.SimpleBeanInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.netbeans.modules.visualweb.complib.Complib;
import org.netbeans.modules.visualweb.complib.ComplibServiceProvider;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.XmlUtil;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ComplibPaletteItemDataObject
extends MultiDataObject {
    private static final String ELM_COMPLIB_ITEM = "complibItem";
    private static final String ATTR_VERSION = "version";
    private static final String ELM_COMPONENT = "component";
    private static final String ATTR_CLASSNAME = "className";
    private static final String ATTR_COMPLIB_VERSION = "complibVersion";
    private static final String ATTR_COMPLIB_NAMESPACE = "complibNamespace";
    private static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    private boolean fileLoaded;
    private BeanInfo beanInfo;
    private String className;
    private Complib complib;

    ComplibPaletteItemDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws IOException {
        super(fileObject, multiFileLoader);
    }

    public Node createNodeDelegate() {
        return new ItemNode();
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    public Complib getComplib() {
        this.loadFile();
        return this.complib;
    }

    private BeanInfo getComponentBeanInfo() {
        if (this.beanInfo == null) {
            Complib complib = this.getComplib();
            if (complib == null) {
                this.beanInfo = this.getFallbackBeanInfo();
            } else {
                try {
                    this.beanInfo = complib.getBeanInfo(this.className);
                }
                catch (Exception exception) {
                    IdeUtil.logError(exception);
                    this.beanInfo = this.getFallbackBeanInfo();
                }
            }
        }
        return this.beanInfo;
    }

    private BeanInfo getFallbackBeanInfo() {
        this.beanInfo = UnknownBeanInfo.getInstance();
        FileObject fileObject = this.getPrimaryFile();
        try {
            fileObject.delete();
        }
        catch (IOException iOException) {
            IdeUtil.logWarning("Unable to remove FileObject '" + fileObject.getNameExt() + "'", iOException);
        }
        return this.beanInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadFile() {
        if (this.fileLoaded) {
            return;
        }
        Class<?> clazz = ((Object)((Object)this)).getClass();
        synchronized (clazz) {
            Object object;
            Object object2;
            PaletteItemHandler paletteItemHandler = null;
            try {
                object2 = XMLUtil.createXMLReader();
                paletteItemHandler = new PaletteItemHandler();
                object2.setContentHandler(paletteItemHandler);
                object = new InputSource(this.getPrimaryFile().getURL().toExternalForm());
                object2.parse((InputSource)object);
            }
            catch (SAXException sAXException) {
                ErrorManager.getDefault().notify(1, (Throwable)sAXException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            this.className = paletteItemHandler.getClassName();
            object2 = paletteItemHandler.getNamespace();
            object = paletteItemHandler.getVersion();
            this.complib = ComplibServiceProvider.getInstance().getInstalledComplib((String)object2, (String)object);
            this.fileLoaded = true;
        }
    }

    public String getClassName() {
        this.loadFile();
        return this.className;
    }

    static synchronized FileObject createFile(FileObject fileObject, String string, String string2, String string3) throws IOException {
        String string4 = "complib_item";
        String string5 = FileUtil.findFreeFileName((FileObject)fileObject, (String)IdeUtil.baseClassName(string), (String)string4);
        XmlUtil xmlUtil = new XmlUtil();
        Document document = xmlUtil.createDocument();
        Element element = document.createElement(ELM_COMPLIB_ITEM);
        element.setAttribute(ATTR_VERSION, "1.0");
        document.appendChild(element);
        Element element2 = document.createElement(ELM_COMPONENT);
        element2.setAttribute(ATTR_CLASSNAME, string);
        element2.setAttribute(ATTR_COMPLIB_NAMESPACE, string2);
        element2.setAttribute(ATTR_COMPLIB_VERSION, string3);
        element.appendChild(element2);
        FileObject fileObject2 = fileObject.createData(string5, string4);
        File file = FileUtil.toFile((FileObject)fileObject2);
        xmlUtil.write(file);
        return fileObject2;
    }

    private static void hackExplorerDnD(ItemNode itemNode, Transferable transferable) {
        Object object = ComplibPaletteItemDataObject.getExplorerDnDManager();
        if (object != null) {
            ComplibPaletteItemDataObject.setNodeAllowedActions(object, 2);
            ComplibPaletteItemDataObject.setDraggedTransferable(object, transferable, true);
            ComplibPaletteItemDataObject.setDraggedNodes(object, new Node[]{itemNode});
            ComplibPaletteItemDataObject.setDnDActive(object, true);
        }
    }

    private static void setNodeAllowedActions(Object object, int n) {
        ComplibPaletteItemDataObject.invokeOnExplorerDnDManager(object, "setNodeAllowedActions", new Class[]{Integer.TYPE}, new Object[]{n});
    }

    private static void setDraggedTransferable(Object object, Transferable transferable, boolean bl) {
        ComplibPaletteItemDataObject.invokeOnExplorerDnDManager(object, "setDraggedTransferable", new Class[]{Transferable.class, Boolean.TYPE}, new Object[]{transferable, bl});
    }

    private static void setDraggedNodes(Object object, Node[] nodeArray) {
        ComplibPaletteItemDataObject.invokeOnExplorerDnDManager(object, "setDraggedNodes", new Class[]{Node[].class}, new Object[]{nodeArray});
    }

    private static void setDnDActive(Object object, boolean bl) {
        ComplibPaletteItemDataObject.invokeOnExplorerDnDManager(object, "setDnDActive", new Class[]{Boolean.TYPE}, new Object[]{bl});
    }

    private static Object getExplorerDnDManager() {
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        try {
            Class<?> clazz = Class.forName("org.openide.explorer.view.ExplorerDnDManager", true, classLoader);
            Method method = clazz.getDeclaredMethod("getDefault", new Class[0]);
            method.setAccessible(true);
            return method.invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(1, (Throwable)invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalAccessException);
        }
        catch (SecurityException securityException) {
            ErrorManager.getDefault().notify(1, (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify(1, (Throwable)noSuchMethodException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ErrorManager.getDefault().notify(1, (Throwable)classNotFoundException);
        }
        return null;
    }

    private static void invokeOnExplorerDnDManager(Object object, String string, Class[] classArray, Object[] objectArray) {
        try {
            Method method = object.getClass().getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            method.invoke(object, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ErrorManager.getDefault().notify(1, (Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(1, (Throwable)invocationTargetException);
        }
        catch (SecurityException securityException) {
            ErrorManager.getDefault().notify(1, (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ErrorManager.getDefault().notify(1, (Throwable)noSuchMethodException);
        }
    }

    private static class UnknownBeanDescriptor
    extends BeanDescriptor {
        public UnknownBeanDescriptor() {
            super(Object.class);
        }

        public String getDisplayName() {
            return "Unknown";
        }

        public String getShortDescription() {
            return "Unknown short description";
        }
    }

    private static class UnknownBeanInfo
    extends SimpleBeanInfo {
        private BeanDescriptor beanDescriptor;
        private static final UnknownBeanInfo INSTANCE = new UnknownBeanInfo();

        private UnknownBeanInfo() {
        }

        public static UnknownBeanInfo getInstance() {
            return INSTANCE;
        }

        public BeanDescriptor getBeanDescriptor() {
            if (this.beanDescriptor == null) {
                this.beanDescriptor = new UnknownBeanDescriptor();
            }
            return this.beanDescriptor;
        }

        public Image getIcon(int n) {
            return ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/palette/resources/custom_component.png");
        }
    }

    private class PaletteItemHandler
    extends DefaultHandler {
        private String className;
        private String namespace;
        private String version;

        private PaletteItemHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (ComplibPaletteItemDataObject.ELM_COMPLIB_ITEM.equals(string3)) {
                String string4 = attributes.getValue(ComplibPaletteItemDataObject.ATTR_VERSION);
                if (string4 == null) {
                    String string5 = NbBundle.getBundle(ComplibPaletteItemDataObject.class).getString("MSG_UnknownPaletteItemVersion");
                    throw new SAXException(string5);
                }
                if (!string4.startsWith("1.")) {
                    String string6 = NbBundle.getBundle(ComplibPaletteItemDataObject.class).getString("MSG_UnsupportedPaletteItemVersion");
                    throw new SAXException(string6);
                }
            } else if (ComplibPaletteItemDataObject.ELM_COMPONENT.equals(string3)) {
                this.className = attributes.getValue(ComplibPaletteItemDataObject.ATTR_CLASSNAME);
                this.namespace = attributes.getValue(ComplibPaletteItemDataObject.ATTR_COMPLIB_NAMESPACE);
                this.version = attributes.getValue(ComplibPaletteItemDataObject.ATTR_COMPLIB_VERSION);
            }
        }

        public String getClassName() {
            return this.className;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getVersion() {
            return this.version;
        }
    }

    class ItemNode
    extends DataNode {
        ItemNode() {
            super((DataObject)ComplibPaletteItemDataObject.this, Children.LEAF);
        }

        public String getDisplayName() {
            BeanInfo beanInfo = ComplibPaletteItemDataObject.this.getComponentBeanInfo();
            return beanInfo == null ? "Unknown" : beanInfo.getBeanDescriptor().getDisplayName();
        }

        public String getShortDescription() {
            BeanInfo beanInfo = ComplibPaletteItemDataObject.this.getComponentBeanInfo();
            return beanInfo == null ? "Unknown" : beanInfo.getBeanDescriptor().getShortDescription();
        }

        public boolean canRename() {
            return false;
        }

        public Image getIcon(int n) {
            Image image;
            BeanInfo beanInfo = ComplibPaletteItemDataObject.this.getComponentBeanInfo();
            Image image2 = image = beanInfo == null ? null : beanInfo.getIcon(n);
            if (image == null) {
                image = ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/palette/resources/custom_component.png");
            }
            return image;
        }

        public Node.PropertySet[] getPropertySets() {
            return NO_PROPERTIES;
        }

        public Transferable clipboardCopy() throws IOException {
            Transferable transferable = super.clipboardCopy();
            this.addPaletteFlavor(transferable);
            return transferable;
        }

        public Transferable clipboardCut() throws IOException {
            Transferable transferable = super.clipboardCut();
            this.addPaletteFlavor(transferable);
            return transferable;
        }

        public Transferable drag() throws IOException {
            Transferable transferable = super.drag();
            this.addPaletteFlavor(transferable);
            ComplibPaletteItemDataObject.hackExplorerDnD(this, transferable);
            return transferable;
        }

        private Transferable addPaletteFlavor(Transferable transferable) {
            ExTransferable exTransferable = ExTransferable.create((Transferable)transferable);
            String string = NbBundle.getMessage(ComplibPaletteItemDataObject.class, (String)"humanName");
            DataFlavor dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref; class=" + DisplayItem.class.getName(), string);
            ExTransferable.Single single = new ExTransferable.Single(dataFlavor){

                protected Object getData() throws IOException, UnsupportedFlavorException {
                    return new BasicBeanCreateInfo(ComplibPaletteItemDataObject.this.getClassName(), ItemNode.this.getDisplayName());
                }
            };
            exTransferable.put(single);
            return transferable;
        }
    }

    public static final class PaletteItemDataLoaderBeanInfo
    extends SimpleBeanInfo {
        private static String iconURL = "org/netbeans/modules/form/resources/palette_manager.png";

        public BeanInfo[] getAdditionalBeanInfo() {
            try {
                return new BeanInfo[]{Introspector.getBeanInfo(UniFileLoader.class)};
            }
            catch (IntrospectionException introspectionException) {
                ErrorManager.getDefault().notify((Throwable)introspectionException);
                return null;
            }
        }

        public Image getIcon(int n) {
            return ImageUtilities.loadImage((String)iconURL);
        }
    }

    public static final class PaletteItemDataLoader
    extends UniFileLoader {
        static final String ITEM_EXT = "complib_item";

        PaletteItemDataLoader() {
            super(ComplibPaletteItemDataObject.class.getName());
            ExtensionList extensionList = new ExtensionList();
            this.getExtensions().addMimeType("text/x-complib-palette+xml");
        }

        protected String defaultDisplayName() {
            return NbBundle.getBundle(ComplibPaletteItemDataObject.class).getString("PROP_PaletteItemLoader_Name");
        }

        protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
            return new ComplibPaletteItemDataObject(fileObject, (MultiFileLoader)this);
        }
    }
}

