/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib;

import com.sun.rave.designtime.BeanCreateInfo;
import com.sun.rave.designtime.BeanCreateInfoSet;
import com.sun.rave.designtime.DisplayItem;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.visualweb.complib.Complib;
import org.netbeans.modules.visualweb.complib.ComplibManifest;
import org.netbeans.modules.visualweb.complib.ComplibPackage;
import org.netbeans.modules.visualweb.complib.ComplibPaletteItemDataObject;
import org.netbeans.modules.visualweb.complib.ExtensionComplib;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.JavaHelpStorage;
import org.netbeans.modules.visualweb.complib.LibraryLocalizationBundle;
import org.netbeans.modules.visualweb.complib.PaletteUtil;
import org.netbeans.modules.visualweb.complib.Scope;
import org.netbeans.modules.visualweb.complib.SharedComplib;
import org.netbeans.modules.visualweb.complib.Version;
import org.netbeans.modules.visualweb.complib.api.ComplibEvent;
import org.netbeans.modules.visualweb.complib.api.ComplibException;
import org.netbeans.modules.visualweb.complib.api.ComplibListener;
import org.netbeans.modules.visualweb.complib.api.ComplibService;
import org.netbeans.modules.visualweb.complib.ui.ComplibsRootNode;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteFilter;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplibServiceProvider
implements ComplibService {
    private static final String ATTR_MIGRATION_VERSION = "org-netbeans-modules-visualweb-complib_migration-version";
    public static final String ADDABLE_COMPLIBS = "addableComplibs";
    private static final File complibsToInstallDir = new File(IdeUtil.getNetBeansInstallDirectory(), "complibs_to_install");
    private static final String COMPLIB_EXTENSION = "complib";
    private static final ComponentInfo[] EMPTY_COMPONENT_INFO_ARRAY = new ComponentInfo[0];
    private EventListenerList listenerList = new EventListenerList();
    private PropertyChangeSupport pceListeners = new PropertyChangeSupport(this);
    private Scope userScope;
    private Preferences preferences;

    public static ComplibServiceProvider getInstance() {
        return (ComplibServiceProvider)Lookup.getDefault().lookup(ComplibService.class);
    }

    public ComplibServiceProvider() throws IOException {
        this.initUserScope();
        this.installNewComplibPackages(complibsToInstallDir);
    }

    private void initUserScope() throws IOException {
        File file;
        String string;
        File file2 = new File(IdeUtil.getComplibStateDir(), "installed-complibs");
        if (!file2.isDirectory() && (string = System.getProperty("netbeans.user")) != null && (file = new File(string, "complibs")).exists()) {
            IdeUtil.copyFileRecursive(file, file2);
            if (!IdeUtil.deleteRecursive(file)) {
                IdeUtil.logWarning("Unable to remove directory: " + file);
            }
        }
        this.userScope = Scope.createScope(file2);
    }

    private void initSharedComplibs(Set<Project> set) {
        for (Project project : set) {
            SharedComplibState.getInstance().getSharedComplibs(project);
        }
    }

    private Set<Project> getOpenRaveProjects() {
        Project[] projectArray;
        HashSet<Project> hashSet = new HashSet<Project>();
        for (Project project : projectArray = OpenProjects.getDefault().getOpenProjects()) {
            if (!JsfProjectUtils.isJsfProject((Project)project)) continue;
            hashSet.add(project);
        }
        return hashSet;
    }

    private void ensureProjectComplibsAreInstalled(Set<ExtensionComplib> set) {
        ArrayList<ExtensionComplib> arrayList = new ArrayList<ExtensionComplib>();
        for (ExtensionComplib object : set) {
            if (this.userScope.contains(object)) continue;
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            return;
        }
        String string = NbBundle.getMessage(ComplibServiceProvider.class, (String)"complib.initProjectComplibs");
        IdeUtil.getLogger().log(Level.INFO, string);
        for (ExtensionComplib extensionComplib : arrayList) {
            try {
                this.installProjectComplib(extensionComplib);
            }
            catch (Exception exception) {
                IdeUtil.logWarning(exception);
            }
        }
    }

    private void addLibraryRefAndDef(Project project, ExtensionComplib extensionComplib) throws IOException {
        String string = this.deriveUniqueLibraryName(extensionComplib);
        Library library = LibraryManager.getDefault().getLibrary(string);
        if (library == null) {
            library = this.createUserScopeLibDef(extensionComplib);
        }
        JsfProjectUtils.addLibraryReferences((Project)project, (Library[])new Library[]{library});
    }

    private String deriveUniqueLibraryName(ExtensionComplib extensionComplib) {
        return extensionComplib.getDirectoryBaseName();
    }

    private List<URL> fileListToUrlList(List<File> list) throws MalformedURLException {
        ArrayList<URL> arrayList = new ArrayList<URL>(list.size());
        for (File file : list) {
            arrayList.add(file.toURI().toURL());
        }
        return arrayList;
    }

    private void installNewComplibPackages(final File file) {
        if (file == null || !file.exists()) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                long l = ComplibServiceProvider.this.userScope.getLastModified();
                FileObject fileObject = FileUtil.toFileObject((File)file);
                FileObject[] fileObjectArray = fileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    FileObject fileObject2 = fileObjectArray[i];
                    File file2 = FileUtil.toFile((FileObject)fileObject2);
                    if (!ComplibServiceProvider.COMPLIB_EXTENSION.equals(fileObject2.getExt()) || file2.lastModified() <= l) continue;
                    try {
                        ComplibPackage complibPackage = new ComplibPackage(file2);
                        ComplibServiceProvider.this.installComplibPackage(complibPackage);
                        continue;
                    }
                    catch (Exception exception) {
                        IdeUtil.logError(exception);
                    }
                }
            }
        });
    }

    public ArrayList<Complib> getInstalledComplibs() {
        ArrayList<Complib> arrayList = new ArrayList<Complib>();
        arrayList.addAll(this.userScope.getComplibs());
        return arrayList;
    }

    private Complib getInstalledComplib(Complib.Identifier identifier) {
        Set<ExtensionComplib> set = this.userScope.getComplibs();
        for (ExtensionComplib object2 : set) {
            if (!object2.getIdentifier().equals(identifier)) continue;
            return object2;
        }
        HashSet<SharedComplib> hashSet = SharedComplibState.getInstance().getAllSharedComplibs();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            SharedComplib sharedComplib = (SharedComplib)iterator.next();
            if (!sharedComplib.getIdentifier().equals(identifier)) continue;
            return sharedComplib;
        }
        return null;
    }

    public void installComplibFile(File file, boolean bl) throws ComplibException {
        try {
            ComplibPackage complibPackage = new ComplibPackage(file);
            if (this.isInstalled(complibPackage) && !bl) {
                return;
            }
            this.installComplibPackage(complibPackage);
        }
        catch (IOException iOException) {
            throw new ComplibException("Unable to install complib file", (Throwable)iOException);
        }
    }

    public ExtensionComplib installComplibPackage(ComplibPackage complibPackage) throws ComplibException, IOException {
        Complib.Identifier identifier = complibPackage.getIdentifer();
        this.removeExistingInstalledComplib(identifier);
        ExtensionComplib extensionComplib = this.userScope.installComplibPackage(complibPackage);
        this.finishInstallToUserScope(extensionComplib);
        return extensionComplib;
    }

    private void installProjectComplib(ExtensionComplib extensionComplib) throws ComplibException, IOException {
        Complib.Identifier identifier = extensionComplib.getIdentifier();
        this.removeExistingInstalledComplib(identifier);
        ExtensionComplib extensionComplib2 = this.userScope.installComplib(extensionComplib);
        this.finishInstallToUserScope(extensionComplib2);
    }

    private void finishInstallToUserScope(ExtensionComplib extensionComplib) throws ComplibException, IOException, MalformedURLException {
        try {
            this.addToPalette(extensionComplib);
        }
        catch (ComplibException complibException) {
            this.remove(extensionComplib);
            throw complibException;
        }
        JavaHelpStorage.installComplibHelp(extensionComplib);
        this.createUserScopeLibDef(extensionComplib);
        this.fireAddableComplibsChanged(this.userScope);
    }

    private Library createUserScopeLibDef(ExtensionComplib extensionComplib) throws IOException, MalformedURLException {
        String string = this.deriveUniqueLibraryName(extensionComplib);
        Library library = LibraryManager.getDefault().getLibrary(string);
        if (library != null) {
            JsfProjectUtils.removeLibrary((String)string);
        }
        String string2 = extensionComplib.getVersionedTitle();
        LibraryLocalizationBundle.add(string, string2);
        String string3 = LibraryLocalizationBundle.class.getName();
        List<URL> list = this.fileListToUrlList(extensionComplib.getRuntimePath());
        List<URL> list2 = this.fileListToUrlList(extensionComplib.getDesignTimePath());
        List<URL> list3 = this.fileListToUrlList(extensionComplib.getJavadocPath());
        List<URL> list4 = this.fileListToUrlList(extensionComplib.getSourcePath());
        return JsfProjectUtils.createComponentLibrary((String)string, (String)string, (String)string3, list, list4, list3, list2);
    }

    private void removeExistingInstalledComplib(Complib.Identifier identifier) throws ComplibException {
        Complib complib = this.getInstalledComplib(identifier);
        if (complib != null) {
            if (complib instanceof ExtensionComplib) {
                ExtensionComplib extensionComplib = (ExtensionComplib)complib;
                this.remove(extensionComplib);
            } else {
                throw new ComplibException("Cannot install non-extension complib with identifier: " + identifier);
            }
        }
    }

    private void addToPalette(Complib complib) throws ComplibException {
        List<PaletteUtil.Palette> list = PaletteUtil.getPaletteRoots(complib);
        List<Complib.InitialPaletteFolder> list2 = complib.getComponentItemsInFolders();
        Collections.reverse(list2);
        for (Complib.InitialPaletteFolder initialPaletteFolder : list2) {
            String string = initialPaletteFolder.getName();
            for (PaletteUtil.Palette palette : list) {
                PaletteUtil.Category category = palette.getOrCreateCategory(string);
                for (Complib.InitialPaletteItem initialPaletteItem : initialPaletteFolder.getChildren()) {
                    this.mayBeCreatePaletteItemRecurse(category, complib, initialPaletteItem);
                }
            }
        }
        this.firePaletteChanged(new ComplibEvent((Object)complib));
    }

    private void mayBeCreatePaletteItemRecurse(PaletteUtil.Category category, Complib complib, Complib.InitialPaletteItem initialPaletteItem) {
        Object object;
        String string = initialPaletteItem.getClassName();
        if (complib.isHidden(string)) {
            return;
        }
        try {
            object = new ComponentInfo(string, complib);
            category.createItem((ComponentInfo)object);
        }
        catch (Exception exception) {
            IdeUtil.logWarning(exception);
            return;
        }
        object = initialPaletteItem.getChildren();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Complib.InitialPaletteItem initialPaletteItem2 = (Complib.InitialPaletteItem)iterator.next();
            this.mayBeCreatePaletteItemRecurse(category, complib, initialPaletteItem2);
        }
    }

    public void remove(ExtensionComplib extensionComplib) {
        this.removeFromPaletteCategories(extensionComplib);
        try {
            JavaHelpStorage.uninstallComplibHelp(extensionComplib);
        }
        catch (IOException iOException) {
            IdeUtil.logWarning("Unable to remove component library Help from system", iOException);
        }
        this.userScope.remove(extensionComplib);
        String string = this.deriveUniqueLibraryName(extensionComplib);
        Library library = LibraryManager.getDefault().getLibrary(string);
        if (library != null) {
            try {
                JsfProjectUtils.removeLibrary((String)string);
            }
            catch (IOException iOException) {
                IdeUtil.logWarning("Unable to remove Library Definition: " + string, iOException);
            }
        }
        this.fireAddableComplibsChanged(this.userScope);
    }

    private void removeFromPaletteCategories(Complib complib) {
        Complib.Identifier identifier = complib.getIdentifier();
        for (PaletteUtil.Category category : PaletteUtil.getAllCategories()) {
            for (PaletteUtil.Item item : category.getChildren()) {
                if (!item.getComplibId().equals(identifier)) continue;
                item.remove();
            }
            if (!category.isCreatedByComplib() || !category.getChildren().isEmpty()) continue;
            category.remove();
        }
        this.firePaletteChanged(new ComplibEvent((Object)complib));
    }

    public boolean isInstalled(ComplibPackage complibPackage) {
        return this.isInstalled(complibPackage.getIdentifer());
    }

    private boolean isInstalled(Complib.Identifier identifier) {
        return this.getInstalledComplib(identifier) != null;
    }

    public ComponentInfo[] getComponentInfos(Complib complib) throws ComplibException {
        HashMap<String, ComponentInfo> hashMap = new HashMap<String, ComponentInfo>();
        for (Complib.InitialPaletteFolder initialPaletteFolder : complib.getComponentItemsInFolders()) {
            String string = initialPaletteFolder.getName();
            this.getUniqueInitialItems(hashMap, complib, string, initialPaletteFolder.getChildren());
        }
        TreeSet treeSet = new TreeSet(hashMap.values());
        return treeSet.toArray(EMPTY_COMPONENT_INFO_ARRAY);
    }

    private void getUniqueInitialItems(Map<String, ComponentInfo> map, Complib complib, String string, List<Complib.InitialPaletteItem> list) {
        for (Complib.InitialPaletteItem initialPaletteItem : list) {
            String string2 = initialPaletteItem.getClassName();
            ComponentInfo componentInfo = map.get(string2);
            if (componentInfo == null) {
                try {
                    componentInfo = new ComponentInfo(string2, complib);
                }
                catch (ComplibException complibException) {
                    IdeUtil.logError(complibException);
                    continue;
                }
                map.put(string2, componentInfo);
            }
            componentInfo.addInitialCategory(string);
            this.getUniqueInitialItems(map, complib, string, initialPaletteItem.getChildren());
        }
    }

    public void resetToInitialPalette(Complib complib) throws ComplibException {
        assert (this.isInstalled(complib.getIdentifier()));
        this.removeFromPaletteCategories(complib);
        this.addToPalette(complib);
    }

    private void removeComplibFromProject0(Project project, ExtensionComplib extensionComplib) throws IOException {
        Object object;
        ExtensionComplib extensionComplib2 = this.userScope.getExistingComplib(extensionComplib);
        if (extensionComplib2 == null) {
            IdeUtil.logWarning("Unable to find installed component library in userdir: " + extensionComplib.getVersionedTitle());
        } else {
            object = this.deriveUniqueLibraryName(extensionComplib2);
            Library library = JsfProjectUtils.getProjectLibraryManager((Project)project).getLibrary((String)object);
            if (library != null) {
                JsfProjectUtils.removeLibraryReferences((Project)project, (Library[])new Library[]{library});
            }
        }
        object = Scope.getScopeForProject(project);
        ((Scope)object).remove(extensionComplib);
        this.fireAddableComplibsChanged((Scope)object);
    }

    private ExtensionComplib copyComplibToProject(ExtensionComplib extensionComplib, Project project) throws IOException, ComplibException {
        Scope scope = Scope.getScopeForProject(project);
        ExtensionComplib extensionComplib2 = scope.installComplib(extensionComplib);
        this.fireAddableComplibsChanged(scope);
        this.addLibraryRefAndDef(project, extensionComplib);
        this.installProjectResources(extensionComplib, project);
        return extensionComplib2;
    }

    private void installProjectResources(ExtensionComplib extensionComplib, Project project) throws IOException {
        FileObject fileObject = JsfProjectUtils.getDocumentRoot((Project)project);
        File file = FileUtil.toFile((FileObject)fileObject);
        List<File> list = extensionComplib.getWebResourcePath();
        for (File file2 : list) {
            if (file2.isDirectory()) {
                IdeUtil.copyFileRecursive(file2, file);
                continue;
            }
            String string = file2.getName();
            if (!string.endsWith(".zip") && !string.endsWith(".jar")) continue;
            IdeUtil.unzip(file2, file);
        }
    }

    public Complib getInstalledComplib(String string, String string2) {
        Complib.Identifier identifier = new Complib.Identifier(string, string2);
        return this.getInstalledComplib(identifier);
    }

    public PaletteFilter createComplibPaletteFilter(Project project) {
        return new ComplibPaletteFilter(project);
    }

    public PaletteActions createComplibPaletteActions() {
        return new ComplibPaletteActions();
    }

    public void addComplibListener(ComplibListener complibListener) {
        this.listenerList.add(ComplibListener.class, complibListener);
    }

    public void removeComplibListener(ComplibListener complibListener) {
        this.listenerList.remove(ComplibListener.class, complibListener);
    }

    private void firePaletteChanged(final ComplibEvent complibEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Object[] objectArray = ComplibServiceProvider.this.listenerList.getListenerList();
                for (int i = 0; i < objectArray.length; i += 2) {
                    if (objectArray[i] != ComplibListener.class) continue;
                    ((ComplibListener)objectArray[i + 1]).paletteChanged(complibEvent);
                }
            }
        });
    }

    public Set<ExtensionComplib> getComplibsForProject(Project project) {
        Scope scope;
        try {
            scope = Scope.getScopeForProject(project);
        }
        catch (IOException iOException) {
            IdeUtil.logWarning(iOException);
            return Collections.emptySet();
        }
        return scope.getComplibs();
    }

    public Node getComplibsRootNode(Project project) {
        return new ComplibsRootNode(project);
    }

    public void removeComplibFromProject(Project project, ExtensionComplib extensionComplib) throws IOException {
        try {
            this.removeComplibFromProject0(project, extensionComplib);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            this.firePaletteChanged(new ComplibEvent((Object)extensionComplib));
        }
    }

    public RelatedComplibs getRelatedComplibs(ExtensionComplib extensionComplib) {
        Complib.Identifier identifier = extensionComplib.getIdentifier();
        URI uRI = identifier.getNamespaceUri();
        Version version = identifier.getVersion();
        ArrayList<ExtensionComplib> arrayList = new ArrayList<ExtensionComplib>();
        ArrayList<ExtensionComplib> arrayList2 = new ArrayList<ExtensionComplib>();
        ExtensionComplib extensionComplib2 = null;
        Set<ExtensionComplib> set = this.userScope.getComplibs();
        for (ExtensionComplib extensionComplib3 : set) {
            Complib.Identifier identifier2 = extensionComplib3.getIdentifier();
            if (!identifier2.getNamespaceUri().equals(uRI)) continue;
            int n = identifier2.getVersion().compareTo(version);
            if (n > 0) {
                arrayList.add(extensionComplib3);
                continue;
            }
            if (n < 0) {
                arrayList2.add(extensionComplib3);
                continue;
            }
            extensionComplib2 = extensionComplib3;
        }
        Collections.sort(arrayList, Collections.reverseOrder());
        Collections.sort(arrayList2, Collections.reverseOrder());
        return new RelatedComplibs(arrayList, arrayList2, extensionComplib2);
    }

    public void replaceProjectComplib(Project project, ExtensionComplib extensionComplib, ExtensionComplib extensionComplib2) throws IOException, ComplibException {
        ExtensionComplib extensionComplib3 = null;
        Throwable throwable = null;
        try {
            if (extensionComplib != null) {
                this.removeComplibFromProject0(project, extensionComplib);
            }
            extensionComplib3 = this.copyComplibToProject(extensionComplib2, project);
        }
        catch (IOException iOException) {
            throwable = iOException;
            throw iOException;
        }
        catch (ComplibException complibException) {
            throwable = complibException;
            throw complibException;
        }
        finally {
            if (extensionComplib3 == null) {
                if (throwable == null) {
                    IdeUtil.logWarning("org.netbeans.modules.visualweb.complib.ComplibServiceProivder: could not call firePaletteChanged due to null projectComplib");
                } else {
                    IdeUtil.logWarning("org.netbeans.modules.visualweb.complib.ComplibServiceProivder: could not call firePaletteChanged due to null projectComplib and exception [" + throwable + "]", throwable);
                }
            } else {
                this.firePaletteChanged(new ComplibEvent((Object)extensionComplib3));
            }
        }
    }

    public List<ExtensionComplib> getAddableComplibs(Project project) {
        boolean bl = !"1.5".equals(JsfProjectUtils.getJ2eePlatformVersion((Project)project));
        HashSet<ExtensionComplib> hashSet = new HashSet<ExtensionComplib>(this.userScope.getComplibs());
        Set<ExtensionComplib> set = this.getComplibsForProject(project);
        Iterator<ExtensionComplib> iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ExtensionComplib extensionComplib = iterator.next();
            if (bl && extensionComplib.getCompLibManifest().getEeSpecVersion() == ComplibManifest.EeSpecVersion.JAVA_EE_5) {
                iterator.remove();
                continue;
            }
            URI uRI = extensionComplib.getIdentifier().getNamespaceUri();
            for (ExtensionComplib extensionComplib2 : set) {
                if (!uRI.equals(extensionComplib2.getIdentifier().getNamespaceUri())) continue;
                iterator.remove();
            }
        }
        return new ArrayList<ExtensionComplib>(hashSet);
    }

    public void addProjectComplib(Project project, ExtensionComplib extensionComplib) throws IOException, ComplibException {
        this.replaceProjectComplib(project, null, extensionComplib);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pceListeners.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pceListeners.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireAddableComplibsChanged(Scope scope) {
        this.pceListeners.firePropertyChange(ADDABLE_COMPLIBS, null, scope);
    }

    public String getInUseProjectNames(ExtensionComplib extensionComplib) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        Set<Project> set = this.getOpenRaveProjects();
        for (Project project : set) {
            Scope scope;
            String string = ProjectUtils.getInformation((Project)project).getDisplayName();
            try {
                scope = Scope.getScopeForProject(project);
            }
            catch (IOException iOException) {
                IdeUtil.logWarning("Skipping project: " + string, iOException);
                continue;
            }
            if (!scope.contains(extensionComplib)) continue;
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string);
            ++n;
        }
        return n == 0 ? null : stringBuffer.toString();
    }

    public Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = NbPreferences.forModule(ComplibServiceProvider.class);
        }
        return this.preferences;
    }

    private Project getActiveProject() throws ComplibException {
        Project project = IdeUtil.getActiveProject();
        if (project == null) {
            throw new ComplibException("Error: No active project. Select one in designer.");
        }
        return project;
    }

    public List<Project> getEligibleSharedComplibProjects() {
        ArrayList<Project> arrayList = new ArrayList<Project>();
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        SharedComplibState sharedComplibState = SharedComplibState.getInstance();
        for (Project project : projectArray) {
            if (sharedComplibState.projectToSharedComplibDir(project) == null) continue;
            arrayList.add(project);
        }
        return arrayList;
    }

    public void addSharedComplibProject(Project project) throws ComplibException, IOException {
        Project project2 = this.getActiveProject();
        SharedComplibState sharedComplibState = SharedComplibState.getInstance();
        SharedComplib sharedComplib = sharedComplibState.createSharedComplibFromProject(project);
        if (!sharedComplibState.getAllSharedComplibs().contains(sharedComplib)) {
            try {
                this.addToPalette(sharedComplib);
            }
            catch (ComplibException complibException) {
                this.removeFromPaletteCategories(sharedComplib);
                throw complibException;
            }
        }
        sharedComplibState.addSharedComplib(project2, sharedComplib);
        this.addSharedComplibLibraryDefAndRefs(project2, sharedComplib);
    }

    public Set<SharedComplib> getSharedComplibsForActiveProject() throws ComplibException {
        Project project = this.getActiveProject();
        return SharedComplibState.getInstance().getSharedComplibs(project);
    }

    public void removeSharedComplibsFromActiveProject(Set<SharedComplib> set) throws IOException, ComplibException {
        Project project = this.getActiveProject();
        SharedComplibState sharedComplibState = SharedComplibState.getInstance();
        for (SharedComplib sharedComplib : set) {
            this.removeSharedComplibLibraryDefAndRefs(project, sharedComplib);
            sharedComplibState.removeSharedComplib(project, sharedComplib);
            HashSet<SharedComplib> hashSet = sharedComplibState.getAllSharedComplibs();
            if (hashSet.contains(sharedComplib)) continue;
            this.removeFromPaletteCategories(sharedComplib);
        }
    }

    public void refreshSharedComplibsForActiveProject() throws ComplibException {
        Set<SharedComplib> set = this.getSharedComplibsForActiveProject();
        for (SharedComplib sharedComplib : set) {
            this.removeFromPaletteCategories(sharedComplib);
            this.addToPalette(sharedComplib);
        }
    }

    private void addSharedComplibLibraryDefAndRefs(Project project, SharedComplib sharedComplib) throws IOException {
        String string = LibraryLocalizationBundle.class.getName();
        LibraryDescriptor libraryDescriptor = this.deriveSharedComplibLibraryName(sharedComplib);
        String string2 = libraryDescriptor.getLibName();
        Library library = LibraryManager.getDefault().getLibrary(string2);
        if (library != null) {
            return;
        }
        LibraryLocalizationBundle.add(string2, libraryDescriptor.getDescription());
        List<URL> list = this.fileListToUrlList(sharedComplib.getRuntimePath());
        List<URL> list2 = this.fileListToUrlList(sharedComplib.getDesignTimePath());
        List<URL> list3 = this.fileListToUrlList(sharedComplib.getJavadocPath());
        List<URL> list4 = this.fileListToUrlList(sharedComplib.getSourcePath());
        library = JsfProjectUtils.createComponentLibrary((String)string2, (String)string2, (String)string, list, list4, list3, list2);
        if (!JsfProjectUtils.addLibraryReferences((Project)project, (Library[])new Library[]{library})) {
            IdeUtil.logError("Failed to add compile-time library reference to project: " + library.getName());
        }
    }

    private void removeSharedComplibLibraryDefAndRefs(Project project, SharedComplib sharedComplib) throws IOException {
        LibraryDescriptor libraryDescriptor = this.deriveSharedComplibLibraryName(sharedComplib);
        String string = libraryDescriptor.getLibName();
        Library library = JsfProjectUtils.getProjectLibraryManager((Project)project).getLibrary(string);
        if (library != null) {
            JsfProjectUtils.removeLibraryReferences((Project)project, (Library[])new Library[]{library});
            JsfProjectUtils.removeLibrary((String)string);
            LibraryLocalizationBundle.remove(string);
        }
    }

    private LibraryDescriptor deriveSharedComplibLibraryName(SharedComplib sharedComplib) {
        String string = SharedComplibState.getInstance().sharedComplibDirToProjectDir(sharedComplib).getName() + " Shared Component Library";
        String string2 = IdeUtil.removeWhiteSpace(string);
        return new LibraryDescriptor(string2, string);
    }

    private boolean needsMigration(Project project) {
        if (!JsfProjectUtils.isJsfProject((Project)project)) {
            return false;
        }
        FileObject fileObject = project.getProjectDirectory();
        Object object = fileObject.getAttribute(ATTR_MIGRATION_VERSION);
        return !ProjectComplibVersion.NETBEANS_6.equals(object);
    }

    public List<String> getLibRefNamesToRemove(Project project) {
        if (!this.needsMigration(project)) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Scope scope = null;
        try {
            scope = Scope.getScopeForProject(project);
        }
        catch (IOException iOException) {
            IdeUtil.logWarning("Unable to obtain legacy library reference information for project: '" + project.getProjectDirectory() + "'. You may need to use Project Properties to remove broken references manually.", iOException);
        }
        Set<ExtensionComplib> set = scope.getComplibs();
        String string = project.getProjectDirectory().getName();
        for (ExtensionComplib extensionComplib : set) {
            String string2 = IdeUtil.removeWhiteSpace(string + "_" + extensionComplib.getDirectoryBaseName());
            arrayList.add(string2);
            string2 = IdeUtil.removeWhiteSpace(string + " Design-time " + extensionComplib.getTitle());
            arrayList.add(string2);
            string2 = IdeUtil.removeWhiteSpace(string + " Runtime " + extensionComplib.getTitle());
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void initProjectComplibs(Project project) {
        Scope scope;
        try {
            scope = Scope.getScopeForProject(project);
            Set<ExtensionComplib> set = scope.getComplibs();
            this.ensureProjectComplibsAreInstalled(set);
            for (ExtensionComplib extensionComplib : set) {
                ExtensionComplib extensionComplib2 = this.userScope.getExistingComplib(extensionComplib);
                if (extensionComplib2 == null) continue;
                this.addLibraryRefAndDef(project, extensionComplib2);
            }
        }
        catch (IOException iOException) {
            IdeUtil.logError("Unable to initialize component libraries for project: " + project.getProjectDirectory(), iOException);
        }
        scope = project.getProjectDirectory();
        try {
            scope.setAttribute(ATTR_MIGRATION_VERSION, (Object)ProjectComplibVersion.NETBEANS_6);
        }
        catch (IOException iOException) {
            IdeUtil.logWarning(iOException);
        }
    }

    public void cleanUpProjectComplibs(Project project) {
        try {
            Scope.destroyScopeForProject(project);
        }
        catch (IOException iOException) {
            IdeUtil.logWarning(iOException);
        }
    }

    private static class LibraryDescriptor {
        private String libName;
        private String description;

        public LibraryDescriptor(String string, String string2) {
            this.libName = string;
            this.description = string2;
        }

        public String getDescription() {
            return this.description;
        }

        public String getLibName() {
            return this.libName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SharedComplibState {
        private static final String SHARED_COMPLIBS = "sharedComplibs.";
        private static final SharedComplibState INSTANCE = new SharedComplibState();
        private Preferences prefs = NbPreferences.forModule(ComplibServiceProvider.class);
        private Map<Project, Set<SharedComplib>> map;
        private HashSet<SharedComplib> allSharedComplibs = new HashSet();

        public static SharedComplibState getInstance() {
            return INSTANCE;
        }

        private SharedComplibState() {
            this.map = new HashMap<Project, Set<SharedComplib>>();
        }

        public void addSharedComplib(Project project, SharedComplib sharedComplib) {
            this.allSharedComplibs.add(sharedComplib);
            Set<SharedComplib> set = this.map.get(project);
            if (set == null) {
                set = new HashSet<SharedComplib>();
            }
            set.add(sharedComplib);
            this.map.put(project, set);
            this.saveSharedComplibsForProject(project, set);
        }

        public Set<SharedComplib> getSharedComplibs(Project project) {
            Set<SharedComplib> set = this.map.get(project);
            if (set == null) {
                set = this.loadSharedComplibsForProject(project);
                this.allSharedComplibs.addAll(set);
            }
            return set;
        }

        public HashSet<SharedComplib> getAllSharedComplibs() {
            return this.allSharedComplibs;
        }

        public void removeSharedComplib(Project project, SharedComplib sharedComplib) {
            Set<SharedComplib> set = this.getSharedComplibs(project);
            if (set.remove(sharedComplib)) {
                boolean bl = false;
                Collection<Set<SharedComplib>> collection = this.map.values();
                for (Set<SharedComplib> set2 : collection) {
                    if (!set2.contains(sharedComplib)) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.allSharedComplibs.remove(sharedComplib);
                }
                this.saveSharedComplibsForProject(project, set);
            }
        }

        public SharedComplib createSharedComplibFromProject(Project project) throws ComplibException, IOException {
            FileObject fileObject = this.projectToSharedComplibDir(project);
            if (fileObject == null) {
                throw new ComplibException("Shared component library project must have a built 'build/complib' directory.");
            }
            SharedComplib sharedComplib = new SharedComplib(FileUtil.toFile((FileObject)fileObject));
            return sharedComplib;
        }

        public FileObject projectToSharedComplibDir(Project project) {
            FileObject fileObject = project.getProjectDirectory();
            FileObject fileObject2 = fileObject.getFileObject("build/complib");
            return fileObject2;
        }

        public File sharedComplibDirToProjectDir(SharedComplib sharedComplib) {
            File file = sharedComplib.getDirectory();
            File file2 = file.getParentFile();
            if (file2 == null) {
                return null;
            }
            if ((file2 = file2.getParentFile()) == null) {
                return null;
            }
            return file2;
        }

        private Set<SharedComplib> loadSharedComplibsForProject(Project project) {
            String[] stringArray;
            HashSet<SharedComplib> hashSet = new HashSet<SharedComplib>();
            String string = SHARED_COMPLIBS + project.getProjectDirectory().getPath();
            String string2 = this.prefs.get(string, "");
            block2: for (String string3 : stringArray = string2.split(",")) {
                Project[] projectArray;
                for (Project project2 : projectArray = OpenProjects.getDefault().getOpenProjects()) {
                    SharedComplib sharedComplib;
                    if (!project2.getProjectDirectory().getNameExt().equals(string3)) continue;
                    try {
                        sharedComplib = this.createSharedComplibFromProject(project2);
                    }
                    catch (Exception exception) {
                        IdeUtil.logWarning("Skipping bad shared complib", exception);
                        continue;
                    }
                    hashSet.add(sharedComplib);
                    continue block2;
                }
            }
            return hashSet;
        }

        private void saveSharedComplibsForProject(Project project, Set<SharedComplib> set) {
            String string = SHARED_COMPLIBS + project.getProjectDirectory().getPath();
            StringBuffer stringBuffer = new StringBuffer();
            for (SharedComplib sharedComplib : set) {
                File file = this.sharedComplibDirToProjectDir(sharedComplib);
                if (file == null) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(file.getName());
            }
            this.prefs.put(string, stringBuffer.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RelatedComplibs {
        private List<ExtensionComplib> newerComplibs;
        private List<ExtensionComplib> olderComplibs;
        private ExtensionComplib sameVersionComplib;

        private RelatedComplibs(List<ExtensionComplib> list, List<ExtensionComplib> list2, ExtensionComplib extensionComplib) {
            this.newerComplibs = list;
            this.olderComplibs = list2;
            this.sameVersionComplib = extensionComplib;
        }

        public List<ExtensionComplib> getNewerComplibs() {
            return this.newerComplibs;
        }

        public List<ExtensionComplib> getOlderComplibs() {
            return this.olderComplibs;
        }

        public ExtensionComplib getSameVersionComplib() {
            return this.sameVersionComplib;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComponentInfo
    implements Comparable<Object> {
        private String className;
        private HashSet<String> initialCategories = new HashSet();
        private Complib complib;
        private String displayName;
        private String tooltip;
        private String helpId;
        private Icon icon;
        private static final Image defaultIconImage = ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/palette/resources/custom_component.png");

        private ComponentInfo(String string, Complib complib) throws ComplibException {
            Class<?> clazz;
            this.className = string;
            this.complib = complib;
            ClassLoader classLoader = complib.getClassLoader();
            Thread thread = Thread.currentThread();
            ClassLoader classLoader2 = thread.getContextClassLoader();
            thread.setContextClassLoader(classLoader);
            try {
                clazz = Class.forName(string, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                ComplibException complibException = new ComplibException("Class with name=" + string + " was not found by classLoader=" + classLoader, (Throwable)classNotFoundException);
                IdeUtil.logWarning((Throwable)complibException);
                throw complibException;
            }
            finally {
                thread.setContextClassLoader(classLoader2);
            }
            try {
                Image image;
                if (BeanCreateInfo.class.isAssignableFrom(clazz) || BeanCreateInfoSet.class.isAssignableFrom(clazz)) {
                    DisplayItem displayItem = (DisplayItem)clazz.newInstance();
                    this.displayName = displayItem.getDisplayName();
                    this.tooltip = displayItem.getDescription();
                    this.helpId = displayItem.getHelpKey();
                    image = displayItem.getSmallIcon();
                } else {
                    BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
                    BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
                    this.displayName = beanDescriptor.getDisplayName();
                    this.tooltip = beanDescriptor.getShortDescription();
                    this.helpId = (String)beanDescriptor.getValue("helpKey");
                    image = beanInfo.getIcon(1);
                }
                if (image == null) {
                    image = defaultIconImage;
                }
                this.icon = new ImageIcon(image);
            }
            catch (Exception exception) {
                throw new ComplibException("Unable to access component BeanInfo", (Throwable)exception);
            }
        }

        public int hashCode() {
            return this.getDisplayName().hashCode() + this.getClassName().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ComponentInfo) {
                return this.compareTo(object) == 0;
            }
            return false;
        }

        public String getClassName() {
            return this.className;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public String getHelpId() {
            return this.helpId;
        }

        public Set<String> getInitialCategories() {
            return this.initialCategories;
        }

        private void addInitialCategory(String string) {
            this.initialCategories.add(string);
        }

        public Complib getComplib() {
            return this.complib;
        }

        @Override
        public int compareTo(Object object) {
            ComponentInfo componentInfo = (ComponentInfo)object;
            int n = this.getDisplayName().compareTo(componentInfo.getDisplayName());
            if (n == 0) {
                return this.getClassName().compareTo(componentInfo.getClassName());
            }
            return n;
        }
    }

    private static class ComplibPaletteActions
    extends PaletteActions {
        private ComplibPaletteActions() {
        }

        public Action[] getCustomCategoryActions(Lookup lookup) {
            Project project = IdeUtil.getActiveProject();
            Node node = ComplibServiceProvider.getInstance().getComplibsRootNode(project);
            return node.getActions(true);
        }

        public Action[] getCustomItemActions(Lookup lookup) {
            return this.getCustomCategoryActions(lookup);
        }

        public Action[] getCustomPaletteActions() {
            return null;
        }

        public Action[] getImportActions() {
            return null;
        }

        public Action getPreferredAction(Lookup lookup) {
            return null;
        }
    }

    private static class ComplibPaletteFilter
    extends PaletteFilter {
        private final Project project;

        public ComplibPaletteFilter(Project project) {
            this.project = project;
        }

        public boolean isValidCategory(Lookup lookup) {
            if (this.project == null) {
                return true;
            }
            Node node = (Node)lookup.lookup(Node.class);
            if (node == null) {
                return true;
            }
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            if (!(dataObject instanceof DataFolder)) {
                return true;
            }
            DataFolder dataFolder = (DataFolder)dataObject;
            if (!PaletteUtil.isCreatedByComplib(dataFolder.getPrimaryFile())) {
                return true;
            }
            boolean bl = false;
            for (DataObject dataObject2 : dataFolder.getChildren()) {
                if (!this.isVisible(dataObject2)) continue;
                bl = true;
                break;
            }
            return bl;
        }

        public boolean isValidItem(Lookup lookup) {
            if (this.project == null) {
                return true;
            }
            Node node = (Node)lookup.lookup(Node.class);
            if (node == null) {
                return true;
            }
            DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
            if (dataObject == null) {
                return true;
            }
            return this.isVisible(dataObject);
        }

        private boolean isVisible(DataObject dataObject) {
            if (dataObject instanceof ComplibPaletteItemDataObject) {
                Scope scope;
                ComplibPaletteItemDataObject complibPaletteItemDataObject = (ComplibPaletteItemDataObject)dataObject;
                Complib complib = complibPaletteItemDataObject.getComplib();
                if (complib == null) {
                    return false;
                }
                try {
                    scope = Scope.getScopeForProject(this.project);
                }
                catch (IOException iOException) {
                    IdeUtil.logWarning("Unable to find scope for project", iOException);
                    return true;
                }
                Set<ExtensionComplib> set = scope.getComplibs();
                Complib.Identifier identifier = complib.getIdentifier();
                for (ExtensionComplib object2 : set) {
                    if (!identifier.equals(object2.getIdentifier())) continue;
                    return true;
                }
                Set<SharedComplib> set2 = SharedComplibState.getInstance().getSharedComplibs(this.project);
                Iterator iterator = set2.iterator();
                while (iterator.hasNext()) {
                    SharedComplib sharedComplib = (SharedComplib)iterator.next();
                    if (!identifier.equals(sharedComplib.getIdentifier())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ProjectComplibVersion {
        NETBEANS_6;

    }
}

