/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import javax.help.HelpSet;
import org.netbeans.modules.visualweb.complib.ExtensionComplib;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

class JavaHelpStorage {
    private static final FileObject fsRoot = Repository.getDefault().getDefaultFileSystem().getRoot();

    JavaHelpStorage() {
    }

    static void installComplibHelp(ExtensionComplib extensionComplib) throws IOException {
        String string = extensionComplib.getHelpSetFile();
        if (string == null) {
            return;
        }
        URL uRL = HelpSet.findHelpSet((ClassLoader)extensionComplib.getClassLoader(), (String)string);
        if (uRL == null) {
            IdeUtil.logWarning("Unable to access HelpSet file for component library: " + string);
        }
        String string2 = JavaHelpStorage.getHelpSetRefPath(extensionComplib);
        FileObject fileObject = FileUtil.createData((FileObject)fsRoot, (String)string2);
        JavaHelpStorage.writeHelpSetRefFile(fileObject, uRL);
    }

    static void uninstallComplibHelp(ExtensionComplib extensionComplib) throws IOException {
        String string = JavaHelpStorage.getHelpSetRefPath(extensionComplib);
        FileObject fileObject = fsRoot.getFileObject(string);
        if (fileObject != null) {
            fileObject.delete();
        }
    }

    private static String getHelpSetRefPath(ExtensionComplib extensionComplib) {
        String string = "Services/JavaHelp/" + extensionComplib.getDirectoryBaseName() + "-helpset.xml";
        return string;
    }

    private static void writeHelpSetRefFile(final FileObject fileObject, final URL uRL) throws IOException {
        fileObject.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                JavaHelpStorage.writeHelpSetRef(fileObject, uRL);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeHelpSetRef(FileObject fileObject, URL uRL) throws IOException {
        FileLock fileLock = null;
        PrintWriter printWriter = null;
        try {
            fileLock = fileObject.lock();
            printWriter = new PrintWriter(new OutputStreamWriter(fileObject.getOutputStream(fileLock), "UTF-8"));
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            printWriter.println("<!DOCTYPE helpsetref PUBLIC \"-//NetBeans//DTD JavaHelp Help Set Reference 1.0//EN\" \"http://www.netbeans.org/dtds/helpsetref-1_0.dtd\">");
            printWriter.println("<helpsetref url=\"" + uRL.toExternalForm() + "\"/>");
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }
}

