/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.visualweb.complib.Complib;
import org.netbeans.modules.visualweb.complib.ComplibServiceProvider;
import org.netbeans.modules.visualweb.complib.ExtensionComplib;
import org.netbeans.modules.visualweb.complib.ui.CompLibManagerPanel;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComplibChooser
extends JPanel
implements HelpCtx.Provider {
    private static final ComplibServiceProvider csp = ComplibServiceProvider.getInstance();
    private JButton edit;
    private JLabel jLabel1;
    private JList jList1;
    private JScrollPane jScrollPane1;

    public ComplibChooser(final JButton jButton, Project project) {
        this.initComponents();
        this.jList1.setPrototypeCellValue("0123456789012345678901234");
        ComplibListModel complibListModel = new ComplibListModel(project);
        this.jList1.setModel(complibListModel);
        this.jList1.setCellRenderer(new ComplibRenderer());
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                jButton.setEnabled(ComplibChooser.this.jList1.getSelectedIndices().length != 0);
            }
        });
        if (complibListModel.getSize() > 0) {
            this.jList1.setSelectedIndex(0);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ComplibChooser.class);
    }

    public ArrayList<ExtensionComplib> getSelectedComplibs() {
        Object[] objectArray;
        ArrayList<ExtensionComplib> arrayList = new ArrayList<ExtensionComplib>();
        for (Object object : objectArray = this.jList1.getSelectedValues()) {
            if (!(object instanceof ExtensionComplib)) continue;
            arrayList.add((ExtensionComplib)object);
        }
        return arrayList;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.edit = new JButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ComplibChooser.class).getString("ComplibChooser.AD"));
        this.jLabel1.setLabelFor(this.jList1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(ComplibChooser.class).getString("ComplibChooser.installedLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.jList1);
        this.jList1.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ComplibChooser.class).getString("ComplibChooser.scrollpane.AD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.edit, (String)NbBundle.getBundle(ComplibChooser.class).getString("ComplibChooser.edit"));
        this.edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComplibChooser.this.editLibraries(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.edit, gridBagConstraints);
        this.edit.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ComplibChooser.class).getString("ComplibChooser.button.AD"));
    }

    private void editLibraries(ActionEvent actionEvent) {
        new CompLibManagerPanel().showDialog();
    }

    private static class ComplibRenderer
    extends DefaultListCellRenderer {
        private static final Icon icon;

        private ComplibRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = null;
            if (object instanceof Complib) {
                Complib complib = (Complib)object;
                string = complib.getVersionedTitle();
            }
            super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
            this.setIcon(icon);
            return this;
        }

        static {
            String string = ComplibChooser.class.getPackage().getName().replace('.', '/') + "/images/library.png";
            icon = new ImageIcon(ImageUtilities.loadImage((String)string));
        }
    }

    private static final class ComplibListModel
    extends AbstractListModel
    implements PropertyChangeListener {
        private Project project;
        private List<ExtensionComplib> addableComplibs;

        public ComplibListModel(Project project) {
            this.project = project;
            csp.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)csp));
        }

        public int getSize() {
            this.loadAddableComplibs();
            return this.addableComplibs.size();
        }

        public Object getElementAt(int n) {
            this.loadAddableComplibs();
            return this.addableComplibs.get(n);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.addableComplibs = null;
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }

        private void loadAddableComplibs() {
            if (this.addableComplibs == null) {
                this.addableComplibs = csp.getAddableComplibs(this.project);
            }
        }
    }
}

