/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.visualweb.complib.ComplibServiceProvider;
import org.netbeans.modules.visualweb.complib.IdeUtil;
import org.netbeans.modules.visualweb.complib.ui.ComplibOptionsPanelController;
import org.netbeans.modules.visualweb.extension.openide.awt.JFileChooser_RAVE;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class ComplibOptionsPanel
extends JPanel {
    private static final String IMPORT_START_DIR = "importStartDir";
    private final ComplibOptionsPanelController controller;
    private static Preferences prefs = ComplibServiceProvider.getInstance().getPreferences();
    private JButton importBrowseBtn;
    private JButton importResetBtn;
    private JTextField importStartDirField;
    private JLabel importStartDirLbl;
    private JPanel jPanel1;
    private JCheckBox sharedComplibCheckBox;

    ComplibOptionsPanel(ComplibOptionsPanelController complibOptionsPanelController) {
        this.controller = complibOptionsPanelController;
        this.initComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.importStartDirLbl = new JLabel();
        this.importStartDirField = new JTextField();
        this.importResetBtn = new JButton();
        this.importBrowseBtn = new JButton();
        this.sharedComplibCheckBox = new JCheckBox();
        this.setBackground(Color.white);
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(ComplibOptionsPanel.class, (String)"AdvancedOption_ImportPanelTitle")));
        this.importStartDirLbl.setLabelFor(this.importStartDirField);
        Mnemonics.setLocalizedText((JLabel)this.importStartDirLbl, (String)NbBundle.getMessage(ComplibOptionsPanel.class, (String)"AdvancedOption_ImportStartDirLbl"));
        Mnemonics.setLocalizedText((AbstractButton)this.importResetBtn, (String)NbBundle.getMessage(ComplibOptionsPanel.class, (String)"AdvancedOption_ImportResetBtn"));
        this.importResetBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComplibOptionsPanel.this.importResetActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.importBrowseBtn, (String)NbBundle.getMessage(ComplibOptionsPanel.class, (String)"AdvancedOption_ImportBrowseBtn"));
        this.importBrowseBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComplibOptionsPanel.this.browseActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.importStartDirLbl).addPreferredGap(0).add((Component)this.importStartDirField, -1, 246, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.importBrowseBtn)).add(2, (Component)this.importResetBtn)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.importStartDirLbl).add((Component)this.importStartDirField, -2, -1, -2).add((Component)this.importBrowseBtn)).add(12, 12, 12).add((Component)this.importResetBtn).addContainerGap()));
        this.sharedComplibCheckBox.setBackground(Color.white);
        Mnemonics.setLocalizedText((AbstractButton)this.sharedComplibCheckBox, (String)NbBundle.getMessage(ComplibOptionsPanel.class, (String)"AdvancedOption_SharedComplibCheckBox"));
        this.sharedComplibCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.sharedComplibCheckBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(10, 10, 10).add((Component)this.sharedComplibCheckBox)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.sharedComplibCheckBox).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = JFileChooser_RAVE.getJFileChooser();
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory();
            }

            public String getDescription() {
                return NbBundle.getMessage(ComplibOptionsPanel.class, (String)"AdvancedOption_ImportFilterDesc");
            }
        });
        File file = new File(this.importStartDirField.getText());
        jFileChooser.setCurrentDirectory(file);
        if (jFileChooser.showOpenDialog(this) == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.importStartDirField.setText(file2.getAbsolutePath());
        }
    }

    private void importResetActionPerformed(ActionEvent actionEvent) {
        String string = IdeUtil.getRaveSamplesDirectory().getAbsolutePath();
        this.importStartDirField.setText(string);
    }

    private static void initImportStartDir() {
        String string = System.getProperty("complib.importStartDir");
        if (string == null) {
            string = System.getProperty("toolbox.importStartDir");
        }
        if (string != null) {
            prefs.put(IMPORT_START_DIR, string);
        }
    }

    static File getImportStartDir() {
        String string = IdeUtil.getRaveSamplesDirectory().getAbsolutePath();
        String string2 = prefs.get(IMPORT_START_DIR, string);
        return new File(string2);
    }

    void load() {
        this.importStartDirField.setText(ComplibOptionsPanel.getImportStartDir().getAbsolutePath());
        this.sharedComplibCheckBox.setEnabled(false);
        this.sharedComplibCheckBox.setSelected(true);
    }

    void store() {
        prefs.put(IMPORT_START_DIR, this.importStartDirField.getText());
    }

    boolean valid() {
        File file = new File(this.importStartDirField.getText());
        return file.isDirectory();
    }

    static {
        ComplibOptionsPanel.initImportStartDir();
    }
}

