/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.openide.util.Exceptions;

public class CopyTransformer
extends RefactoringVisitor {
    private String newName;
    private boolean insertImport;
    private String oldPackage;
    private String oldName;
    private String newPackage;

    public CopyTransformer(WorkingCopy workingCopy, String string, String string2, boolean bl, String string3) {
        try {
            this.setWorkingCopy(workingCopy);
            this.newName = string2;
            this.insertImport = bl;
            this.oldPackage = string3;
            this.oldName = string;
            this.newPackage = RetoucheUtils.getPackageName(workingCopy.getFileObject().getParent());
        }
        catch (ToPhaseException toPhaseException) {
            Exceptions.printStackTrace((Throwable)toPhaseException);
        }
    }

    public Tree visitCompilationUnit(CompilationUnitTree compilationUnitTree, Element element) {
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            CompilationUnitTree compilationUnitTree2 = compilationUnitTree;
            if (compilationUnitTree2.getPackageName() != null && !"".equals(this.newPackage)) {
                this.rewrite(compilationUnitTree2.getPackageName(), this.make.Identifier((CharSequence)this.newPackage));
            } else {
                compilationUnitTree2 = this.make.CompilationUnit((ExpressionTree)("".equals(this.newPackage) ? null : this.make.Identifier((CharSequence)this.newPackage)), compilationUnitTree2.getImports(), compilationUnitTree2.getTypeDecls(), compilationUnitTree2.getSourceFile());
            }
            if (this.insertImport) {
                CompilationUnitTree compilationUnitTree3 = this.make.insertCompUnitImport(compilationUnitTree2, 0, this.make.Import((Tree)this.make.Identifier((CharSequence)(this.oldPackage + ".*")), false));
                this.rewrite(compilationUnitTree2, compilationUnitTree3);
            }
        }
        return (Tree)super.visitCompilationUnit(compilationUnitTree, element);
    }

    public Tree visitClass(ClassTree classTree, Element element) {
        if (!this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            TypeElement typeElement = (TypeElement)this.workingCopy.getTrees().getElement(this.getCurrentPath());
            if (typeElement == null) {
                Logger.getLogger("org.netbeans.modules.refactoring.java").severe("Cannot resolve tree " + classTree + "\n file: " + this.workingCopy.getFileObject().getPath());
            } else if (!typeElement.getNestingKind().isNested() && (this.workingCopy.getCompilationUnit().getTypeDecls().size() == 1 || classTree.getSimpleName().toString().equals(this.oldName))) {
                Tree tree = this.make.setLabel((Tree)classTree, (CharSequence)this.newName);
                this.rewrite(classTree, tree);
            }
        }
        return (Tree)super.visitClass(classTree, element);
    }

    public Tree visitIdentifier(IdentifierTree identifierTree, Element element) {
        this.renameUsageIfMatch(this.getCurrentPath(), identifierTree, element);
        return (Tree)super.visitIdentifier(identifierTree, element);
    }

    public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Element element) {
        this.renameUsageIfMatch(this.getCurrentPath(), memberSelectTree, element);
        return (Tree)super.visitMemberSelect(memberSelectTree, element);
    }

    private void renameUsageIfMatch(TreePath treePath, Tree tree, Element element) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(treePath)) {
            return;
        }
        Element element2 = this.workingCopy.getTrees().getElement(treePath);
        if (element2 == null) {
            return;
        }
        if (element2 instanceof TypeElement && ((TypeElement)element2).getQualifiedName().toString().equals(this.newPackage + "." + this.oldName)) {
            Tree tree2 = this.make.setLabel(tree, (CharSequence)this.newName);
            this.rewrite(tree, tree2);
        }
    }
}

