/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.LocalVarScanner;
import org.netbeans.modules.refactoring.java.plugins.RenameTransformer;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameRefactoringPlugin
extends JavaRefactoringPlugin {
    private TreePathHandle treePathHandle = null;
    private Collection<ExecutableElement> overriddenByMethods = null;
    private Collection<ExecutableElement> overridesMethods = null;
    private boolean doCheckName = true;
    private RenameRefactoring refactoring;
    private Set<ElementHandle<ExecutableElement>> allMethods;

    public RenameRefactoringPlugin(RenameRefactoring renameRefactoring) {
        this.refactoring = renameRefactoring;
        TreePathHandle treePathHandle = (TreePathHandle)renameRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle != null) {
            this.treePathHandle = treePathHandle;
        } else {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)((FileObject)renameRefactoring.getRefactoringSource().lookup(FileObject.class)));
            try {
                javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.RESOLVED);
                        CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                        for (Tree tree : compilationUnitTree.getTypeDecls()) {
                            Element element = compilationController.getTrees().getElement(TreePath.getPath(compilationUnitTree, tree));
                            if (element == null || !element.getSimpleName().toString().equals(compilationController.getFileObject().getName())) continue;
                            RenameRefactoringPlugin.this.treePathHandle = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, tree), (CompilationInfo)compilationController);
                            RenameRefactoringPlugin.this.refactoring.getContext().add((Object)compilationController);
                            break;
                        }
                    }
                }, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        if (this.treePathHandle == null) {
            return null;
        }
        switch (phase) {
            case PRECHECK: 
            case FASTCHECKPARAMETERS: {
                return JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
            }
            case CHECKPARAMETERS: {
                if (this.treePathHandle == null) {
                    return null;
                }
                ClasspathInfo classpathInfo = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
                JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
                return javaSource;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected Problem preCheck(CompilationController compilationController) throws IOException {
        Problem problem = null;
        this.fireProgressListenerStart(1, 4);
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        Element element = this.treePathHandle.resolveElement((CompilationInfo)compilationController);
        problem = RenameRefactoringPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)compilationController);
        if (problem != null) {
            return problem;
        }
        FileObject fileObject = SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo());
        if (fileObject != null && FileUtil.getArchiveFile((FileObject)fileObject) != null) {
            problem = RenameRefactoringPlugin.createProblem(problem, true, RenameRefactoringPlugin.getCannotRename(fileObject));
            return problem;
        }
        if (fileObject == null || !RetoucheUtils.isElementInOpenProject(fileObject)) {
            problem = new Problem(true, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
            return problem;
        }
        switch (element.getKind()) {
            case METHOD: {
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                this.overriddenByMethods = RetoucheUtils.getOverridingMethods((ExecutableElement)element, (CompilationInfo)compilationController);
                this.fireProgressListenerStep();
                if (element.getModifiers().contains((Object)Modifier.NATIVE)) {
                    problem = RenameRefactoringPlugin.createProblem(problem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_RenameNative", (Object)element));
                }
                if (!this.overriddenByMethods.isEmpty()) {
                    String string = new MessageFormat(RenameRefactoringPlugin.getString("ERR_IsOverridden")).format(new Object[]{SourceUtils.getEnclosingTypeElement((Element)element).getSimpleName().toString()});
                    problem = RenameRefactoringPlugin.createProblem(problem, false, string);
                }
                for (ExecutableElement object2 : this.overriddenByMethods) {
                    if (!object2.getModifiers().contains((Object)Modifier.NATIVE)) continue;
                    problem = RenameRefactoringPlugin.createProblem(problem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_RenameNative", (Object)object2));
                }
                this.overridesMethods = RetoucheUtils.getOverridenMethods((ExecutableElement)element, (CompilationInfo)compilationController);
                this.fireProgressListenerStep();
                if (this.overridesMethods.isEmpty()) break;
                boolean bl = false;
                for (ExecutableElement executableElement : this.overridesMethods) {
                    if (executableElement.getModifiers().contains((Object)Modifier.NATIVE)) {
                        problem = RenameRefactoringPlugin.createProblem(problem, false, NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_RenameNative", (Object)executableElement));
                    }
                    if (!RetoucheUtils.isFromLibrary(executableElement, compilationController.getClasspathInfo())) continue;
                    bl = true;
                    break;
                }
                String string = bl ? RenameRefactoringPlugin.getString("ERR_Overrides_Fatal") : RenameRefactoringPlugin.getString("ERR_Overrides");
                problem = RenameRefactoringPlugin.createProblem(problem, bl, string);
                break;
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                Element element2 = this.hides(element, element.getSimpleName().toString(), (CompilationInfo)compilationController);
                this.fireProgressListenerStep();
                this.fireProgressListenerStep();
                if (element2 == null) break;
                String string = new MessageFormat(RenameRefactoringPlugin.getString("ERR_Hides")).format(new Object[]{SourceUtils.getEnclosingTypeElement((Element)element2)});
                problem = RenameRefactoringPlugin.createProblem(problem, false, string);
                break;
            }
            case PACKAGE: {
                break;
            }
            case LOCAL_VARIABLE: {
                break;
            }
            case CLASS: 
            case INTERFACE: 
            case ANNOTATION_TYPE: 
            case ENUM: {
                break;
            }
        }
        this.fireProgressListenerStop();
        return problem;
    }

    private static final String getCannotRename(FileObject fileObject) {
        return new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_CannotRenameFile")).format(new Object[]{fileObject.getNameExt()});
    }

    @Override
    protected Problem fastCheckParameters(CompilationController compilationController) throws IOException {
        Problem problem = null;
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        TreePath treePath = this.treePathHandle.resolve((CompilationInfo)compilationController);
        Element element = this.treePathHandle.resolveElement((CompilationInfo)compilationController);
        ElementKind elementKind = element.getKind();
        String string = this.refactoring.getNewName();
        String string2 = element.getSimpleName().toString();
        if (string2.equals(string)) {
            boolean bl = true;
            if (elementKind.isClass() && !((TypeElement)element).getNestingKind().isNested()) {
                bl = compilationController.getFileObject().getName().contentEquals(((TypeElement)element).getSimpleName());
            }
            if (bl) {
                problem = RenameRefactoringPlugin.createProblem(problem, true, RenameRefactoringPlugin.getString("ERR_NameNotChanged"));
                return problem;
            }
        }
        if (!Utilities.isJavaIdentifier((String)string)) {
            String string3 = elementKind == ElementKind.PACKAGE ? RenameRefactoringPlugin.getString("ERR_InvalidPackage") : RenameRefactoringPlugin.getString("ERR_InvalidIdentifier");
            String string4 = new MessageFormat(string3).format(new Object[]{string});
            problem = RenameRefactoringPlugin.createProblem(problem, true, string4);
            return problem;
        }
        if (elementKind.isClass() && !((TypeElement)element).getNestingKind().isNested()) {
            FileObject fileObject;
            String string5;
            Object object;
            if (this.doCheckName) {
                String string6 = RetoucheUtils.getQualifiedName(this.treePathHandle);
                object = string6.substring(0, string6.lastIndexOf(string2));
                string5 = string6;
                int n = string5.indexOf(46);
                string5 = n >= 0 ? string5.substring(0, n) : "";
                String string7 = "".equals(string5) ? string : string5 + '.' + string;
                FileObject fileObject2 = this.treePathHandle.getFileObject();
                ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject2, (String)"classpath/source");
                if (RetoucheUtils.typeExist(this.treePathHandle, (String)object)) {
                    String string8 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassClash")).format(new Object[]{string, string5});
                    problem = RenameRefactoringPlugin.createProblem(problem, true, string8);
                    return problem;
                }
                FileObject fileObject3 = fileObject2.getParent();
                Enumeration enumeration = fileObject3.getFolders(false);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject4 = (FileObject)enumeration.nextElement();
                    if (!fileObject4.getName().equals(string)) continue;
                    String string9 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_ClassPackageClash")).format(new Object[]{string, string5});
                    problem = RenameRefactoringPlugin.createProblem(problem, true, string9);
                    return problem;
                }
            }
            if ((string5 = (object = (fileObject = this.treePathHandle.getFileObject()).getParent()).getFileObject(string, fileObject.getExt())) != null && fileObject != string5) {
                String string10 = NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_ClassClash", (Object)string, (Object)object.getPath());
                problem = RenameRefactoringPlugin.createProblem(problem, true, string10);
            }
        } else if (elementKind == ElementKind.LOCAL_VARIABLE || elementKind == ElementKind.PARAMETER) {
            String string11 = this.variableClashes(string, treePath, (CompilationInfo)compilationController);
            if (string11 != null) {
                problem = RenameRefactoringPlugin.createProblem(problem, true, string11);
                return problem;
            }
        } else {
            String string12 = this.clashes(element, string, (CompilationInfo)compilationController);
            if (string12 != null) {
                problem = RenameRefactoringPlugin.createProblem(problem, true, string12);
                return problem;
            }
        }
        return problem;
    }

    @Override
    protected Problem checkParameters(CompilationController compilationController) throws IOException {
        Problem problem = null;
        int n = 0;
        if (this.overriddenByMethods != null) {
            n += this.overriddenByMethods.size();
        }
        if (this.overridesMethods != null) {
            n += this.overridesMethods.size();
        }
        this.fireProgressListenerStart(2, 8 + 3 * n);
        compilationController.toPhase(JavaSource.Phase.RESOLVED);
        Element element = this.treePathHandle.resolveElement((CompilationInfo)compilationController);
        this.fireProgressListenerStep();
        this.fireProgressListenerStep();
        if (element.getKind() == ElementKind.METHOD) {
            problem = this.checkMethodForOverriding((ExecutableElement)element, this.refactoring.getNewName(), problem, (CompilationInfo)compilationController);
            this.fireProgressListenerStep();
            this.fireProgressListenerStep();
        } else if (element.getKind().isField()) {
            this.fireProgressListenerStep();
            this.fireProgressListenerStep();
            Element element2 = this.hides(element, this.refactoring.getNewName(), (CompilationInfo)compilationController);
            this.fireProgressListenerStep();
            this.fireProgressListenerStep();
            this.fireProgressListenerStep();
            if (element2 != null) {
                String string = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillHide")).format(new Object[]{SourceUtils.getEnclosingTypeElement((Element)element2).toString()});
                problem = RenameRefactoringPlugin.createProblem(problem, false, string);
            }
        }
        this.fireProgressListenerStop();
        return problem;
    }

    private Problem checkMethodForOverriding(ExecutableElement executableElement, String string, Problem problem, CompilationInfo compilationInfo) {
        ElementUtilities elementUtilities = compilationInfo.getElementUtilities();
        this.fireProgressListenerStep();
        problem = this.willOverride(executableElement, string, problem, compilationInfo);
        this.fireProgressListenerStep();
        return problem;
    }

    private Set<FileObject> getRelevantFiles() {
        ClasspathInfo classpathInfo = this.getClasspathInfo((AbstractRefactoring)this.refactoring);
        final HashSet<FileObject> hashSet = new HashSet<FileObject>();
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[]{this.treePathHandle.getFileObject()});
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public void run(CompilationController compilationController) throws Exception {
                    ClassIndex classIndex = compilationController.getClasspathInfo().getClassIndex();
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    Element element = RenameRefactoringPlugin.this.treePathHandle.resolveElement((CompilationInfo)compilationController);
                    ElementKind elementKind = element.getKind();
                    ElementHandle elementHandle = element instanceof TypeElement ? ElementHandle.create((Element)((TypeElement)element)) : ElementHandle.create((Element)SourceUtils.getEnclosingTypeElement((Element)element));
                    hashSet.add(SourceUtils.getFile((Element)element, (ClasspathInfo)compilationController.getClasspathInfo()));
                    if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                        if (elementKind == ElementKind.METHOD) {
                            RenameRefactoringPlugin.this.allMethods = new HashSet();
                            RenameRefactoringPlugin.this.allMethods.add(ElementHandle.create((Element)((ExecutableElement)element)));
                        }
                    } else if (elementKind.isField()) {
                        hashSet.addAll(classIndex.getResources(elementHandle, EnumSet.of(ClassIndex.SearchKind.FIELD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    } else if (element instanceof TypeElement) {
                        hashSet.addAll(classIndex.getResources(elementHandle, EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES, ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    } else if (elementKind == ElementKind.METHOD) {
                        RenameRefactoringPlugin.this.allMethods = new HashSet();
                        RenameRefactoringPlugin.this.allMethods.add(ElementHandle.create((Element)((ExecutableElement)element)));
                        for (ExecutableElement executableElement : RetoucheUtils.getOverridingMethods((ExecutableElement)element, (CompilationInfo)compilationController)) {
                            RenameRefactoringPlugin.this.addMethods(executableElement, hashSet, (CompilationInfo)compilationController, classIndex);
                        }
                        for (ExecutableElement executableElement : RetoucheUtils.getOverridenMethods((ExecutableElement)element, (CompilationInfo)compilationController)) {
                            RenameRefactoringPlugin.this.addMethods(executableElement, hashSet, (CompilationInfo)compilationController, classIndex);
                            for (ExecutableElement executableElement2 : RetoucheUtils.getOverridingMethods(executableElement, (CompilationInfo)compilationController)) {
                                RenameRefactoringPlugin.this.addMethods(executableElement2, hashSet, (CompilationInfo)compilationController, classIndex);
                            }
                        }
                        hashSet.addAll(classIndex.getResources(elementHandle, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
        return hashSet;
    }

    private void addMethods(ExecutableElement executableElement, Set set, CompilationInfo compilationInfo, ClassIndex classIndex) {
        set.add(SourceUtils.getFile((Element)executableElement, (ClasspathInfo)compilationInfo.getClasspathInfo()));
        ElementHandle elementHandle = ElementHandle.create((Element)SourceUtils.getEnclosingTypeElement((Element)executableElement));
        set.addAll(classIndex.getResources(elementHandle, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        this.allMethods.add((ElementHandle<ExecutableElement>)ElementHandle.create((Element)executableElement));
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (this.treePathHandle == null) {
            return null;
        }
        Set<FileObject> set = this.getRelevantFiles();
        this.fireProgressListenerStart(1, set.size());
        JavaRefactoringPlugin.TransformTask transformTask = new JavaRefactoringPlugin.TransformTask(this, new RenameTransformer(this.refactoring.getNewName(), this.allMethods, this.refactoring.isSearchInComments()), this.treePathHandle);
        Problem problem = this.createAndAddElements(set, transformTask, refactoringElementsBag, (AbstractRefactoring)this.refactoring);
        this.fireProgressListenerStop();
        return problem;
    }

    private static int getAccessLevel(Element element) {
        Set<Modifier> set = element.getModifiers();
        if (set.contains((Object)Modifier.PUBLIC)) {
            return 3;
        }
        if (set.contains((Object)Modifier.PROTECTED)) {
            return 2;
        }
        if (!set.contains((Object)Modifier.PRIVATE)) {
            return 1;
        }
        return 0;
    }

    private Problem willOverride(ExecutableElement executableElement, String string, Problem problem, CompilationInfo compilationInfo) {
        boolean bl = executableElement.getModifiers().contains((Object)Modifier.STATIC);
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        LinkedList linkedList = new LinkedList();
        ElementUtilities elementUtilities = compilationInfo.getElementUtilities();
        Element element = null;
        if (element != null) {
            if (element.getModifiers().contains((Object)Modifier.FINAL)) {
                String string2 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride_final")).format(new Object[]{executableElement.getSimpleName(), executableElement.getEnclosingElement().getSimpleName(), element.getSimpleName(), element.getEnclosingElement().getSimpleName()});
                return RenameRefactoringPlugin.createProblem(problem, true, string2);
            }
            if (RenameRefactoringPlugin.getAccessLevel(element) > RenameRefactoringPlugin.getAccessLevel(executableElement)) {
                String string3 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride_access")).format(new Object[]{executableElement.getSimpleName(), executableElement.getEnclosingElement().getSimpleName(), element.getSimpleName(), element.getEnclosingElement().getSimpleName()});
                return RenameRefactoringPlugin.createProblem(problem, true, string3);
            }
            if (element.getModifiers().contains((Object)Modifier.STATIC) != executableElement.getModifiers().contains((Object)Modifier.STATIC)) {
                String string4 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride_static")).format(new Object[]{bl ? RenameRefactoringPlugin.getString("LBL_static") : RenameRefactoringPlugin.getString("LBL_instance"), executableElement.getSimpleName(), executableElement.getEnclosingElement().getSimpleName(), element.getModifiers().contains((Object)Modifier.STATIC) ? RenameRefactoringPlugin.getString("LBL_static") : RenameRefactoringPlugin.getString("LBL_instance"), element.getSimpleName(), element.getEnclosingElement().getSimpleName()});
                return RenameRefactoringPlugin.createProblem(problem, true, string4);
            }
            String string5 = new MessageFormat(RenameRefactoringPlugin.getString("ERR_WillOverride")).format(new Object[]{executableElement.getSimpleName(), executableElement.getEnclosingElement().getSimpleName(), element.getSimpleName(), element.getEnclosingElement().getSimpleName()});
            return RenameRefactoringPlugin.createProblem(problem, false, string5);
        }
        return problem;
    }

    private Element hides(Element element, String string, CompilationInfo compilationInfo) {
        TypeElement typeElement = SourceUtils.getEnclosingTypeElement((Element)element);
        Elements elements = compilationInfo.getElements();
        ElementUtilities elementUtilities = compilationInfo.getElementUtilities();
        for (Element element2 : elements.getAllMembers(typeElement)) {
            if (!element2.getKind().isField() || !element2.getSimpleName().toString().equals(string) || ((Object)element2.getEnclosingElement()).equals(element.getEnclosingElement())) continue;
            return element2;
        }
        return null;
    }

    private String variableClashes(String string, TreePath treePath, CompilationInfo compilationInfo) {
        LocalVarScanner localVarScanner = new LocalVarScanner(compilationInfo, string);
        TreePath treePath2 = treePath;
        EnumSet<Tree.Kind> enumSet = EnumSet.of(Tree.Kind.BLOCK, Tree.Kind.FOR_LOOP, Tree.Kind.METHOD);
        while (!enumSet.contains((Object)treePath2.getLeaf().getKind())) {
            treePath2 = treePath2.getParentPath();
        }
        Element element = compilationInfo.getTrees().getElement(treePath);
        localVarScanner.scan(treePath2, element);
        if (localVarScanner.hasRefernces()) {
            return new MessageFormat(RenameRefactoringPlugin.getString("ERR_LocVariableClash")).format(new Object[]{string});
        }
        for (TreePath treePath3 = treePath; treePath3 != null && treePath3.getLeaf().getKind() != Tree.Kind.METHOD; treePath3 = treePath3.getParentPath()) {
            Scope scope = compilationInfo.getTrees().getScope(treePath3);
            for (Element element2 : scope.getLocalElements()) {
                if (!element2.getSimpleName().toString().equals(string)) continue;
                return new MessageFormat(RenameRefactoringPlugin.getString("ERR_LocVariableClash")).format(new Object[]{string});
            }
        }
        return null;
    }

    private String clashes(Element element, String string, CompilationInfo compilationInfo) {
        block4: {
            ElementKind elementKind;
            Element element2;
            block5: {
                ElementUtilities elementUtilities;
                block3: {
                    elementUtilities = compilationInfo.getElementUtilities();
                    element2 = element.getEnclosingElement();
                    elementKind = element.getKind();
                    if (!elementKind.isClass() && !elementKind.isInterface()) break block3;
                    for (TypeElement typeElement : ElementFilter.typesIn(element2.getEnclosedElements())) {
                        if (!typeElement.getSimpleName().toString().equals(string)) continue;
                        return new MessageFormat(RenameRefactoringPlugin.getString("ERR_InnerClassClash")).format(new Object[]{string, element2.getSimpleName()});
                    }
                    break block4;
                }
                if (elementKind != ElementKind.METHOD) break block5;
                if (elementUtilities.alreadyDefinedIn((CharSequence)string, (ExecutableType)element.asType(), (TypeElement)element2)) {
                    return new MessageFormat(RenameRefactoringPlugin.getString("ERR_MethodClash")).format(new Object[]{string, element2.getSimpleName()});
                }
                break block4;
            }
            if (!elementKind.isField()) break block4;
            for (VariableElement variableElement : ElementFilter.fieldsIn(element2.getEnclosedElements())) {
                if (!variableElement.getSimpleName().toString().equals(string)) continue;
                return new MessageFormat(RenameRefactoringPlugin.getString("ERR_FieldClash")).format(new Object[]{string, element2.getSimpleName()});
            }
        }
        return null;
    }

    private static final String getString(String string) {
        return NbBundle.getMessage(RenameRefactoringPlugin.class, (String)string);
    }
}

