/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetoucheCommit
implements Transaction {
    ArrayList<BackupFacility.Handle> ids = new ArrayList();
    private boolean commited = false;
    Collection<ModificationResult> results;
    private Set<File> newFiles;
    private boolean newFilesStored = false;

    public RetoucheCommit(Collection<ModificationResult> collection) {
        this.results = collection;
    }

    public void commit() {
        try {
            if (this.commited) {
                for (BackupFacility.Handle handle : this.ids) {
                    try {
                        handle.restore();
                    }
                    catch (IOException iOException) {
                        throw (RuntimeException)new RuntimeException().initCause(iOException);
                    }
                }
            } else {
                this.commited = true;
                for (ModificationResult modificationResult : this.results) {
                    this.ids.add(BackupFacility.getDefault().backup((Collection)modificationResult.getModifiedFileObjects()));
                    this.newFiles = modificationResult.getNewFiles();
                    modificationResult.commit();
                }
            }
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
    }

    public void rollback() {
        for (BackupFacility.Handle object : this.ids) {
            try {
                object.restore();
            }
            catch (IOException file) {
                throw (RuntimeException)new RuntimeException().initCause(file);
            }
        }
        boolean bl = false;
        if (this.newFiles != null) {
            for (File file : this.newFiles) {
                try {
                    FileObject iOException = FileUtil.toFileObject((File)file);
                    if (!this.newFilesStored) {
                        this.ids.add(BackupFacility.getDefault().backup(new FileObject[]{iOException}));
                        bl = true;
                    }
                    iOException.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            this.newFilesStored |= bl;
        }
    }
}

