/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.api.UseSuperTypeRefactoring;
import org.netbeans.modules.refactoring.java.plugins.RetoucheCommit;
import org.netbeans.modules.refactoring.java.plugins.VarUsageVisitor;
import org.netbeans.modules.refactoring.java.spi.DiffElement;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.RefactoringVisitor;
import org.netbeans.modules.refactoring.java.spi.ToPhaseException;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class UseSuperTypeRefactoringPlugin
extends JavaRefactoringPlugin {
    private final UseSuperTypeRefactoring refactoring;

    public UseSuperTypeRefactoringPlugin(UseSuperTypeRefactoring useSuperTypeRefactoring) {
        this.refactoring = useSuperTypeRefactoring;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        TreePathHandle treePathHandle = this.refactoring.getTypeElement();
        this.replaceSubtypeUsages(treePathHandle, refactoringElementsBag);
        return null;
    }

    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        switch (phase) {
            default: 
        }
        return JavaSource.forFileObject((FileObject)this.refactoring.getTypeElement().getFileObject());
    }

    public Problem preCheck() {
        return null;
    }

    public Problem fastCheckParameters() {
        if (this.refactoring.getTargetSuperType() == null) {
            return new Problem(true, NbBundle.getMessage(UseSuperTypeRefactoringPlugin.class, (String)"ERR_UseSuperTypeNoSuperType"));
        }
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    private void replaceSubtypeUsages(final TreePathHandle treePathHandle, final RefactoringElementsBag refactoringElementsBag) {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(CompilationController compilationController) throws IOException {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    FileObject fileObject = treePathHandle.getFileObject();
                    ClasspathInfo classpathInfo = JavaRefactoringUtils.getClasspathInfoFor(fileObject);
                    ClassIndex classIndex = classpathInfo.getClassIndex();
                    TypeElement typeElement = (TypeElement)treePathHandle.resolveElement((CompilationInfo)compilationController);
                    EnumSet<ClassIndex.SearchKind> enumSet = EnumSet.of(ClassIndex.SearchKind.TYPE_REFERENCES);
                    Set set = classIndex.getResources(ElementHandle.create((Element)typeElement), enumSet, EnumSet.of(ClassIndex.SearchScope.SOURCE));
                    if (!set.isEmpty()) {
                        UseSuperTypeRefactoringPlugin.this.fireProgressListenerStart(3, set.size());
                        try {
                            Collection collection = UseSuperTypeRefactoringPlugin.this.processFiles(set, (CancellableTask<WorkingCopy>)new FindRefTask(treePathHandle, UseSuperTypeRefactoringPlugin.this.refactoring.getTargetSuperType()));
                            refactoringElementsBag.registerTransaction((Transaction)new RetoucheCommit(collection));
                            for (ModificationResult modificationResult : collection) {
                                for (FileObject fileObject2 : modificationResult.getModifiedFileObjects()) {
                                    for (ModificationResult.Difference difference : modificationResult.getDifferences(fileObject2)) {
                                        String string = difference.getOldText();
                                        if (string == null) continue;
                                        refactoringElementsBag.add((AbstractRefactoring)UseSuperTypeRefactoringPlugin.this.refactoring, (RefactoringElementImplementation)DiffElement.create(difference, fileObject2, modificationResult));
                                    }
                                }
                            }
                        }
                        finally {
                            UseSuperTypeRefactoringPlugin.this.fireProgressListenerStop();
                        }
                    }
                }
            }, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static class ReferencesVisitor
    extends RefactoringVisitor {
        private final TypeElement superTypeElement;
        private final TypeElement subTypeElement;

        private ReferencesVisitor(WorkingCopy workingCopy, Element element, Element element2) {
            try {
                this.setWorkingCopy(workingCopy);
            }
            catch (ToPhaseException toPhaseException) {
                Exceptions.printStackTrace((Throwable)toPhaseException);
            }
            this.superTypeElement = (TypeElement)element2;
            this.subTypeElement = (TypeElement)element;
        }

        public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Element element) {
            Element element2 = this.asElement(memberSelectTree);
            if (element2 != null && this.isStatic(element2)) {
                Element element3 = this.asElement(memberSelectTree.getExpression());
                if (element3 == null || !ElementKind.CLASS.equals((Object)element3.getKind()) && !ElementKind.INTERFACE.equals((Object)element3.getKind())) {
                    return (Tree)super.visitMemberSelect(memberSelectTree, element);
                }
                TypeElement typeElement = (TypeElement)element3;
                if (!this.subTypeElement.equals(typeElement)) {
                    return (Tree)super.visitMemberSelect(memberSelectTree, element);
                }
                if (this.hidesSupTypeMember(element2, this.superTypeElement)) {
                    this.replaceType(memberSelectTree, this.superTypeElement);
                }
            }
            return (Tree)super.visitMemberSelect(memberSelectTree, element);
        }

        public Tree visitVariable(VariableTree variableTree, Element element) {
            TypeMirror typeMirror;
            TypeMirror typeMirror2;
            TreePath treePath = this.getCurrentPath();
            VariableElement variableElement = (VariableElement)this.workingCopy.getTrees().getElement(treePath);
            if (variableElement == null) {
                return (Tree)super.visitVariable(variableTree, element);
            }
            Types types = this.workingCopy.getTypes();
            if (types.isSameType(typeMirror2 = this.erasureOf(variableElement.asType()), typeMirror = this.erasureOf(element.asType())) && this.isReplaceCandidate(variableElement)) {
                this.replaceWithSuperType(variableTree, this.superTypeElement);
            }
            return (Tree)super.visitVariable(variableTree, element);
        }

        public Tree visitTypeCast(TypeCastTree typeCastTree, Element element) {
            VariableElement variableElement;
            TypeMirror typeMirror;
            TreePath treePath = this.getCurrentPath();
            Types types = this.workingCopy.getTypes();
            TypeMirror typeMirror2 = this.erasureOf(this.workingCopy.getTrees().getTypeMirror(treePath));
            TypeMirror typeMirror3 = this.erasureOf(element.asType());
            treePath = treePath.getParentPath();
            Element element2 = this.workingCopy.getTrees().getElement(treePath);
            if (element2 instanceof VariableElement && types.isSameType(typeMirror2, typeMirror3) && types.isSameType(typeMirror = this.erasureOf((variableElement = (VariableElement)element2).asType()), typeMirror3) && this.isReplaceCandidate(variableElement)) {
                TypeCastTree typeCastTree2 = this.make.TypeCast((Tree)this.make.Identifier((Element)this.superTypeElement), typeCastTree.getExpression());
                this.rewrite(typeCastTree, typeCastTree2);
            }
            return (Tree)super.visitTypeCast(typeCastTree, element2);
        }

        private boolean hidesSupTypeMember(Element element, TypeElement typeElement) {
            Elements elements = this.workingCopy.getElements();
            List<? extends Element> list = elements.getAllMembers(typeElement);
            for (Element element2 : list) {
                boolean bl;
                boolean bl2 = bl = ((Object)element).equals(element2) || elements.hides(element, element2);
                if (element2 == null || !this.isStatic(element2) || !bl) continue;
                return true;
            }
            return false;
        }

        private boolean isReplaceCandidate(VariableElement variableElement) {
            VarUsageVisitor varUsageVisitor = new VarUsageVisitor(this.subTypeElement, this.workingCopy, this.superTypeElement);
            varUsageVisitor.scan(this.workingCopy.getCompilationUnit(), variableElement);
            return varUsageVisitor.isReplaceCandidate();
        }

        private boolean isStatic(Element element) {
            Set<Modifier> set = element.getModifiers();
            return set.contains((Object)Modifier.STATIC);
        }

        private void replaceType(MemberSelectTree memberSelectTree, Element element) {
            MemberSelectTree memberSelectTree2 = this.make.MemberSelect((ExpressionTree)this.make.Identifier(element), (CharSequence)memberSelectTree.getIdentifier());
            this.rewrite(memberSelectTree, memberSelectTree2);
        }

        private void replaceWithSuperType(VariableTree variableTree, Element element) {
            TypeMirror typeMirror = this.erasureOf(element.asType());
            Tree tree = this.make.Type(typeMirror);
            ExpressionTree expressionTree = variableTree.getInitializer();
            ModifiersTree modifiersTree = variableTree.getModifiers();
            VariableTree variableTree2 = this.make.Variable(modifiersTree, (CharSequence)variableTree.getName(), tree, expressionTree);
            this.rewrite(variableTree, variableTree2);
        }

        private Element asElement(Tree tree) {
            Trees trees = this.workingCopy.getTrees();
            TreePath treePath = trees.getPath(this.workingCopy.getCompilationUnit(), tree);
            Element element = trees.getElement(treePath);
            return element;
        }

        private TypeMirror erasureOf(TypeMirror typeMirror) {
            Types types = this.workingCopy.getTypes();
            return types.erasure(typeMirror);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FindRefTask
    implements CancellableTask<WorkingCopy> {
        private final TreePathHandle subClassHandle;
        private final ElementHandle superClassHandle;

        private FindRefTask(TreePathHandle treePathHandle, ElementHandle elementHandle) {
            this.subClassHandle = treePathHandle;
            this.superClassHandle = elementHandle;
        }

        public void cancel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(WorkingCopy workingCopy) throws Exception {
            try {
                if (workingCopy.toPhase(JavaSource.Phase.RESOLVED) != JavaSource.Phase.RESOLVED) {
                    return;
                }
                CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                if (compilationUnitTree == null) {
                    ErrorManager.getDefault().log(65536, "compiler.getCompilationUnit() is null " + workingCopy);
                    return;
                }
                Element element = this.subClassHandle.resolveElement((CompilationInfo)workingCopy);
                Element element2 = this.superClassHandle.resolve((CompilationInfo)workingCopy);
                assert (element != null);
                ReferencesVisitor referencesVisitor = new ReferencesVisitor(workingCopy, element, element2);
                referencesVisitor.scan(workingCopy.getCompilationUnit(), element);
            }
            finally {
                UseSuperTypeRefactoringPlugin.this.fireProgressListenerStep();
            }
        }
    }
}

