/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.netbeans.modules.ruby.platform.execution.ExecutionService;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;

final class RerunAction
extends AbstractAction
implements FileChangeListener {
    private ExecutionService prototype;
    private FileObject fileObject;

    public RerunAction(ExecutionService executionService, FileObject fileObject) {
        this.prototype = executionService;
        this.setEnabled(false);
        this.fileObject = fileObject;
        if (fileObject != null) {
            fileObject.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)fileObject));
        }
    }

    public Object getValue(String string) {
        if (string.equals("SmallIcon")) {
            return new ImageIcon(ExecutionService.class.getResource("/org/netbeans/modules/ruby/platform/resources/rerun.png"));
        }
        if (string.equals("ShortDescription")) {
            return NbBundle.getMessage(ExecutionService.class, (String)"Rerun");
        }
        return super.getValue(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setEnabled(false);
        if (this.fileObject != null) {
            try {
                SaveCookie saveCookie;
                DataObject dataObject = DataObject.find((FileObject)this.fileObject);
                if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
                    saveCookie.save();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify((Throwable)dataObjectNotFoundException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
        this.prototype.rerun();
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.firePropertyChange("enabled", null, false);
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
    }

    public boolean isEnabled() {
        return super.isEnabled() && (this.fileObject == null || this.fileObject.isValid());
    }
}

